package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RouteDestinationBuilder extends RouteDestinationFluentImpl<RouteDestinationBuilder> implements VisitableBuilder<io.fabric8.istio.api.networking.v1alpha3.RouteDestination,RouteDestinationBuilder>{
  public RouteDestinationBuilder() {
    this(false);
  }
  public RouteDestinationBuilder(Boolean validationEnabled) {
    this(new RouteDestination(), validationEnabled);
  }
  public RouteDestinationBuilder(RouteDestinationFluent<?> fluent) {
    this(fluent, false);
  }
  public RouteDestinationBuilder(io.fabric8.istio.api.networking.v1alpha3.RouteDestinationFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new RouteDestination(), validationEnabled);
  }
  public RouteDestinationBuilder(io.fabric8.istio.api.networking.v1alpha3.RouteDestinationFluent<?> fluent,io.fabric8.istio.api.networking.v1alpha3.RouteDestination instance) {
    this(fluent, instance, false);
  }
  public RouteDestinationBuilder(io.fabric8.istio.api.networking.v1alpha3.RouteDestinationFluent<?> fluent,io.fabric8.istio.api.networking.v1alpha3.RouteDestination instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDestination(instance.getDestination()); 
    fluent.withWeight(instance.getWeight()); 
    this.validationEnabled = validationEnabled; 
  }
  public RouteDestinationBuilder(io.fabric8.istio.api.networking.v1alpha3.RouteDestination instance) {
    this(instance,false);
  }
  public RouteDestinationBuilder(io.fabric8.istio.api.networking.v1alpha3.RouteDestination instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withDestination(instance.getDestination()); 
    this.withWeight(instance.getWeight()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.istio.api.networking.v1alpha3.RouteDestinationFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.istio.api.networking.v1alpha3.RouteDestination build() {
    RouteDestination buildable = new RouteDestination(fluent.getDestination(),fluent.getWeight());
    return buildable;
  }
  
}