package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceEntryListBuilder extends ServiceEntryListFluentImpl<ServiceEntryListBuilder> implements VisitableBuilder<io.fabric8.istio.api.networking.v1alpha3.ServiceEntryList,io.fabric8.istio.api.networking.v1alpha3.ServiceEntryListBuilder>{
  public ServiceEntryListBuilder() {
    this(false);
  }
  public ServiceEntryListBuilder(Boolean validationEnabled) {
    this(new ServiceEntryList(), validationEnabled);
  }
  public ServiceEntryListBuilder(ServiceEntryListFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceEntryListBuilder(io.fabric8.istio.api.networking.v1alpha3.ServiceEntryListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ServiceEntryList(), validationEnabled);
  }
  public ServiceEntryListBuilder(io.fabric8.istio.api.networking.v1alpha3.ServiceEntryListFluent<?> fluent,io.fabric8.istio.api.networking.v1alpha3.ServiceEntryList instance) {
    this(fluent, instance, false);
  }
  public ServiceEntryListBuilder(io.fabric8.istio.api.networking.v1alpha3.ServiceEntryListFluent<?> fluent,io.fabric8.istio.api.networking.v1alpha3.ServiceEntryList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  public ServiceEntryListBuilder(io.fabric8.istio.api.networking.v1alpha3.ServiceEntryList instance) {
    this(instance,false);
  }
  public ServiceEntryListBuilder(io.fabric8.istio.api.networking.v1alpha3.ServiceEntryList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.istio.api.networking.v1alpha3.ServiceEntryListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.istio.api.networking.v1alpha3.ServiceEntryList build() {
    ServiceEntryList buildable = new ServiceEntryList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}