/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.networking.v1alpha1;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.HashMap;
import java.util.Map;

public enum EnvValueSource {
    INLINE(0),
    HOST(1);

    private final Integer value;
    private static final Map<Integer, EnvValueSource> CONSTANTS;
    private static final Map<String, EnvValueSource> NAME_CONSTANTS;

    private EnvValueSource(Integer value) {
        this.value = value;
    }

    @JsonCreator
    public static EnvValueSource fromValue(Object value) {
        if (value instanceof String) {
            EnvValueSource constant = NAME_CONSTANTS.get(((String)value).toLowerCase());
            if (constant == null) {
                throw new IllegalArgumentException(value + "");
            }
            return constant;
        }
        EnvValueSource constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value + "");
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<Integer, EnvValueSource>();
        NAME_CONSTANTS = new HashMap<String, EnvValueSource>();
        for (EnvValueSource c : EnvValueSource.values()) {
            CONSTANTS.put(c.value, c);
        }
        for (EnvValueSource c : EnvValueSource.values()) {
            NAME_CONSTANTS.put(c.name().toLowerCase(), c);
        }
    }
}

