/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.networking.v1alpha1;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.HashMap;
import java.util.Map;

public enum PluginType {
    UNSPECIFIED_PLUGIN_TYPE(0),
    HTTP(1),
    NETWORK(2);

    private final Integer value;
    private static final Map<Integer, PluginType> CONSTANTS;
    private static final Map<String, PluginType> NAME_CONSTANTS;

    private PluginType(Integer value) {
        this.value = value;
    }

    @JsonCreator
    public static PluginType fromValue(Object value) {
        if (value instanceof String) {
            PluginType constant = NAME_CONSTANTS.get(((String)value).toLowerCase());
            if (constant == null) {
                throw new IllegalArgumentException(value + "");
            }
            return constant;
        }
        PluginType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value + "");
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<Integer, PluginType>();
        NAME_CONSTANTS = new HashMap<String, PluginType>();
        for (PluginType c : PluginType.values()) {
            CONSTANTS.put(c.value, c);
        }
        for (PluginType c : PluginType.values()) {
            NAME_CONSTANTS.put(c.name().toLowerCase(), c);
        }
    }
}

