/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.istio.api.networking.v1alpha3.CorsPolicy;
import io.fabric8.istio.api.networking.v1alpha3.CorsPolicyBuilder;
import io.fabric8.istio.api.networking.v1alpha3.CorsPolicyFluent;
import io.fabric8.istio.api.networking.v1alpha3.Delegate;
import io.fabric8.istio.api.networking.v1alpha3.DelegateBuilder;
import io.fabric8.istio.api.networking.v1alpha3.DelegateFluent;
import io.fabric8.istio.api.networking.v1alpha3.Destination;
import io.fabric8.istio.api.networking.v1alpha3.DestinationBuilder;
import io.fabric8.istio.api.networking.v1alpha3.DestinationFluent;
import io.fabric8.istio.api.networking.v1alpha3.HTTPDirectResponse;
import io.fabric8.istio.api.networking.v1alpha3.HTTPDirectResponseBuilder;
import io.fabric8.istio.api.networking.v1alpha3.HTTPDirectResponseFluent;
import io.fabric8.istio.api.networking.v1alpha3.HTTPFaultInjection;
import io.fabric8.istio.api.networking.v1alpha3.HTTPFaultInjectionBuilder;
import io.fabric8.istio.api.networking.v1alpha3.HTTPFaultInjectionFluent;
import io.fabric8.istio.api.networking.v1alpha3.HTTPMatchRequest;
import io.fabric8.istio.api.networking.v1alpha3.HTTPMatchRequestBuilder;
import io.fabric8.istio.api.networking.v1alpha3.HTTPMatchRequestFluent;
import io.fabric8.istio.api.networking.v1alpha3.HTTPMirrorPolicy;
import io.fabric8.istio.api.networking.v1alpha3.HTTPMirrorPolicyBuilder;
import io.fabric8.istio.api.networking.v1alpha3.HTTPMirrorPolicyFluent;
import io.fabric8.istio.api.networking.v1alpha3.HTTPRedirect;
import io.fabric8.istio.api.networking.v1alpha3.HTTPRedirectBuilder;
import io.fabric8.istio.api.networking.v1alpha3.HTTPRedirectFluent;
import io.fabric8.istio.api.networking.v1alpha3.HTTPRetry;
import io.fabric8.istio.api.networking.v1alpha3.HTTPRetryBuilder;
import io.fabric8.istio.api.networking.v1alpha3.HTTPRetryFluent;
import io.fabric8.istio.api.networking.v1alpha3.HTTPRewrite;
import io.fabric8.istio.api.networking.v1alpha3.HTTPRewriteBuilder;
import io.fabric8.istio.api.networking.v1alpha3.HTTPRewriteFluent;
import io.fabric8.istio.api.networking.v1alpha3.HTTPRoute;
import io.fabric8.istio.api.networking.v1alpha3.HTTPRouteDestination;
import io.fabric8.istio.api.networking.v1alpha3.HTTPRouteDestinationBuilder;
import io.fabric8.istio.api.networking.v1alpha3.HTTPRouteDestinationFluent;
import io.fabric8.istio.api.networking.v1alpha3.Headers;
import io.fabric8.istio.api.networking.v1alpha3.HeadersBuilder;
import io.fabric8.istio.api.networking.v1alpha3.HeadersFluent;
import io.fabric8.istio.api.networking.v1alpha3.Percent;
import io.fabric8.istio.api.networking.v1alpha3.PercentBuilder;
import io.fabric8.istio.api.networking.v1alpha3.PercentFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class HTTPRouteFluent<A extends HTTPRouteFluent<A>>
extends BaseFluent<A> {
    private CorsPolicyBuilder corsPolicy;
    private DelegateBuilder delegate;
    private HTTPDirectResponseBuilder directResponse;
    private HTTPFaultInjectionBuilder fault;
    private HeadersBuilder headers;
    private ArrayList<HTTPMatchRequestBuilder> match = new ArrayList();
    private DestinationBuilder mirror;
    private Integer mirrorPercent;
    private PercentBuilder mirrorPercentage;
    private ArrayList<HTTPMirrorPolicyBuilder> mirrors = new ArrayList();
    private String name;
    private HTTPRedirectBuilder redirect;
    private HTTPRetryBuilder retries;
    private HTTPRewriteBuilder rewrite;
    private ArrayList<HTTPRouteDestinationBuilder> route = new ArrayList();
    private String timeout;
    private Map<String, Object> additionalProperties;

    public HTTPRouteFluent() {
    }

    public HTTPRouteFluent(HTTPRoute instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(HTTPRoute instance) {
        HTTPRoute hTTPRoute = instance = instance != null ? instance : new HTTPRoute();
        if (instance != null) {
            this.withCorsPolicy(instance.getCorsPolicy());
            this.withDelegate(instance.getDelegate());
            this.withDirectResponse(instance.getDirectResponse());
            this.withFault(instance.getFault());
            this.withHeaders(instance.getHeaders());
            this.withMatch(instance.getMatch());
            this.withMirror(instance.getMirror());
            this.withMirrorPercent(instance.getMirrorPercent());
            this.withMirrorPercentage(instance.getMirrorPercentage());
            this.withMirrors(instance.getMirrors());
            this.withName(instance.getName());
            this.withRedirect(instance.getRedirect());
            this.withRetries(instance.getRetries());
            this.withRewrite(instance.getRewrite());
            this.withRoute(instance.getRoute());
            this.withTimeout(instance.getTimeout());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public CorsPolicy buildCorsPolicy() {
        return this.corsPolicy != null ? this.corsPolicy.build() : null;
    }

    public A withCorsPolicy(CorsPolicy corsPolicy) {
        this._visitables.remove((Object)"corsPolicy");
        if (corsPolicy != null) {
            this.corsPolicy = new CorsPolicyBuilder(corsPolicy);
            this._visitables.get((Object)"corsPolicy").add(this.corsPolicy);
        } else {
            this.corsPolicy = null;
            this._visitables.get((Object)"corsPolicy").remove((Object)this.corsPolicy);
        }
        return (A)((Object)this);
    }

    public boolean hasCorsPolicy() {
        return this.corsPolicy != null;
    }

    public CorsPolicyNested<A> withNewCorsPolicy() {
        return new CorsPolicyNested(null);
    }

    public CorsPolicyNested<A> withNewCorsPolicyLike(CorsPolicy item) {
        return new CorsPolicyNested(item);
    }

    public CorsPolicyNested<A> editCorsPolicy() {
        return this.withNewCorsPolicyLike(Optional.ofNullable(this.buildCorsPolicy()).orElse(null));
    }

    public CorsPolicyNested<A> editOrNewCorsPolicy() {
        return this.withNewCorsPolicyLike(Optional.ofNullable(this.buildCorsPolicy()).orElse(new CorsPolicyBuilder().build()));
    }

    public CorsPolicyNested<A> editOrNewCorsPolicyLike(CorsPolicy item) {
        return this.withNewCorsPolicyLike(Optional.ofNullable(this.buildCorsPolicy()).orElse(item));
    }

    public Delegate buildDelegate() {
        return this.delegate != null ? this.delegate.build() : null;
    }

    public A withDelegate(Delegate delegate) {
        this._visitables.remove((Object)"delegate");
        if (delegate != null) {
            this.delegate = new DelegateBuilder(delegate);
            this._visitables.get((Object)"delegate").add(this.delegate);
        } else {
            this.delegate = null;
            this._visitables.get((Object)"delegate").remove((Object)this.delegate);
        }
        return (A)((Object)this);
    }

    public boolean hasDelegate() {
        return this.delegate != null;
    }

    public A withNewDelegate(String name, String namespace) {
        return this.withDelegate(new Delegate(name, namespace));
    }

    public DelegateNested<A> withNewDelegate() {
        return new DelegateNested(null);
    }

    public DelegateNested<A> withNewDelegateLike(Delegate item) {
        return new DelegateNested(item);
    }

    public DelegateNested<A> editDelegate() {
        return this.withNewDelegateLike(Optional.ofNullable(this.buildDelegate()).orElse(null));
    }

    public DelegateNested<A> editOrNewDelegate() {
        return this.withNewDelegateLike(Optional.ofNullable(this.buildDelegate()).orElse(new DelegateBuilder().build()));
    }

    public DelegateNested<A> editOrNewDelegateLike(Delegate item) {
        return this.withNewDelegateLike(Optional.ofNullable(this.buildDelegate()).orElse(item));
    }

    public HTTPDirectResponse buildDirectResponse() {
        return this.directResponse != null ? this.directResponse.build() : null;
    }

    public A withDirectResponse(HTTPDirectResponse directResponse) {
        this._visitables.remove((Object)"directResponse");
        if (directResponse != null) {
            this.directResponse = new HTTPDirectResponseBuilder(directResponse);
            this._visitables.get((Object)"directResponse").add(this.directResponse);
        } else {
            this.directResponse = null;
            this._visitables.get((Object)"directResponse").remove((Object)this.directResponse);
        }
        return (A)((Object)this);
    }

    public boolean hasDirectResponse() {
        return this.directResponse != null;
    }

    public DirectResponseNested<A> withNewDirectResponse() {
        return new DirectResponseNested(null);
    }

    public DirectResponseNested<A> withNewDirectResponseLike(HTTPDirectResponse item) {
        return new DirectResponseNested(item);
    }

    public DirectResponseNested<A> editDirectResponse() {
        return this.withNewDirectResponseLike(Optional.ofNullable(this.buildDirectResponse()).orElse(null));
    }

    public DirectResponseNested<A> editOrNewDirectResponse() {
        return this.withNewDirectResponseLike(Optional.ofNullable(this.buildDirectResponse()).orElse(new HTTPDirectResponseBuilder().build()));
    }

    public DirectResponseNested<A> editOrNewDirectResponseLike(HTTPDirectResponse item) {
        return this.withNewDirectResponseLike(Optional.ofNullable(this.buildDirectResponse()).orElse(item));
    }

    public HTTPFaultInjection buildFault() {
        return this.fault != null ? this.fault.build() : null;
    }

    public A withFault(HTTPFaultInjection fault) {
        this._visitables.remove((Object)"fault");
        if (fault != null) {
            this.fault = new HTTPFaultInjectionBuilder(fault);
            this._visitables.get((Object)"fault").add(this.fault);
        } else {
            this.fault = null;
            this._visitables.get((Object)"fault").remove((Object)this.fault);
        }
        return (A)((Object)this);
    }

    public boolean hasFault() {
        return this.fault != null;
    }

    public FaultNested<A> withNewFault() {
        return new FaultNested(null);
    }

    public FaultNested<A> withNewFaultLike(HTTPFaultInjection item) {
        return new FaultNested(item);
    }

    public FaultNested<A> editFault() {
        return this.withNewFaultLike(Optional.ofNullable(this.buildFault()).orElse(null));
    }

    public FaultNested<A> editOrNewFault() {
        return this.withNewFaultLike(Optional.ofNullable(this.buildFault()).orElse(new HTTPFaultInjectionBuilder().build()));
    }

    public FaultNested<A> editOrNewFaultLike(HTTPFaultInjection item) {
        return this.withNewFaultLike(Optional.ofNullable(this.buildFault()).orElse(item));
    }

    public Headers buildHeaders() {
        return this.headers != null ? this.headers.build() : null;
    }

    public A withHeaders(Headers headers) {
        this._visitables.remove((Object)"headers");
        if (headers != null) {
            this.headers = new HeadersBuilder(headers);
            this._visitables.get((Object)"headers").add(this.headers);
        } else {
            this.headers = null;
            this._visitables.get((Object)"headers").remove((Object)this.headers);
        }
        return (A)((Object)this);
    }

    public boolean hasHeaders() {
        return this.headers != null;
    }

    public HeadersNested<A> withNewHeaders() {
        return new HeadersNested(null);
    }

    public HeadersNested<A> withNewHeadersLike(Headers item) {
        return new HeadersNested(item);
    }

    public HeadersNested<A> editHeaders() {
        return this.withNewHeadersLike(Optional.ofNullable(this.buildHeaders()).orElse(null));
    }

    public HeadersNested<A> editOrNewHeaders() {
        return this.withNewHeadersLike(Optional.ofNullable(this.buildHeaders()).orElse(new HeadersBuilder().build()));
    }

    public HeadersNested<A> editOrNewHeadersLike(Headers item) {
        return this.withNewHeadersLike(Optional.ofNullable(this.buildHeaders()).orElse(item));
    }

    public A addToMatch(int index, HTTPMatchRequest item) {
        if (this.match == null) {
            this.match = new ArrayList();
        }
        HTTPMatchRequestBuilder builder = new HTTPMatchRequestBuilder(item);
        if (index < 0 || index >= this.match.size()) {
            this._visitables.get((Object)"match").add(builder);
            this.match.add(builder);
        } else {
            this._visitables.get((Object)"match").add(index, builder);
            this.match.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToMatch(int index, HTTPMatchRequest item) {
        if (this.match == null) {
            this.match = new ArrayList();
        }
        HTTPMatchRequestBuilder builder = new HTTPMatchRequestBuilder(item);
        if (index < 0 || index >= this.match.size()) {
            this._visitables.get((Object)"match").add(builder);
            this.match.add(builder);
        } else {
            this._visitables.get((Object)"match").set(index, builder);
            this.match.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToMatch(HTTPMatchRequest ... items) {
        if (this.match == null) {
            this.match = new ArrayList();
        }
        for (HTTPMatchRequest item : items) {
            HTTPMatchRequestBuilder builder = new HTTPMatchRequestBuilder(item);
            this._visitables.get((Object)"match").add(builder);
            this.match.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToMatch(Collection<HTTPMatchRequest> items) {
        if (this.match == null) {
            this.match = new ArrayList();
        }
        for (HTTPMatchRequest item : items) {
            HTTPMatchRequestBuilder builder = new HTTPMatchRequestBuilder(item);
            this._visitables.get((Object)"match").add(builder);
            this.match.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromMatch(HTTPMatchRequest ... items) {
        if (this.match == null) {
            return (A)((Object)this);
        }
        for (HTTPMatchRequest item : items) {
            HTTPMatchRequestBuilder builder = new HTTPMatchRequestBuilder(item);
            this._visitables.get((Object)"match").remove((Object)builder);
            this.match.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromMatch(Collection<HTTPMatchRequest> items) {
        if (this.match == null) {
            return (A)((Object)this);
        }
        for (HTTPMatchRequest item : items) {
            HTTPMatchRequestBuilder builder = new HTTPMatchRequestBuilder(item);
            this._visitables.get((Object)"match").remove((Object)builder);
            this.match.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromMatch(Predicate<HTTPMatchRequestBuilder> predicate) {
        if (this.match == null) {
            return (A)((Object)this);
        }
        Iterator<HTTPMatchRequestBuilder> each = this.match.iterator();
        List visitables = this._visitables.get((Object)"match");
        while (each.hasNext()) {
            HTTPMatchRequestBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<HTTPMatchRequest> buildMatch() {
        return this.match != null ? HTTPRouteFluent.build(this.match) : null;
    }

    public HTTPMatchRequest buildMatch(int index) {
        return this.match.get(index).build();
    }

    public HTTPMatchRequest buildFirstMatch() {
        return this.match.get(0).build();
    }

    public HTTPMatchRequest buildLastMatch() {
        return this.match.get(this.match.size() - 1).build();
    }

    public HTTPMatchRequest buildMatchingMatch(Predicate<HTTPMatchRequestBuilder> predicate) {
        for (HTTPMatchRequestBuilder item : this.match) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingMatch(Predicate<HTTPMatchRequestBuilder> predicate) {
        for (HTTPMatchRequestBuilder item : this.match) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withMatch(List<HTTPMatchRequest> match) {
        if (this.match != null) {
            this._visitables.get((Object)"match").clear();
        }
        if (match != null) {
            this.match = new ArrayList();
            for (HTTPMatchRequest item : match) {
                this.addToMatch(item);
            }
        } else {
            this.match = null;
        }
        return (A)((Object)this);
    }

    public A withMatch(HTTPMatchRequest ... match) {
        if (this.match != null) {
            this.match.clear();
            this._visitables.remove((Object)"match");
        }
        if (match != null) {
            for (HTTPMatchRequest item : match) {
                this.addToMatch(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasMatch() {
        return this.match != null && !this.match.isEmpty();
    }

    public MatchNested<A> addNewMatch() {
        return new MatchNested(-1, null);
    }

    public MatchNested<A> addNewMatchLike(HTTPMatchRequest item) {
        return new MatchNested(-1, item);
    }

    public MatchNested<A> setNewMatchLike(int index, HTTPMatchRequest item) {
        return new MatchNested(index, item);
    }

    public MatchNested<A> editMatch(int index) {
        if (this.match.size() <= index) {
            throw new RuntimeException("Can't edit match. Index exceeds size.");
        }
        return this.setNewMatchLike(index, this.buildMatch(index));
    }

    public MatchNested<A> editFirstMatch() {
        if (this.match.size() == 0) {
            throw new RuntimeException("Can't edit first match. The list is empty.");
        }
        return this.setNewMatchLike(0, this.buildMatch(0));
    }

    public MatchNested<A> editLastMatch() {
        int index = this.match.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last match. The list is empty.");
        }
        return this.setNewMatchLike(index, this.buildMatch(index));
    }

    public MatchNested<A> editMatchingMatch(Predicate<HTTPMatchRequestBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.match.size(); ++i) {
            if (!predicate.test(this.match.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching match. No match found.");
        }
        return this.setNewMatchLike(index, this.buildMatch(index));
    }

    public Destination buildMirror() {
        return this.mirror != null ? this.mirror.build() : null;
    }

    public A withMirror(Destination mirror) {
        this._visitables.remove((Object)"mirror");
        if (mirror != null) {
            this.mirror = new DestinationBuilder(mirror);
            this._visitables.get((Object)"mirror").add(this.mirror);
        } else {
            this.mirror = null;
            this._visitables.get((Object)"mirror").remove((Object)this.mirror);
        }
        return (A)((Object)this);
    }

    public boolean hasMirror() {
        return this.mirror != null;
    }

    public MirrorNested<A> withNewMirror() {
        return new MirrorNested(null);
    }

    public MirrorNested<A> withNewMirrorLike(Destination item) {
        return new MirrorNested(item);
    }

    public MirrorNested<A> editMirror() {
        return this.withNewMirrorLike(Optional.ofNullable(this.buildMirror()).orElse(null));
    }

    public MirrorNested<A> editOrNewMirror() {
        return this.withNewMirrorLike(Optional.ofNullable(this.buildMirror()).orElse(new DestinationBuilder().build()));
    }

    public MirrorNested<A> editOrNewMirrorLike(Destination item) {
        return this.withNewMirrorLike(Optional.ofNullable(this.buildMirror()).orElse(item));
    }

    public Integer getMirrorPercent() {
        return this.mirrorPercent;
    }

    public A withMirrorPercent(Integer mirrorPercent) {
        this.mirrorPercent = mirrorPercent;
        return (A)((Object)this);
    }

    public boolean hasMirrorPercent() {
        return this.mirrorPercent != null;
    }

    public Percent buildMirrorPercentage() {
        return this.mirrorPercentage != null ? this.mirrorPercentage.build() : null;
    }

    public A withMirrorPercentage(Percent mirrorPercentage) {
        this._visitables.remove((Object)"mirrorPercentage");
        if (mirrorPercentage != null) {
            this.mirrorPercentage = new PercentBuilder(mirrorPercentage);
            this._visitables.get((Object)"mirrorPercentage").add(this.mirrorPercentage);
        } else {
            this.mirrorPercentage = null;
            this._visitables.get((Object)"mirrorPercentage").remove((Object)this.mirrorPercentage);
        }
        return (A)((Object)this);
    }

    public boolean hasMirrorPercentage() {
        return this.mirrorPercentage != null;
    }

    public A withNewMirrorPercentage(Double value) {
        return this.withMirrorPercentage(new Percent(value));
    }

    public MirrorPercentageNested<A> withNewMirrorPercentage() {
        return new MirrorPercentageNested(null);
    }

    public MirrorPercentageNested<A> withNewMirrorPercentageLike(Percent item) {
        return new MirrorPercentageNested(item);
    }

    public MirrorPercentageNested<A> editMirrorPercentage() {
        return this.withNewMirrorPercentageLike(Optional.ofNullable(this.buildMirrorPercentage()).orElse(null));
    }

    public MirrorPercentageNested<A> editOrNewMirrorPercentage() {
        return this.withNewMirrorPercentageLike(Optional.ofNullable(this.buildMirrorPercentage()).orElse(new PercentBuilder().build()));
    }

    public MirrorPercentageNested<A> editOrNewMirrorPercentageLike(Percent item) {
        return this.withNewMirrorPercentageLike(Optional.ofNullable(this.buildMirrorPercentage()).orElse(item));
    }

    public A addToMirrors(int index, HTTPMirrorPolicy item) {
        if (this.mirrors == null) {
            this.mirrors = new ArrayList();
        }
        HTTPMirrorPolicyBuilder builder = new HTTPMirrorPolicyBuilder(item);
        if (index < 0 || index >= this.mirrors.size()) {
            this._visitables.get((Object)"mirrors").add(builder);
            this.mirrors.add(builder);
        } else {
            this._visitables.get((Object)"mirrors").add(index, builder);
            this.mirrors.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToMirrors(int index, HTTPMirrorPolicy item) {
        if (this.mirrors == null) {
            this.mirrors = new ArrayList();
        }
        HTTPMirrorPolicyBuilder builder = new HTTPMirrorPolicyBuilder(item);
        if (index < 0 || index >= this.mirrors.size()) {
            this._visitables.get((Object)"mirrors").add(builder);
            this.mirrors.add(builder);
        } else {
            this._visitables.get((Object)"mirrors").set(index, builder);
            this.mirrors.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToMirrors(HTTPMirrorPolicy ... items) {
        if (this.mirrors == null) {
            this.mirrors = new ArrayList();
        }
        for (HTTPMirrorPolicy item : items) {
            HTTPMirrorPolicyBuilder builder = new HTTPMirrorPolicyBuilder(item);
            this._visitables.get((Object)"mirrors").add(builder);
            this.mirrors.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToMirrors(Collection<HTTPMirrorPolicy> items) {
        if (this.mirrors == null) {
            this.mirrors = new ArrayList();
        }
        for (HTTPMirrorPolicy item : items) {
            HTTPMirrorPolicyBuilder builder = new HTTPMirrorPolicyBuilder(item);
            this._visitables.get((Object)"mirrors").add(builder);
            this.mirrors.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromMirrors(HTTPMirrorPolicy ... items) {
        if (this.mirrors == null) {
            return (A)((Object)this);
        }
        for (HTTPMirrorPolicy item : items) {
            HTTPMirrorPolicyBuilder builder = new HTTPMirrorPolicyBuilder(item);
            this._visitables.get((Object)"mirrors").remove((Object)builder);
            this.mirrors.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromMirrors(Collection<HTTPMirrorPolicy> items) {
        if (this.mirrors == null) {
            return (A)((Object)this);
        }
        for (HTTPMirrorPolicy item : items) {
            HTTPMirrorPolicyBuilder builder = new HTTPMirrorPolicyBuilder(item);
            this._visitables.get((Object)"mirrors").remove((Object)builder);
            this.mirrors.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromMirrors(Predicate<HTTPMirrorPolicyBuilder> predicate) {
        if (this.mirrors == null) {
            return (A)((Object)this);
        }
        Iterator<HTTPMirrorPolicyBuilder> each = this.mirrors.iterator();
        List visitables = this._visitables.get((Object)"mirrors");
        while (each.hasNext()) {
            HTTPMirrorPolicyBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<HTTPMirrorPolicy> buildMirrors() {
        return this.mirrors != null ? HTTPRouteFluent.build(this.mirrors) : null;
    }

    public HTTPMirrorPolicy buildMirror(int index) {
        return this.mirrors.get(index).build();
    }

    public HTTPMirrorPolicy buildFirstMirror() {
        return this.mirrors.get(0).build();
    }

    public HTTPMirrorPolicy buildLastMirror() {
        return this.mirrors.get(this.mirrors.size() - 1).build();
    }

    public HTTPMirrorPolicy buildMatchingMirror(Predicate<HTTPMirrorPolicyBuilder> predicate) {
        for (HTTPMirrorPolicyBuilder item : this.mirrors) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingMirror(Predicate<HTTPMirrorPolicyBuilder> predicate) {
        for (HTTPMirrorPolicyBuilder item : this.mirrors) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withMirrors(List<HTTPMirrorPolicy> mirrors) {
        if (this.mirrors != null) {
            this._visitables.get((Object)"mirrors").clear();
        }
        if (mirrors != null) {
            this.mirrors = new ArrayList();
            for (HTTPMirrorPolicy item : mirrors) {
                this.addToMirrors(item);
            }
        } else {
            this.mirrors = null;
        }
        return (A)((Object)this);
    }

    public A withMirrors(HTTPMirrorPolicy ... mirrors) {
        if (this.mirrors != null) {
            this.mirrors.clear();
            this._visitables.remove((Object)"mirrors");
        }
        if (mirrors != null) {
            for (HTTPMirrorPolicy item : mirrors) {
                this.addToMirrors(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasMirrors() {
        return this.mirrors != null && !this.mirrors.isEmpty();
    }

    public MirrorsNested<A> addNewMirror() {
        return new MirrorsNested(-1, null);
    }

    public MirrorsNested<A> addNewMirrorLike(HTTPMirrorPolicy item) {
        return new MirrorsNested(-1, item);
    }

    public MirrorsNested<A> setNewMirrorLike(int index, HTTPMirrorPolicy item) {
        return new MirrorsNested(index, item);
    }

    public MirrorsNested<A> editMirror(int index) {
        if (this.mirrors.size() <= index) {
            throw new RuntimeException("Can't edit mirrors. Index exceeds size.");
        }
        return this.setNewMirrorLike(index, this.buildMirror(index));
    }

    public MirrorsNested<A> editFirstMirror() {
        if (this.mirrors.size() == 0) {
            throw new RuntimeException("Can't edit first mirrors. The list is empty.");
        }
        return this.setNewMirrorLike(0, this.buildMirror(0));
    }

    public MirrorsNested<A> editLastMirror() {
        int index = this.mirrors.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last mirrors. The list is empty.");
        }
        return this.setNewMirrorLike(index, this.buildMirror(index));
    }

    public MirrorsNested<A> editMatchingMirror(Predicate<HTTPMirrorPolicyBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.mirrors.size(); ++i) {
            if (!predicate.test(this.mirrors.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching mirrors. No match found.");
        }
        return this.setNewMirrorLike(index, this.buildMirror(index));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public HTTPRedirect buildRedirect() {
        return this.redirect != null ? this.redirect.build() : null;
    }

    public A withRedirect(HTTPRedirect redirect) {
        this._visitables.remove((Object)"redirect");
        if (redirect != null) {
            this.redirect = new HTTPRedirectBuilder(redirect);
            this._visitables.get((Object)"redirect").add(this.redirect);
        } else {
            this.redirect = null;
            this._visitables.get((Object)"redirect").remove((Object)this.redirect);
        }
        return (A)((Object)this);
    }

    public boolean hasRedirect() {
        return this.redirect != null;
    }

    public RedirectNested<A> withNewRedirect() {
        return new RedirectNested(null);
    }

    public RedirectNested<A> withNewRedirectLike(HTTPRedirect item) {
        return new RedirectNested(item);
    }

    public RedirectNested<A> editRedirect() {
        return this.withNewRedirectLike(Optional.ofNullable(this.buildRedirect()).orElse(null));
    }

    public RedirectNested<A> editOrNewRedirect() {
        return this.withNewRedirectLike(Optional.ofNullable(this.buildRedirect()).orElse(new HTTPRedirectBuilder().build()));
    }

    public RedirectNested<A> editOrNewRedirectLike(HTTPRedirect item) {
        return this.withNewRedirectLike(Optional.ofNullable(this.buildRedirect()).orElse(item));
    }

    public HTTPRetry buildRetries() {
        return this.retries != null ? this.retries.build() : null;
    }

    public A withRetries(HTTPRetry retries) {
        this._visitables.remove((Object)"retries");
        if (retries != null) {
            this.retries = new HTTPRetryBuilder(retries);
            this._visitables.get((Object)"retries").add(this.retries);
        } else {
            this.retries = null;
            this._visitables.get((Object)"retries").remove((Object)this.retries);
        }
        return (A)((Object)this);
    }

    public boolean hasRetries() {
        return this.retries != null;
    }

    public A withNewRetries(Integer attempts, String perTryTimeout, String retryOn, Boolean retryRemoteLocalities) {
        return this.withRetries(new HTTPRetry(attempts, perTryTimeout, retryOn, retryRemoteLocalities));
    }

    public RetriesNested<A> withNewRetries() {
        return new RetriesNested(null);
    }

    public RetriesNested<A> withNewRetriesLike(HTTPRetry item) {
        return new RetriesNested(item);
    }

    public RetriesNested<A> editRetries() {
        return this.withNewRetriesLike(Optional.ofNullable(this.buildRetries()).orElse(null));
    }

    public RetriesNested<A> editOrNewRetries() {
        return this.withNewRetriesLike(Optional.ofNullable(this.buildRetries()).orElse(new HTTPRetryBuilder().build()));
    }

    public RetriesNested<A> editOrNewRetriesLike(HTTPRetry item) {
        return this.withNewRetriesLike(Optional.ofNullable(this.buildRetries()).orElse(item));
    }

    public HTTPRewrite buildRewrite() {
        return this.rewrite != null ? this.rewrite.build() : null;
    }

    public A withRewrite(HTTPRewrite rewrite) {
        this._visitables.remove((Object)"rewrite");
        if (rewrite != null) {
            this.rewrite = new HTTPRewriteBuilder(rewrite);
            this._visitables.get((Object)"rewrite").add(this.rewrite);
        } else {
            this.rewrite = null;
            this._visitables.get((Object)"rewrite").remove((Object)this.rewrite);
        }
        return (A)((Object)this);
    }

    public boolean hasRewrite() {
        return this.rewrite != null;
    }

    public RewriteNested<A> withNewRewrite() {
        return new RewriteNested(null);
    }

    public RewriteNested<A> withNewRewriteLike(HTTPRewrite item) {
        return new RewriteNested(item);
    }

    public RewriteNested<A> editRewrite() {
        return this.withNewRewriteLike(Optional.ofNullable(this.buildRewrite()).orElse(null));
    }

    public RewriteNested<A> editOrNewRewrite() {
        return this.withNewRewriteLike(Optional.ofNullable(this.buildRewrite()).orElse(new HTTPRewriteBuilder().build()));
    }

    public RewriteNested<A> editOrNewRewriteLike(HTTPRewrite item) {
        return this.withNewRewriteLike(Optional.ofNullable(this.buildRewrite()).orElse(item));
    }

    public A addToRoute(int index, HTTPRouteDestination item) {
        if (this.route == null) {
            this.route = new ArrayList();
        }
        HTTPRouteDestinationBuilder builder = new HTTPRouteDestinationBuilder(item);
        if (index < 0 || index >= this.route.size()) {
            this._visitables.get((Object)"route").add(builder);
            this.route.add(builder);
        } else {
            this._visitables.get((Object)"route").add(index, builder);
            this.route.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToRoute(int index, HTTPRouteDestination item) {
        if (this.route == null) {
            this.route = new ArrayList();
        }
        HTTPRouteDestinationBuilder builder = new HTTPRouteDestinationBuilder(item);
        if (index < 0 || index >= this.route.size()) {
            this._visitables.get((Object)"route").add(builder);
            this.route.add(builder);
        } else {
            this._visitables.get((Object)"route").set(index, builder);
            this.route.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToRoute(HTTPRouteDestination ... items) {
        if (this.route == null) {
            this.route = new ArrayList();
        }
        for (HTTPRouteDestination item : items) {
            HTTPRouteDestinationBuilder builder = new HTTPRouteDestinationBuilder(item);
            this._visitables.get((Object)"route").add(builder);
            this.route.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToRoute(Collection<HTTPRouteDestination> items) {
        if (this.route == null) {
            this.route = new ArrayList();
        }
        for (HTTPRouteDestination item : items) {
            HTTPRouteDestinationBuilder builder = new HTTPRouteDestinationBuilder(item);
            this._visitables.get((Object)"route").add(builder);
            this.route.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromRoute(HTTPRouteDestination ... items) {
        if (this.route == null) {
            return (A)((Object)this);
        }
        for (HTTPRouteDestination item : items) {
            HTTPRouteDestinationBuilder builder = new HTTPRouteDestinationBuilder(item);
            this._visitables.get((Object)"route").remove((Object)builder);
            this.route.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromRoute(Collection<HTTPRouteDestination> items) {
        if (this.route == null) {
            return (A)((Object)this);
        }
        for (HTTPRouteDestination item : items) {
            HTTPRouteDestinationBuilder builder = new HTTPRouteDestinationBuilder(item);
            this._visitables.get((Object)"route").remove((Object)builder);
            this.route.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromRoute(Predicate<HTTPRouteDestinationBuilder> predicate) {
        if (this.route == null) {
            return (A)((Object)this);
        }
        Iterator<HTTPRouteDestinationBuilder> each = this.route.iterator();
        List visitables = this._visitables.get((Object)"route");
        while (each.hasNext()) {
            HTTPRouteDestinationBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<HTTPRouteDestination> buildRoute() {
        return this.route != null ? HTTPRouteFluent.build(this.route) : null;
    }

    public HTTPRouteDestination buildRoute(int index) {
        return this.route.get(index).build();
    }

    public HTTPRouteDestination buildFirstRoute() {
        return this.route.get(0).build();
    }

    public HTTPRouteDestination buildLastRoute() {
        return this.route.get(this.route.size() - 1).build();
    }

    public HTTPRouteDestination buildMatchingRoute(Predicate<HTTPRouteDestinationBuilder> predicate) {
        for (HTTPRouteDestinationBuilder item : this.route) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingRoute(Predicate<HTTPRouteDestinationBuilder> predicate) {
        for (HTTPRouteDestinationBuilder item : this.route) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRoute(List<HTTPRouteDestination> route) {
        if (this.route != null) {
            this._visitables.get((Object)"route").clear();
        }
        if (route != null) {
            this.route = new ArrayList();
            for (HTTPRouteDestination item : route) {
                this.addToRoute(item);
            }
        } else {
            this.route = null;
        }
        return (A)((Object)this);
    }

    public A withRoute(HTTPRouteDestination ... route) {
        if (this.route != null) {
            this.route.clear();
            this._visitables.remove((Object)"route");
        }
        if (route != null) {
            for (HTTPRouteDestination item : route) {
                this.addToRoute(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasRoute() {
        return this.route != null && !this.route.isEmpty();
    }

    public RouteNested<A> addNewRoute() {
        return new RouteNested(-1, null);
    }

    public RouteNested<A> addNewRouteLike(HTTPRouteDestination item) {
        return new RouteNested(-1, item);
    }

    public RouteNested<A> setNewRouteLike(int index, HTTPRouteDestination item) {
        return new RouteNested(index, item);
    }

    public RouteNested<A> editRoute(int index) {
        if (this.route.size() <= index) {
            throw new RuntimeException("Can't edit route. Index exceeds size.");
        }
        return this.setNewRouteLike(index, this.buildRoute(index));
    }

    public RouteNested<A> editFirstRoute() {
        if (this.route.size() == 0) {
            throw new RuntimeException("Can't edit first route. The list is empty.");
        }
        return this.setNewRouteLike(0, this.buildRoute(0));
    }

    public RouteNested<A> editLastRoute() {
        int index = this.route.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last route. The list is empty.");
        }
        return this.setNewRouteLike(index, this.buildRoute(index));
    }

    public RouteNested<A> editMatchingRoute(Predicate<HTTPRouteDestinationBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.route.size(); ++i) {
            if (!predicate.test(this.route.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching route. No match found.");
        }
        return this.setNewRouteLike(index, this.buildRoute(index));
    }

    public String getTimeout() {
        return this.timeout;
    }

    public A withTimeout(String timeout) {
        this.timeout = timeout;
        return (A)((Object)this);
    }

    public boolean hasTimeout() {
        return this.timeout != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HTTPRouteFluent that = (HTTPRouteFluent)((Object)o);
        if (!Objects.equals((Object)this.corsPolicy, (Object)that.corsPolicy)) {
            return false;
        }
        if (!Objects.equals((Object)this.delegate, (Object)that.delegate)) {
            return false;
        }
        if (!Objects.equals((Object)this.directResponse, (Object)that.directResponse)) {
            return false;
        }
        if (!Objects.equals((Object)this.fault, (Object)that.fault)) {
            return false;
        }
        if (!Objects.equals((Object)this.headers, (Object)that.headers)) {
            return false;
        }
        if (!Objects.equals(this.match, that.match)) {
            return false;
        }
        if (!Objects.equals((Object)this.mirror, (Object)that.mirror)) {
            return false;
        }
        if (!Objects.equals(this.mirrorPercent, that.mirrorPercent)) {
            return false;
        }
        if (!Objects.equals((Object)this.mirrorPercentage, (Object)that.mirrorPercentage)) {
            return false;
        }
        if (!Objects.equals(this.mirrors, that.mirrors)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals((Object)this.redirect, (Object)that.redirect)) {
            return false;
        }
        if (!Objects.equals((Object)this.retries, (Object)that.retries)) {
            return false;
        }
        if (!Objects.equals((Object)this.rewrite, (Object)that.rewrite)) {
            return false;
        }
        if (!Objects.equals(this.route, that.route)) {
            return false;
        }
        if (!Objects.equals(this.timeout, that.timeout)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.corsPolicy, this.delegate, this.directResponse, this.fault, this.headers, this.match, this.mirror, this.mirrorPercent, this.mirrorPercentage, this.mirrors, this.name, this.redirect, this.retries, this.rewrite, this.route, this.timeout, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.corsPolicy != null) {
            sb.append("corsPolicy:");
            sb.append((Object)((Object)this.corsPolicy) + ",");
        }
        if (this.delegate != null) {
            sb.append("delegate:");
            sb.append((Object)((Object)this.delegate) + ",");
        }
        if (this.directResponse != null) {
            sb.append("directResponse:");
            sb.append((Object)((Object)this.directResponse) + ",");
        }
        if (this.fault != null) {
            sb.append("fault:");
            sb.append((Object)((Object)this.fault) + ",");
        }
        if (this.headers != null) {
            sb.append("headers:");
            sb.append((Object)((Object)this.headers) + ",");
        }
        if (this.match != null && !this.match.isEmpty()) {
            sb.append("match:");
            sb.append(this.match + ",");
        }
        if (this.mirror != null) {
            sb.append("mirror:");
            sb.append((Object)((Object)this.mirror) + ",");
        }
        if (this.mirrorPercent != null) {
            sb.append("mirrorPercent:");
            sb.append(this.mirrorPercent + ",");
        }
        if (this.mirrorPercentage != null) {
            sb.append("mirrorPercentage:");
            sb.append((Object)((Object)this.mirrorPercentage) + ",");
        }
        if (this.mirrors != null && !this.mirrors.isEmpty()) {
            sb.append("mirrors:");
            sb.append(this.mirrors + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.redirect != null) {
            sb.append("redirect:");
            sb.append((Object)((Object)this.redirect) + ",");
        }
        if (this.retries != null) {
            sb.append("retries:");
            sb.append((Object)((Object)this.retries) + ",");
        }
        if (this.rewrite != null) {
            sb.append("rewrite:");
            sb.append((Object)((Object)this.rewrite) + ",");
        }
        if (this.route != null && !this.route.isEmpty()) {
            sb.append("route:");
            sb.append(this.route + ",");
        }
        if (this.timeout != null) {
            sb.append("timeout:");
            sb.append(this.timeout + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class RouteNested<N>
    extends HTTPRouteDestinationFluent<RouteNested<N>>
    implements Nested<N> {
        HTTPRouteDestinationBuilder builder;
        int index;

        RouteNested(int index, HTTPRouteDestination item) {
            this.index = index;
            this.builder = new HTTPRouteDestinationBuilder(this, item);
        }

        public N and() {
            return (N)HTTPRouteFluent.this.setToRoute(this.index, this.builder.build());
        }

        public N endRoute() {
            return this.and();
        }
    }

    public class RewriteNested<N>
    extends HTTPRewriteFluent<RewriteNested<N>>
    implements Nested<N> {
        HTTPRewriteBuilder builder;

        RewriteNested(HTTPRewrite item) {
            this.builder = new HTTPRewriteBuilder(this, item);
        }

        public N and() {
            return (N)HTTPRouteFluent.this.withRewrite(this.builder.build());
        }

        public N endRewrite() {
            return this.and();
        }
    }

    public class RetriesNested<N>
    extends HTTPRetryFluent<RetriesNested<N>>
    implements Nested<N> {
        HTTPRetryBuilder builder;

        RetriesNested(HTTPRetry item) {
            this.builder = new HTTPRetryBuilder(this, item);
        }

        public N and() {
            return (N)HTTPRouteFluent.this.withRetries(this.builder.build());
        }

        public N endRetries() {
            return this.and();
        }
    }

    public class RedirectNested<N>
    extends HTTPRedirectFluent<RedirectNested<N>>
    implements Nested<N> {
        HTTPRedirectBuilder builder;

        RedirectNested(HTTPRedirect item) {
            this.builder = new HTTPRedirectBuilder(this, item);
        }

        public N and() {
            return (N)HTTPRouteFluent.this.withRedirect(this.builder.build());
        }

        public N endRedirect() {
            return this.and();
        }
    }

    public class MirrorsNested<N>
    extends HTTPMirrorPolicyFluent<MirrorsNested<N>>
    implements Nested<N> {
        HTTPMirrorPolicyBuilder builder;
        int index;

        MirrorsNested(int index, HTTPMirrorPolicy item) {
            this.index = index;
            this.builder = new HTTPMirrorPolicyBuilder(this, item);
        }

        public N and() {
            return (N)HTTPRouteFluent.this.setToMirrors(this.index, this.builder.build());
        }

        public N endMirror() {
            return this.and();
        }
    }

    public class MirrorPercentageNested<N>
    extends PercentFluent<MirrorPercentageNested<N>>
    implements Nested<N> {
        PercentBuilder builder;

        MirrorPercentageNested(Percent item) {
            this.builder = new PercentBuilder(this, item);
        }

        public N and() {
            return (N)HTTPRouteFluent.this.withMirrorPercentage(this.builder.build());
        }

        public N endMirrorPercentage() {
            return this.and();
        }
    }

    public class MirrorNested<N>
    extends DestinationFluent<MirrorNested<N>>
    implements Nested<N> {
        DestinationBuilder builder;

        MirrorNested(Destination item) {
            this.builder = new DestinationBuilder(this, item);
        }

        public N and() {
            return (N)HTTPRouteFluent.this.withMirror(this.builder.build());
        }

        public N endMirror() {
            return this.and();
        }
    }

    public class MatchNested<N>
    extends HTTPMatchRequestFluent<MatchNested<N>>
    implements Nested<N> {
        HTTPMatchRequestBuilder builder;
        int index;

        MatchNested(int index, HTTPMatchRequest item) {
            this.index = index;
            this.builder = new HTTPMatchRequestBuilder(this, item);
        }

        public N and() {
            return (N)HTTPRouteFluent.this.setToMatch(this.index, this.builder.build());
        }

        public N endMatch() {
            return this.and();
        }
    }

    public class HeadersNested<N>
    extends HeadersFluent<HeadersNested<N>>
    implements Nested<N> {
        HeadersBuilder builder;

        HeadersNested(Headers item) {
            this.builder = new HeadersBuilder(this, item);
        }

        public N and() {
            return (N)HTTPRouteFluent.this.withHeaders(this.builder.build());
        }

        public N endHeaders() {
            return this.and();
        }
    }

    public class FaultNested<N>
    extends HTTPFaultInjectionFluent<FaultNested<N>>
    implements Nested<N> {
        HTTPFaultInjectionBuilder builder;

        FaultNested(HTTPFaultInjection item) {
            this.builder = new HTTPFaultInjectionBuilder(this, item);
        }

        public N and() {
            return (N)HTTPRouteFluent.this.withFault(this.builder.build());
        }

        public N endFault() {
            return this.and();
        }
    }

    public class DirectResponseNested<N>
    extends HTTPDirectResponseFluent<DirectResponseNested<N>>
    implements Nested<N> {
        HTTPDirectResponseBuilder builder;

        DirectResponseNested(HTTPDirectResponse item) {
            this.builder = new HTTPDirectResponseBuilder(this, item);
        }

        public N and() {
            return (N)HTTPRouteFluent.this.withDirectResponse(this.builder.build());
        }

        public N endDirectResponse() {
            return this.and();
        }
    }

    public class DelegateNested<N>
    extends DelegateFluent<DelegateNested<N>>
    implements Nested<N> {
        DelegateBuilder builder;

        DelegateNested(Delegate item) {
            this.builder = new DelegateBuilder(this, item);
        }

        public N and() {
            return (N)HTTPRouteFluent.this.withDelegate(this.builder.build());
        }

        public N endDelegate() {
            return this.and();
        }
    }

    public class CorsPolicyNested<N>
    extends CorsPolicyFluent<CorsPolicyNested<N>>
    implements Nested<N> {
        CorsPolicyBuilder builder;

        CorsPolicyNested(CorsPolicy item) {
            this.builder = new CorsPolicyBuilder(this, item);
        }

        public N and() {
            return (N)HTTPRouteFluent.this.withCorsPolicy(this.builder.build());
        }

        public N endCorsPolicy() {
            return this.and();
        }
    }
}

