/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.istio.api.networking.v1alpha3.ClientTLSSettings;
import io.fabric8.istio.api.networking.v1alpha3.ClientTLSSettingsBuilder;
import io.fabric8.istio.api.networking.v1alpha3.ClientTLSSettingsFluent;
import io.fabric8.istio.api.networking.v1alpha3.ConnectionPoolSettings;
import io.fabric8.istio.api.networking.v1alpha3.ConnectionPoolSettingsBuilder;
import io.fabric8.istio.api.networking.v1alpha3.ConnectionPoolSettingsFluent;
import io.fabric8.istio.api.networking.v1alpha3.LoadBalancerSettings;
import io.fabric8.istio.api.networking.v1alpha3.LoadBalancerSettingsBuilder;
import io.fabric8.istio.api.networking.v1alpha3.LoadBalancerSettingsFluent;
import io.fabric8.istio.api.networking.v1alpha3.OutlierDetection;
import io.fabric8.istio.api.networking.v1alpha3.OutlierDetectionBuilder;
import io.fabric8.istio.api.networking.v1alpha3.OutlierDetectionFluent;
import io.fabric8.istio.api.networking.v1alpha3.TrafficPolicy;
import io.fabric8.istio.api.networking.v1alpha3.TrafficPolicyPortTrafficPolicy;
import io.fabric8.istio.api.networking.v1alpha3.TrafficPolicyPortTrafficPolicyBuilder;
import io.fabric8.istio.api.networking.v1alpha3.TrafficPolicyPortTrafficPolicyFluent;
import io.fabric8.istio.api.networking.v1alpha3.TrafficPolicyProxyProtocol;
import io.fabric8.istio.api.networking.v1alpha3.TrafficPolicyProxyProtocolBuilder;
import io.fabric8.istio.api.networking.v1alpha3.TrafficPolicyProxyProtocolFluent;
import io.fabric8.istio.api.networking.v1alpha3.TrafficPolicyTunnelSettings;
import io.fabric8.istio.api.networking.v1alpha3.TrafficPolicyTunnelSettingsBuilder;
import io.fabric8.istio.api.networking.v1alpha3.TrafficPolicyTunnelSettingsFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class TrafficPolicyFluent<A extends TrafficPolicyFluent<A>>
extends BaseFluent<A> {
    private ConnectionPoolSettingsBuilder connectionPool;
    private LoadBalancerSettingsBuilder loadBalancer;
    private OutlierDetectionBuilder outlierDetection;
    private ArrayList<TrafficPolicyPortTrafficPolicyBuilder> portLevelSettings = new ArrayList();
    private TrafficPolicyProxyProtocolBuilder proxyProtocol;
    private ClientTLSSettingsBuilder tls;
    private TrafficPolicyTunnelSettingsBuilder tunnel;
    private Map<String, Object> additionalProperties;

    public TrafficPolicyFluent() {
    }

    public TrafficPolicyFluent(TrafficPolicy instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(TrafficPolicy instance) {
        TrafficPolicy trafficPolicy = instance = instance != null ? instance : new TrafficPolicy();
        if (instance != null) {
            this.withConnectionPool(instance.getConnectionPool());
            this.withLoadBalancer(instance.getLoadBalancer());
            this.withOutlierDetection(instance.getOutlierDetection());
            this.withPortLevelSettings(instance.getPortLevelSettings());
            this.withProxyProtocol(instance.getProxyProtocol());
            this.withTls(instance.getTls());
            this.withTunnel(instance.getTunnel());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ConnectionPoolSettings buildConnectionPool() {
        return this.connectionPool != null ? this.connectionPool.build() : null;
    }

    public A withConnectionPool(ConnectionPoolSettings connectionPool) {
        this._visitables.remove((Object)"connectionPool");
        if (connectionPool != null) {
            this.connectionPool = new ConnectionPoolSettingsBuilder(connectionPool);
            this._visitables.get((Object)"connectionPool").add(this.connectionPool);
        } else {
            this.connectionPool = null;
            this._visitables.get((Object)"connectionPool").remove((Object)this.connectionPool);
        }
        return (A)((Object)this);
    }

    public boolean hasConnectionPool() {
        return this.connectionPool != null;
    }

    public ConnectionPoolNested<A> withNewConnectionPool() {
        return new ConnectionPoolNested(null);
    }

    public ConnectionPoolNested<A> withNewConnectionPoolLike(ConnectionPoolSettings item) {
        return new ConnectionPoolNested(item);
    }

    public ConnectionPoolNested<A> editConnectionPool() {
        return this.withNewConnectionPoolLike(Optional.ofNullable(this.buildConnectionPool()).orElse(null));
    }

    public ConnectionPoolNested<A> editOrNewConnectionPool() {
        return this.withNewConnectionPoolLike(Optional.ofNullable(this.buildConnectionPool()).orElse(new ConnectionPoolSettingsBuilder().build()));
    }

    public ConnectionPoolNested<A> editOrNewConnectionPoolLike(ConnectionPoolSettings item) {
        return this.withNewConnectionPoolLike(Optional.ofNullable(this.buildConnectionPool()).orElse(item));
    }

    public LoadBalancerSettings buildLoadBalancer() {
        return this.loadBalancer != null ? this.loadBalancer.build() : null;
    }

    public A withLoadBalancer(LoadBalancerSettings loadBalancer) {
        this._visitables.remove((Object)"loadBalancer");
        if (loadBalancer != null) {
            this.loadBalancer = new LoadBalancerSettingsBuilder(loadBalancer);
            this._visitables.get((Object)"loadBalancer").add(this.loadBalancer);
        } else {
            this.loadBalancer = null;
            this._visitables.get((Object)"loadBalancer").remove((Object)this.loadBalancer);
        }
        return (A)((Object)this);
    }

    public boolean hasLoadBalancer() {
        return this.loadBalancer != null;
    }

    public LoadBalancerNested<A> withNewLoadBalancer() {
        return new LoadBalancerNested(null);
    }

    public LoadBalancerNested<A> withNewLoadBalancerLike(LoadBalancerSettings item) {
        return new LoadBalancerNested(item);
    }

    public LoadBalancerNested<A> editLoadBalancer() {
        return this.withNewLoadBalancerLike(Optional.ofNullable(this.buildLoadBalancer()).orElse(null));
    }

    public LoadBalancerNested<A> editOrNewLoadBalancer() {
        return this.withNewLoadBalancerLike(Optional.ofNullable(this.buildLoadBalancer()).orElse(new LoadBalancerSettingsBuilder().build()));
    }

    public LoadBalancerNested<A> editOrNewLoadBalancerLike(LoadBalancerSettings item) {
        return this.withNewLoadBalancerLike(Optional.ofNullable(this.buildLoadBalancer()).orElse(item));
    }

    public OutlierDetection buildOutlierDetection() {
        return this.outlierDetection != null ? this.outlierDetection.build() : null;
    }

    public A withOutlierDetection(OutlierDetection outlierDetection) {
        this._visitables.remove((Object)"outlierDetection");
        if (outlierDetection != null) {
            this.outlierDetection = new OutlierDetectionBuilder(outlierDetection);
            this._visitables.get((Object)"outlierDetection").add(this.outlierDetection);
        } else {
            this.outlierDetection = null;
            this._visitables.get((Object)"outlierDetection").remove((Object)this.outlierDetection);
        }
        return (A)((Object)this);
    }

    public boolean hasOutlierDetection() {
        return this.outlierDetection != null;
    }

    public OutlierDetectionNested<A> withNewOutlierDetection() {
        return new OutlierDetectionNested(null);
    }

    public OutlierDetectionNested<A> withNewOutlierDetectionLike(OutlierDetection item) {
        return new OutlierDetectionNested(item);
    }

    public OutlierDetectionNested<A> editOutlierDetection() {
        return this.withNewOutlierDetectionLike(Optional.ofNullable(this.buildOutlierDetection()).orElse(null));
    }

    public OutlierDetectionNested<A> editOrNewOutlierDetection() {
        return this.withNewOutlierDetectionLike(Optional.ofNullable(this.buildOutlierDetection()).orElse(new OutlierDetectionBuilder().build()));
    }

    public OutlierDetectionNested<A> editOrNewOutlierDetectionLike(OutlierDetection item) {
        return this.withNewOutlierDetectionLike(Optional.ofNullable(this.buildOutlierDetection()).orElse(item));
    }

    public A addToPortLevelSettings(int index, TrafficPolicyPortTrafficPolicy item) {
        if (this.portLevelSettings == null) {
            this.portLevelSettings = new ArrayList();
        }
        TrafficPolicyPortTrafficPolicyBuilder builder = new TrafficPolicyPortTrafficPolicyBuilder(item);
        if (index < 0 || index >= this.portLevelSettings.size()) {
            this._visitables.get((Object)"portLevelSettings").add(builder);
            this.portLevelSettings.add(builder);
        } else {
            this._visitables.get((Object)"portLevelSettings").add(index, builder);
            this.portLevelSettings.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToPortLevelSettings(int index, TrafficPolicyPortTrafficPolicy item) {
        if (this.portLevelSettings == null) {
            this.portLevelSettings = new ArrayList();
        }
        TrafficPolicyPortTrafficPolicyBuilder builder = new TrafficPolicyPortTrafficPolicyBuilder(item);
        if (index < 0 || index >= this.portLevelSettings.size()) {
            this._visitables.get((Object)"portLevelSettings").add(builder);
            this.portLevelSettings.add(builder);
        } else {
            this._visitables.get((Object)"portLevelSettings").set(index, builder);
            this.portLevelSettings.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToPortLevelSettings(TrafficPolicyPortTrafficPolicy ... items) {
        if (this.portLevelSettings == null) {
            this.portLevelSettings = new ArrayList();
        }
        for (TrafficPolicyPortTrafficPolicy item : items) {
            TrafficPolicyPortTrafficPolicyBuilder builder = new TrafficPolicyPortTrafficPolicyBuilder(item);
            this._visitables.get((Object)"portLevelSettings").add(builder);
            this.portLevelSettings.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToPortLevelSettings(Collection<TrafficPolicyPortTrafficPolicy> items) {
        if (this.portLevelSettings == null) {
            this.portLevelSettings = new ArrayList();
        }
        for (TrafficPolicyPortTrafficPolicy item : items) {
            TrafficPolicyPortTrafficPolicyBuilder builder = new TrafficPolicyPortTrafficPolicyBuilder(item);
            this._visitables.get((Object)"portLevelSettings").add(builder);
            this.portLevelSettings.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromPortLevelSettings(TrafficPolicyPortTrafficPolicy ... items) {
        if (this.portLevelSettings == null) {
            return (A)((Object)this);
        }
        for (TrafficPolicyPortTrafficPolicy item : items) {
            TrafficPolicyPortTrafficPolicyBuilder builder = new TrafficPolicyPortTrafficPolicyBuilder(item);
            this._visitables.get((Object)"portLevelSettings").remove((Object)builder);
            this.portLevelSettings.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPortLevelSettings(Collection<TrafficPolicyPortTrafficPolicy> items) {
        if (this.portLevelSettings == null) {
            return (A)((Object)this);
        }
        for (TrafficPolicyPortTrafficPolicy item : items) {
            TrafficPolicyPortTrafficPolicyBuilder builder = new TrafficPolicyPortTrafficPolicyBuilder(item);
            this._visitables.get((Object)"portLevelSettings").remove((Object)builder);
            this.portLevelSettings.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromPortLevelSettings(Predicate<TrafficPolicyPortTrafficPolicyBuilder> predicate) {
        if (this.portLevelSettings == null) {
            return (A)((Object)this);
        }
        Iterator<TrafficPolicyPortTrafficPolicyBuilder> each = this.portLevelSettings.iterator();
        List visitables = this._visitables.get((Object)"portLevelSettings");
        while (each.hasNext()) {
            TrafficPolicyPortTrafficPolicyBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<TrafficPolicyPortTrafficPolicy> buildPortLevelSettings() {
        return this.portLevelSettings != null ? TrafficPolicyFluent.build(this.portLevelSettings) : null;
    }

    public TrafficPolicyPortTrafficPolicy buildPortLevelSetting(int index) {
        return this.portLevelSettings.get(index).build();
    }

    public TrafficPolicyPortTrafficPolicy buildFirstPortLevelSetting() {
        return this.portLevelSettings.get(0).build();
    }

    public TrafficPolicyPortTrafficPolicy buildLastPortLevelSetting() {
        return this.portLevelSettings.get(this.portLevelSettings.size() - 1).build();
    }

    public TrafficPolicyPortTrafficPolicy buildMatchingPortLevelSetting(Predicate<TrafficPolicyPortTrafficPolicyBuilder> predicate) {
        for (TrafficPolicyPortTrafficPolicyBuilder item : this.portLevelSettings) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPortLevelSetting(Predicate<TrafficPolicyPortTrafficPolicyBuilder> predicate) {
        for (TrafficPolicyPortTrafficPolicyBuilder item : this.portLevelSettings) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPortLevelSettings(List<TrafficPolicyPortTrafficPolicy> portLevelSettings) {
        if (this.portLevelSettings != null) {
            this._visitables.get((Object)"portLevelSettings").clear();
        }
        if (portLevelSettings != null) {
            this.portLevelSettings = new ArrayList();
            for (TrafficPolicyPortTrafficPolicy item : portLevelSettings) {
                this.addToPortLevelSettings(item);
            }
        } else {
            this.portLevelSettings = null;
        }
        return (A)((Object)this);
    }

    public A withPortLevelSettings(TrafficPolicyPortTrafficPolicy ... portLevelSettings) {
        if (this.portLevelSettings != null) {
            this.portLevelSettings.clear();
            this._visitables.remove((Object)"portLevelSettings");
        }
        if (portLevelSettings != null) {
            for (TrafficPolicyPortTrafficPolicy item : portLevelSettings) {
                this.addToPortLevelSettings(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasPortLevelSettings() {
        return this.portLevelSettings != null && !this.portLevelSettings.isEmpty();
    }

    public PortLevelSettingsNested<A> addNewPortLevelSetting() {
        return new PortLevelSettingsNested(-1, null);
    }

    public PortLevelSettingsNested<A> addNewPortLevelSettingLike(TrafficPolicyPortTrafficPolicy item) {
        return new PortLevelSettingsNested(-1, item);
    }

    public PortLevelSettingsNested<A> setNewPortLevelSettingLike(int index, TrafficPolicyPortTrafficPolicy item) {
        return new PortLevelSettingsNested(index, item);
    }

    public PortLevelSettingsNested<A> editPortLevelSetting(int index) {
        if (this.portLevelSettings.size() <= index) {
            throw new RuntimeException("Can't edit portLevelSettings. Index exceeds size.");
        }
        return this.setNewPortLevelSettingLike(index, this.buildPortLevelSetting(index));
    }

    public PortLevelSettingsNested<A> editFirstPortLevelSetting() {
        if (this.portLevelSettings.size() == 0) {
            throw new RuntimeException("Can't edit first portLevelSettings. The list is empty.");
        }
        return this.setNewPortLevelSettingLike(0, this.buildPortLevelSetting(0));
    }

    public PortLevelSettingsNested<A> editLastPortLevelSetting() {
        int index = this.portLevelSettings.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last portLevelSettings. The list is empty.");
        }
        return this.setNewPortLevelSettingLike(index, this.buildPortLevelSetting(index));
    }

    public PortLevelSettingsNested<A> editMatchingPortLevelSetting(Predicate<TrafficPolicyPortTrafficPolicyBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.portLevelSettings.size(); ++i) {
            if (!predicate.test(this.portLevelSettings.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching portLevelSettings. No match found.");
        }
        return this.setNewPortLevelSettingLike(index, this.buildPortLevelSetting(index));
    }

    public TrafficPolicyProxyProtocol buildProxyProtocol() {
        return this.proxyProtocol != null ? this.proxyProtocol.build() : null;
    }

    public A withProxyProtocol(TrafficPolicyProxyProtocol proxyProtocol) {
        this._visitables.remove((Object)"proxyProtocol");
        if (proxyProtocol != null) {
            this.proxyProtocol = new TrafficPolicyProxyProtocolBuilder(proxyProtocol);
            this._visitables.get((Object)"proxyProtocol").add(this.proxyProtocol);
        } else {
            this.proxyProtocol = null;
            this._visitables.get((Object)"proxyProtocol").remove((Object)this.proxyProtocol);
        }
        return (A)((Object)this);
    }

    public boolean hasProxyProtocol() {
        return this.proxyProtocol != null;
    }

    public ProxyProtocolNested<A> withNewProxyProtocol() {
        return new ProxyProtocolNested(null);
    }

    public ProxyProtocolNested<A> withNewProxyProtocolLike(TrafficPolicyProxyProtocol item) {
        return new ProxyProtocolNested(item);
    }

    public ProxyProtocolNested<A> editProxyProtocol() {
        return this.withNewProxyProtocolLike(Optional.ofNullable(this.buildProxyProtocol()).orElse(null));
    }

    public ProxyProtocolNested<A> editOrNewProxyProtocol() {
        return this.withNewProxyProtocolLike(Optional.ofNullable(this.buildProxyProtocol()).orElse(new TrafficPolicyProxyProtocolBuilder().build()));
    }

    public ProxyProtocolNested<A> editOrNewProxyProtocolLike(TrafficPolicyProxyProtocol item) {
        return this.withNewProxyProtocolLike(Optional.ofNullable(this.buildProxyProtocol()).orElse(item));
    }

    public ClientTLSSettings buildTls() {
        return this.tls != null ? this.tls.build() : null;
    }

    public A withTls(ClientTLSSettings tls) {
        this._visitables.remove((Object)"tls");
        if (tls != null) {
            this.tls = new ClientTLSSettingsBuilder(tls);
            this._visitables.get((Object)"tls").add(this.tls);
        } else {
            this.tls = null;
            this._visitables.get((Object)"tls").remove((Object)this.tls);
        }
        return (A)((Object)this);
    }

    public boolean hasTls() {
        return this.tls != null;
    }

    public TlsNested<A> withNewTls() {
        return new TlsNested(null);
    }

    public TlsNested<A> withNewTlsLike(ClientTLSSettings item) {
        return new TlsNested(item);
    }

    public TlsNested<A> editTls() {
        return this.withNewTlsLike(Optional.ofNullable(this.buildTls()).orElse(null));
    }

    public TlsNested<A> editOrNewTls() {
        return this.withNewTlsLike(Optional.ofNullable(this.buildTls()).orElse(new ClientTLSSettingsBuilder().build()));
    }

    public TlsNested<A> editOrNewTlsLike(ClientTLSSettings item) {
        return this.withNewTlsLike(Optional.ofNullable(this.buildTls()).orElse(item));
    }

    public TrafficPolicyTunnelSettings buildTunnel() {
        return this.tunnel != null ? this.tunnel.build() : null;
    }

    public A withTunnel(TrafficPolicyTunnelSettings tunnel) {
        this._visitables.remove((Object)"tunnel");
        if (tunnel != null) {
            this.tunnel = new TrafficPolicyTunnelSettingsBuilder(tunnel);
            this._visitables.get((Object)"tunnel").add(this.tunnel);
        } else {
            this.tunnel = null;
            this._visitables.get((Object)"tunnel").remove((Object)this.tunnel);
        }
        return (A)((Object)this);
    }

    public boolean hasTunnel() {
        return this.tunnel != null;
    }

    public A withNewTunnel(String protocol, String targetHost, Integer targetPort) {
        return this.withTunnel(new TrafficPolicyTunnelSettings(protocol, targetHost, targetPort));
    }

    public TunnelNested<A> withNewTunnel() {
        return new TunnelNested(null);
    }

    public TunnelNested<A> withNewTunnelLike(TrafficPolicyTunnelSettings item) {
        return new TunnelNested(item);
    }

    public TunnelNested<A> editTunnel() {
        return this.withNewTunnelLike(Optional.ofNullable(this.buildTunnel()).orElse(null));
    }

    public TunnelNested<A> editOrNewTunnel() {
        return this.withNewTunnelLike(Optional.ofNullable(this.buildTunnel()).orElse(new TrafficPolicyTunnelSettingsBuilder().build()));
    }

    public TunnelNested<A> editOrNewTunnelLike(TrafficPolicyTunnelSettings item) {
        return this.withNewTunnelLike(Optional.ofNullable(this.buildTunnel()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TrafficPolicyFluent that = (TrafficPolicyFluent)((Object)o);
        if (!Objects.equals((Object)this.connectionPool, (Object)that.connectionPool)) {
            return false;
        }
        if (!Objects.equals((Object)this.loadBalancer, (Object)that.loadBalancer)) {
            return false;
        }
        if (!Objects.equals((Object)this.outlierDetection, (Object)that.outlierDetection)) {
            return false;
        }
        if (!Objects.equals(this.portLevelSettings, that.portLevelSettings)) {
            return false;
        }
        if (!Objects.equals((Object)this.proxyProtocol, (Object)that.proxyProtocol)) {
            return false;
        }
        if (!Objects.equals((Object)this.tls, (Object)that.tls)) {
            return false;
        }
        if (!Objects.equals((Object)this.tunnel, (Object)that.tunnel)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.connectionPool, this.loadBalancer, this.outlierDetection, this.portLevelSettings, this.proxyProtocol, this.tls, this.tunnel, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.connectionPool != null) {
            sb.append("connectionPool:");
            sb.append((Object)((Object)this.connectionPool) + ",");
        }
        if (this.loadBalancer != null) {
            sb.append("loadBalancer:");
            sb.append((Object)((Object)this.loadBalancer) + ",");
        }
        if (this.outlierDetection != null) {
            sb.append("outlierDetection:");
            sb.append((Object)((Object)this.outlierDetection) + ",");
        }
        if (this.portLevelSettings != null && !this.portLevelSettings.isEmpty()) {
            sb.append("portLevelSettings:");
            sb.append(this.portLevelSettings + ",");
        }
        if (this.proxyProtocol != null) {
            sb.append("proxyProtocol:");
            sb.append((Object)((Object)this.proxyProtocol) + ",");
        }
        if (this.tls != null) {
            sb.append("tls:");
            sb.append((Object)((Object)this.tls) + ",");
        }
        if (this.tunnel != null) {
            sb.append("tunnel:");
            sb.append((Object)((Object)this.tunnel) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TunnelNested<N>
    extends TrafficPolicyTunnelSettingsFluent<TunnelNested<N>>
    implements Nested<N> {
        TrafficPolicyTunnelSettingsBuilder builder;

        TunnelNested(TrafficPolicyTunnelSettings item) {
            this.builder = new TrafficPolicyTunnelSettingsBuilder(this, item);
        }

        public N and() {
            return (N)TrafficPolicyFluent.this.withTunnel(this.builder.build());
        }

        public N endTunnel() {
            return this.and();
        }
    }

    public class TlsNested<N>
    extends ClientTLSSettingsFluent<TlsNested<N>>
    implements Nested<N> {
        ClientTLSSettingsBuilder builder;

        TlsNested(ClientTLSSettings item) {
            this.builder = new ClientTLSSettingsBuilder(this, item);
        }

        public N and() {
            return (N)TrafficPolicyFluent.this.withTls(this.builder.build());
        }

        public N endTls() {
            return this.and();
        }
    }

    public class ProxyProtocolNested<N>
    extends TrafficPolicyProxyProtocolFluent<ProxyProtocolNested<N>>
    implements Nested<N> {
        TrafficPolicyProxyProtocolBuilder builder;

        ProxyProtocolNested(TrafficPolicyProxyProtocol item) {
            this.builder = new TrafficPolicyProxyProtocolBuilder(this, item);
        }

        public N and() {
            return (N)TrafficPolicyFluent.this.withProxyProtocol(this.builder.build());
        }

        public N endProxyProtocol() {
            return this.and();
        }
    }

    public class PortLevelSettingsNested<N>
    extends TrafficPolicyPortTrafficPolicyFluent<PortLevelSettingsNested<N>>
    implements Nested<N> {
        TrafficPolicyPortTrafficPolicyBuilder builder;
        int index;

        PortLevelSettingsNested(int index, TrafficPolicyPortTrafficPolicy item) {
            this.index = index;
            this.builder = new TrafficPolicyPortTrafficPolicyBuilder(this, item);
        }

        public N and() {
            return (N)TrafficPolicyFluent.this.setToPortLevelSettings(this.index, this.builder.build());
        }

        public N endPortLevelSetting() {
            return this.and();
        }
    }

    public class OutlierDetectionNested<N>
    extends OutlierDetectionFluent<OutlierDetectionNested<N>>
    implements Nested<N> {
        OutlierDetectionBuilder builder;

        OutlierDetectionNested(OutlierDetection item) {
            this.builder = new OutlierDetectionBuilder(this, item);
        }

        public N and() {
            return (N)TrafficPolicyFluent.this.withOutlierDetection(this.builder.build());
        }

        public N endOutlierDetection() {
            return this.and();
        }
    }

    public class LoadBalancerNested<N>
    extends LoadBalancerSettingsFluent<LoadBalancerNested<N>>
    implements Nested<N> {
        LoadBalancerSettingsBuilder builder;

        LoadBalancerNested(LoadBalancerSettings item) {
            this.builder = new LoadBalancerSettingsBuilder(this, item);
        }

        public N and() {
            return (N)TrafficPolicyFluent.this.withLoadBalancer(this.builder.build());
        }

        public N endLoadBalancer() {
            return this.and();
        }
    }

    public class ConnectionPoolNested<N>
    extends ConnectionPoolSettingsFluent<ConnectionPoolNested<N>>
    implements Nested<N> {
        ConnectionPoolSettingsBuilder builder;

        ConnectionPoolNested(ConnectionPoolSettings item) {
            this.builder = new ConnectionPoolSettingsBuilder(this, item);
        }

        public N and() {
            return (N)TrafficPolicyFluent.this.withConnectionPool(this.builder.build());
        }

        public N endConnectionPool() {
            return this.and();
        }
    }
}

