/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.telemetry.v1alpha1;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.HashMap;
import java.util.Map;

public enum MetricSelectorIstioMetric {
    ALL_METRICS(0),
    REQUEST_COUNT(1),
    REQUEST_DURATION(2),
    REQUEST_SIZE(3),
    RESPONSE_SIZE(4),
    TCP_OPENED_CONNECTIONS(5),
    TCP_CLOSED_CONNECTIONS(6),
    TCP_SENT_BYTES(7),
    TCP_RECEIVED_BYTES(8),
    GRPC_REQUEST_MESSAGES(9),
    GRPC_RESPONSE_MESSAGES(10);

    private final Integer value;
    private static final Map<Integer, MetricSelectorIstioMetric> CONSTANTS;
    private static final Map<String, MetricSelectorIstioMetric> NAME_CONSTANTS;

    private MetricSelectorIstioMetric(Integer value) {
        this.value = value;
    }

    @JsonCreator
    public static MetricSelectorIstioMetric fromValue(Object value) {
        if (value instanceof String) {
            MetricSelectorIstioMetric constant = NAME_CONSTANTS.get(((String)value).toLowerCase());
            if (constant == null) {
                throw new IllegalArgumentException(value + "");
            }
            return constant;
        }
        MetricSelectorIstioMetric constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value + "");
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<Integer, MetricSelectorIstioMetric>();
        NAME_CONSTANTS = new HashMap<String, MetricSelectorIstioMetric>();
        for (MetricSelectorIstioMetric c : MetricSelectorIstioMetric.values()) {
            CONSTANTS.put(c.value, c);
        }
        for (MetricSelectorIstioMetric c : MetricSelectorIstioMetric.values()) {
            NAME_CONSTANTS.put(c.name().toLowerCase(), c);
        }
    }
}

