/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.networking.v1alpha1;

import io.fabric8.istio.api.networking.v1alpha1.WasmPluginTrafficSelector;
import io.fabric8.istio.api.networking.v1beta1.PortSelector;
import io.fabric8.istio.api.networking.v1beta1.PortSelectorBuilder;
import io.fabric8.istio.api.networking.v1beta1.PortSelectorFluent;
import io.fabric8.istio.api.type.v1beta1.WorkloadMode;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class WasmPluginTrafficSelectorFluent<A extends WasmPluginTrafficSelectorFluent<A>>
extends BaseFluent<A> {
    private WorkloadMode mode;
    private ArrayList<PortSelectorBuilder> ports = new ArrayList();
    private Map<String, Object> additionalProperties;

    public WasmPluginTrafficSelectorFluent() {
    }

    public WasmPluginTrafficSelectorFluent(WasmPluginTrafficSelector instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(WasmPluginTrafficSelector instance) {
        WasmPluginTrafficSelector wasmPluginTrafficSelector = instance = instance != null ? instance : new WasmPluginTrafficSelector();
        if (instance != null) {
            this.withMode(instance.getMode());
            this.withPorts(instance.getPorts());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public WorkloadMode getMode() {
        return this.mode;
    }

    public A withMode(WorkloadMode mode) {
        this.mode = mode;
        return (A)((Object)this);
    }

    public boolean hasMode() {
        return this.mode != null;
    }

    public A addToPorts(int index, PortSelector item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        PortSelectorBuilder builder = new PortSelectorBuilder(item);
        if (index < 0 || index >= this.ports.size()) {
            this._visitables.get((Object)"ports").add(builder);
            this.ports.add(builder);
        } else {
            this._visitables.get((Object)"ports").add(index, builder);
            this.ports.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToPorts(int index, PortSelector item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        PortSelectorBuilder builder = new PortSelectorBuilder(item);
        if (index < 0 || index >= this.ports.size()) {
            this._visitables.get((Object)"ports").add(builder);
            this.ports.add(builder);
        } else {
            this._visitables.get((Object)"ports").set(index, builder);
            this.ports.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToPorts(PortSelector ... items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (PortSelector item : items) {
            PortSelectorBuilder builder = new PortSelectorBuilder(item);
            this._visitables.get((Object)"ports").add(builder);
            this.ports.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToV1beta1Ports(Collection<PortSelector> items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (PortSelector item : items) {
            PortSelectorBuilder builder = new PortSelectorBuilder(item);
            this._visitables.get((Object)"ports").add(builder);
            this.ports.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromPorts(PortSelector ... items) {
        if (this.ports == null) {
            return (A)((Object)this);
        }
        for (PortSelector item : items) {
            PortSelectorBuilder builder = new PortSelectorBuilder(item);
            this._visitables.get((Object)"ports").remove((Object)builder);
            this.ports.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromV1beta1Ports(Collection<PortSelector> items) {
        if (this.ports == null) {
            return (A)((Object)this);
        }
        for (PortSelector item : items) {
            PortSelectorBuilder builder = new PortSelectorBuilder(item);
            this._visitables.get((Object)"ports").remove((Object)builder);
            this.ports.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromV1beta1Ports(Predicate<PortSelectorBuilder> predicate) {
        if (this.ports == null) {
            return (A)((Object)this);
        }
        Iterator<PortSelectorBuilder> each = this.ports.iterator();
        List visitables = this._visitables.get((Object)"ports");
        while (each.hasNext()) {
            PortSelectorBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<PortSelector> buildPorts() {
        return this.ports != null ? WasmPluginTrafficSelectorFluent.build(this.ports) : null;
    }

    public PortSelector buildPort(int index) {
        return this.ports.get(index).build();
    }

    public PortSelector buildFirstPort() {
        return this.ports.get(0).build();
    }

    public PortSelector buildLastPort() {
        return this.ports.get(this.ports.size() - 1).build();
    }

    public PortSelector buildMatchingPort(Predicate<PortSelectorBuilder> predicate) {
        for (PortSelectorBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPort(Predicate<PortSelectorBuilder> predicate) {
        for (PortSelectorBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPorts(List<PortSelector> ports) {
        if (this.ports != null) {
            this._visitables.get((Object)"ports").clear();
        }
        if (ports != null) {
            this.ports = new ArrayList();
            for (PortSelector item : ports) {
                this.addToPorts(item);
            }
        } else {
            this.ports = null;
        }
        return (A)((Object)this);
    }

    public A withPorts(PortSelector ... ports) {
        if (this.ports != null) {
            this.ports.clear();
            this._visitables.remove((Object)"ports");
        }
        if (ports != null) {
            for (PortSelector item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasPorts() {
        return this.ports != null && !this.ports.isEmpty();
    }

    public A addNewPort(Integer number) {
        return this.addToPorts(new PortSelector(number));
    }

    public PortsNested<A> addNewPort() {
        return new PortsNested(-1, null);
    }

    public PortsNested<A> addNewPortLike(PortSelector item) {
        return new PortsNested(-1, item);
    }

    public PortsNested<A> setNewPortLike(int index, PortSelector item) {
        return new PortsNested(index, item);
    }

    public PortsNested<A> editPort(int index) {
        if (this.ports.size() <= index) {
            throw new RuntimeException("Can't edit ports. Index exceeds size.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public PortsNested<A> editFirstPort() {
        if (this.ports.size() == 0) {
            throw new RuntimeException("Can't edit first ports. The list is empty.");
        }
        return this.setNewPortLike(0, this.buildPort(0));
    }

    public PortsNested<A> editLastPort() {
        int index = this.ports.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ports. The list is empty.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public PortsNested<A> editMatchingPort(Predicate<PortSelectorBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ports.size(); ++i) {
            if (!predicate.test(this.ports.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ports. No match found.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WasmPluginTrafficSelectorFluent that = (WasmPluginTrafficSelectorFluent)((Object)o);
        if (!Objects.equals((Object)this.mode, (Object)that.mode)) {
            return false;
        }
        if (!Objects.equals(this.ports, that.ports)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mode, this.ports, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.mode != null) {
            sb.append("mode:");
            sb.append((Object)((Object)this.mode) + ",");
        }
        if (this.ports != null && !this.ports.isEmpty()) {
            sb.append("ports:");
            sb.append(this.ports + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PortsNested<N>
    extends PortSelectorFluent<PortsNested<N>>
    implements Nested<N> {
        PortSelectorBuilder builder;
        int index;

        PortsNested(int index, PortSelector item) {
            this.index = index;
            this.builder = new PortSelectorBuilder(this, item);
        }

        public N and() {
            return (N)WasmPluginTrafficSelectorFluent.this.setToPorts(this.index, this.builder.build());
        }

        public N endV1beta1Port() {
            return this.and();
        }
    }
}

