/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.istio.api.networking.v1alpha3.CaptureMode;
import io.fabric8.istio.api.networking.v1alpha3.IstioEgressListener;
import io.fabric8.istio.api.networking.v1alpha3.SidecarPort;
import io.fabric8.istio.api.networking.v1alpha3.SidecarPortBuilder;
import io.fabric8.istio.api.networking.v1alpha3.SidecarPortFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class IstioEgressListenerFluent<A extends IstioEgressListenerFluent<A>>
extends BaseFluent<A> {
    private String bind;
    private CaptureMode captureMode;
    private List<String> hosts = new ArrayList<String>();
    private SidecarPortBuilder port;
    private Map<String, Object> additionalProperties;

    public IstioEgressListenerFluent() {
    }

    public IstioEgressListenerFluent(IstioEgressListener instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(IstioEgressListener instance) {
        IstioEgressListener istioEgressListener = instance = instance != null ? instance : new IstioEgressListener();
        if (instance != null) {
            this.withBind(instance.getBind());
            this.withCaptureMode(instance.getCaptureMode());
            this.withHosts(instance.getHosts());
            this.withPort(instance.getPort());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getBind() {
        return this.bind;
    }

    public A withBind(String bind) {
        this.bind = bind;
        return (A)((Object)this);
    }

    public boolean hasBind() {
        return this.bind != null;
    }

    public CaptureMode getCaptureMode() {
        return this.captureMode;
    }

    public A withCaptureMode(CaptureMode captureMode) {
        this.captureMode = captureMode;
        return (A)((Object)this);
    }

    public boolean hasCaptureMode() {
        return this.captureMode != null;
    }

    public A addToHosts(int index, String item) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        this.hosts.add(index, item);
        return (A)((Object)this);
    }

    public A setToHosts(int index, String item) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        this.hosts.set(index, item);
        return (A)((Object)this);
    }

    public A addToHosts(String ... items) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        for (String item : items) {
            this.hosts.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToHosts(Collection<String> items) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        for (String item : items) {
            this.hosts.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromHosts(String ... items) {
        if (this.hosts == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.hosts.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromHosts(Collection<String> items) {
        if (this.hosts == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.hosts.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getHosts() {
        return this.hosts;
    }

    public String getHost(int index) {
        return this.hosts.get(index);
    }

    public String getFirstHost() {
        return this.hosts.get(0);
    }

    public String getLastHost() {
        return this.hosts.get(this.hosts.size() - 1);
    }

    public String getMatchingHost(Predicate<String> predicate) {
        for (String item : this.hosts) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingHost(Predicate<String> predicate) {
        for (String item : this.hosts) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withHosts(List<String> hosts) {
        if (hosts != null) {
            this.hosts = new ArrayList<String>();
            for (String item : hosts) {
                this.addToHosts(item);
            }
        } else {
            this.hosts = null;
        }
        return (A)((Object)this);
    }

    public A withHosts(String ... hosts) {
        if (this.hosts != null) {
            this.hosts.clear();
            this._visitables.remove((Object)"hosts");
        }
        if (hosts != null) {
            for (String item : hosts) {
                this.addToHosts(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasHosts() {
        return this.hosts != null && !this.hosts.isEmpty();
    }

    public SidecarPort buildPort() {
        return this.port != null ? this.port.build() : null;
    }

    public A withPort(SidecarPort port) {
        this._visitables.remove((Object)"port");
        if (port != null) {
            this.port = new SidecarPortBuilder(port);
            this._visitables.get((Object)"port").add(this.port);
        } else {
            this.port = null;
            this._visitables.get((Object)"port").remove((Object)this.port);
        }
        return (A)((Object)this);
    }

    public boolean hasPort() {
        return this.port != null;
    }

    public A withNewPort(String name, Integer number, String protocol, Integer targetPort) {
        return this.withPort(new SidecarPort(name, number, protocol, targetPort));
    }

    public PortNested<A> withNewPort() {
        return new PortNested(null);
    }

    public PortNested<A> withNewPortLike(SidecarPort item) {
        return new PortNested(item);
    }

    public PortNested<A> editPort() {
        return this.withNewPortLike(Optional.ofNullable(this.buildPort()).orElse(null));
    }

    public PortNested<A> editOrNewPort() {
        return this.withNewPortLike(Optional.ofNullable(this.buildPort()).orElse(new SidecarPortBuilder().build()));
    }

    public PortNested<A> editOrNewPortLike(SidecarPort item) {
        return this.withNewPortLike(Optional.ofNullable(this.buildPort()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IstioEgressListenerFluent that = (IstioEgressListenerFluent)((Object)o);
        if (!Objects.equals(this.bind, that.bind)) {
            return false;
        }
        if (!Objects.equals((Object)this.captureMode, (Object)that.captureMode)) {
            return false;
        }
        if (!Objects.equals(this.hosts, that.hosts)) {
            return false;
        }
        if (!Objects.equals((Object)this.port, (Object)that.port)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bind, this.captureMode, this.hosts, this.port, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bind != null) {
            sb.append("bind:");
            sb.append(this.bind + ",");
        }
        if (this.captureMode != null) {
            sb.append("captureMode:");
            sb.append((Object)((Object)this.captureMode) + ",");
        }
        if (this.hosts != null && !this.hosts.isEmpty()) {
            sb.append("hosts:");
            sb.append(this.hosts + ",");
        }
        if (this.port != null) {
            sb.append("port:");
            sb.append((Object)((Object)this.port) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PortNested<N>
    extends SidecarPortFluent<PortNested<N>>
    implements Nested<N> {
        SidecarPortBuilder builder;

        PortNested(SidecarPort item) {
            this.builder = new SidecarPortBuilder(this, item);
        }

        public N and() {
            return (N)IstioEgressListenerFluent.this.withPort(this.builder.build());
        }

        public N endPort() {
            return this.and();
        }
    }
}

