/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.istio.api.networking.v1alpha3.CaptureMode;
import io.fabric8.istio.api.networking.v1alpha3.ConnectionPoolSettings;
import io.fabric8.istio.api.networking.v1alpha3.ConnectionPoolSettingsBuilder;
import io.fabric8.istio.api.networking.v1alpha3.ConnectionPoolSettingsFluent;
import io.fabric8.istio.api.networking.v1alpha3.IstioIngressListener;
import io.fabric8.istio.api.networking.v1alpha3.ServerTLSSettings;
import io.fabric8.istio.api.networking.v1alpha3.ServerTLSSettingsBuilder;
import io.fabric8.istio.api.networking.v1alpha3.ServerTLSSettingsFluent;
import io.fabric8.istio.api.networking.v1alpha3.SidecarPort;
import io.fabric8.istio.api.networking.v1alpha3.SidecarPortBuilder;
import io.fabric8.istio.api.networking.v1alpha3.SidecarPortFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class IstioIngressListenerFluent<A extends IstioIngressListenerFluent<A>>
extends BaseFluent<A> {
    private String bind;
    private CaptureMode captureMode;
    private ConnectionPoolSettingsBuilder connectionPool;
    private String defaultEndpoint;
    private SidecarPortBuilder port;
    private ServerTLSSettingsBuilder tls;
    private Map<String, Object> additionalProperties;

    public IstioIngressListenerFluent() {
    }

    public IstioIngressListenerFluent(IstioIngressListener instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(IstioIngressListener instance) {
        IstioIngressListener istioIngressListener = instance = instance != null ? instance : new IstioIngressListener();
        if (instance != null) {
            this.withBind(instance.getBind());
            this.withCaptureMode(instance.getCaptureMode());
            this.withConnectionPool(instance.getConnectionPool());
            this.withDefaultEndpoint(instance.getDefaultEndpoint());
            this.withPort(instance.getPort());
            this.withTls(instance.getTls());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getBind() {
        return this.bind;
    }

    public A withBind(String bind) {
        this.bind = bind;
        return (A)((Object)this);
    }

    public boolean hasBind() {
        return this.bind != null;
    }

    public CaptureMode getCaptureMode() {
        return this.captureMode;
    }

    public A withCaptureMode(CaptureMode captureMode) {
        this.captureMode = captureMode;
        return (A)((Object)this);
    }

    public boolean hasCaptureMode() {
        return this.captureMode != null;
    }

    public ConnectionPoolSettings buildConnectionPool() {
        return this.connectionPool != null ? this.connectionPool.build() : null;
    }

    public A withConnectionPool(ConnectionPoolSettings connectionPool) {
        this._visitables.remove((Object)"connectionPool");
        if (connectionPool != null) {
            this.connectionPool = new ConnectionPoolSettingsBuilder(connectionPool);
            this._visitables.get((Object)"connectionPool").add(this.connectionPool);
        } else {
            this.connectionPool = null;
            this._visitables.get((Object)"connectionPool").remove((Object)this.connectionPool);
        }
        return (A)((Object)this);
    }

    public boolean hasConnectionPool() {
        return this.connectionPool != null;
    }

    public ConnectionPoolNested<A> withNewConnectionPool() {
        return new ConnectionPoolNested(null);
    }

    public ConnectionPoolNested<A> withNewConnectionPoolLike(ConnectionPoolSettings item) {
        return new ConnectionPoolNested(item);
    }

    public ConnectionPoolNested<A> editConnectionPool() {
        return this.withNewConnectionPoolLike(Optional.ofNullable(this.buildConnectionPool()).orElse(null));
    }

    public ConnectionPoolNested<A> editOrNewConnectionPool() {
        return this.withNewConnectionPoolLike(Optional.ofNullable(this.buildConnectionPool()).orElse(new ConnectionPoolSettingsBuilder().build()));
    }

    public ConnectionPoolNested<A> editOrNewConnectionPoolLike(ConnectionPoolSettings item) {
        return this.withNewConnectionPoolLike(Optional.ofNullable(this.buildConnectionPool()).orElse(item));
    }

    public String getDefaultEndpoint() {
        return this.defaultEndpoint;
    }

    public A withDefaultEndpoint(String defaultEndpoint) {
        this.defaultEndpoint = defaultEndpoint;
        return (A)((Object)this);
    }

    public boolean hasDefaultEndpoint() {
        return this.defaultEndpoint != null;
    }

    public SidecarPort buildPort() {
        return this.port != null ? this.port.build() : null;
    }

    public A withPort(SidecarPort port) {
        this._visitables.remove((Object)"port");
        if (port != null) {
            this.port = new SidecarPortBuilder(port);
            this._visitables.get((Object)"port").add(this.port);
        } else {
            this.port = null;
            this._visitables.get((Object)"port").remove((Object)this.port);
        }
        return (A)((Object)this);
    }

    public boolean hasPort() {
        return this.port != null;
    }

    public A withNewPort(String name, Integer number, String protocol, Integer targetPort) {
        return this.withPort(new SidecarPort(name, number, protocol, targetPort));
    }

    public PortNested<A> withNewPort() {
        return new PortNested(null);
    }

    public PortNested<A> withNewPortLike(SidecarPort item) {
        return new PortNested(item);
    }

    public PortNested<A> editPort() {
        return this.withNewPortLike(Optional.ofNullable(this.buildPort()).orElse(null));
    }

    public PortNested<A> editOrNewPort() {
        return this.withNewPortLike(Optional.ofNullable(this.buildPort()).orElse(new SidecarPortBuilder().build()));
    }

    public PortNested<A> editOrNewPortLike(SidecarPort item) {
        return this.withNewPortLike(Optional.ofNullable(this.buildPort()).orElse(item));
    }

    public ServerTLSSettings buildTls() {
        return this.tls != null ? this.tls.build() : null;
    }

    public A withTls(ServerTLSSettings tls) {
        this._visitables.remove((Object)"tls");
        if (tls != null) {
            this.tls = new ServerTLSSettingsBuilder(tls);
            this._visitables.get((Object)"tls").add(this.tls);
        } else {
            this.tls = null;
            this._visitables.get((Object)"tls").remove((Object)this.tls);
        }
        return (A)((Object)this);
    }

    public boolean hasTls() {
        return this.tls != null;
    }

    public TlsNested<A> withNewTls() {
        return new TlsNested(null);
    }

    public TlsNested<A> withNewTlsLike(ServerTLSSettings item) {
        return new TlsNested(item);
    }

    public TlsNested<A> editTls() {
        return this.withNewTlsLike(Optional.ofNullable(this.buildTls()).orElse(null));
    }

    public TlsNested<A> editOrNewTls() {
        return this.withNewTlsLike(Optional.ofNullable(this.buildTls()).orElse(new ServerTLSSettingsBuilder().build()));
    }

    public TlsNested<A> editOrNewTlsLike(ServerTLSSettings item) {
        return this.withNewTlsLike(Optional.ofNullable(this.buildTls()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IstioIngressListenerFluent that = (IstioIngressListenerFluent)((Object)o);
        if (!Objects.equals(this.bind, that.bind)) {
            return false;
        }
        if (!Objects.equals((Object)this.captureMode, (Object)that.captureMode)) {
            return false;
        }
        if (!Objects.equals((Object)this.connectionPool, (Object)that.connectionPool)) {
            return false;
        }
        if (!Objects.equals(this.defaultEndpoint, that.defaultEndpoint)) {
            return false;
        }
        if (!Objects.equals((Object)this.port, (Object)that.port)) {
            return false;
        }
        if (!Objects.equals((Object)this.tls, (Object)that.tls)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bind, this.captureMode, this.connectionPool, this.defaultEndpoint, this.port, this.tls, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bind != null) {
            sb.append("bind:");
            sb.append(this.bind + ",");
        }
        if (this.captureMode != null) {
            sb.append("captureMode:");
            sb.append((Object)((Object)this.captureMode) + ",");
        }
        if (this.connectionPool != null) {
            sb.append("connectionPool:");
            sb.append((Object)((Object)this.connectionPool) + ",");
        }
        if (this.defaultEndpoint != null) {
            sb.append("defaultEndpoint:");
            sb.append(this.defaultEndpoint + ",");
        }
        if (this.port != null) {
            sb.append("port:");
            sb.append((Object)((Object)this.port) + ",");
        }
        if (this.tls != null) {
            sb.append("tls:");
            sb.append((Object)((Object)this.tls) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TlsNested<N>
    extends ServerTLSSettingsFluent<TlsNested<N>>
    implements Nested<N> {
        ServerTLSSettingsBuilder builder;

        TlsNested(ServerTLSSettings item) {
            this.builder = new ServerTLSSettingsBuilder(this, item);
        }

        public N and() {
            return (N)IstioIngressListenerFluent.this.withTls(this.builder.build());
        }

        public N endTls() {
            return this.and();
        }
    }

    public class PortNested<N>
    extends SidecarPortFluent<PortNested<N>>
    implements Nested<N> {
        SidecarPortBuilder builder;

        PortNested(SidecarPort item) {
            this.builder = new SidecarPortBuilder(this, item);
        }

        public N and() {
            return (N)IstioIngressListenerFluent.this.withPort(this.builder.build());
        }

        public N endPort() {
            return this.and();
        }
    }

    public class ConnectionPoolNested<N>
    extends ConnectionPoolSettingsFluent<ConnectionPoolNested<N>>
    implements Nested<N> {
        ConnectionPoolSettingsBuilder builder;

        ConnectionPoolNested(ConnectionPoolSettings item) {
            this.builder = new ConnectionPoolSettingsBuilder(this, item);
        }

        public N and() {
            return (N)IstioIngressListenerFluent.this.withConnectionPool(this.builder.build());
        }

        public N endConnectionPool() {
            return this.and();
        }
    }
}

