/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.telemetry.v1alpha1;

import io.fabric8.istio.api.telemetry.v1alpha1.ProviderRef;
import io.fabric8.istio.api.telemetry.v1alpha1.ProviderRefBuilder;
import io.fabric8.istio.api.telemetry.v1alpha1.ProviderRefFluent;
import io.fabric8.istio.api.telemetry.v1alpha1.Tracing;
import io.fabric8.istio.api.telemetry.v1alpha1.TracingCustomTag;
import io.fabric8.istio.api.telemetry.v1alpha1.TracingTracingSelector;
import io.fabric8.istio.api.telemetry.v1alpha1.TracingTracingSelectorBuilder;
import io.fabric8.istio.api.telemetry.v1alpha1.TracingTracingSelectorFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class TracingFluent<A extends TracingFluent<A>>
extends BaseFluent<A> {
    private Map<String, TracingCustomTag> customTags;
    private Boolean disableSpanReporting;
    private TracingTracingSelectorBuilder match;
    private ArrayList<ProviderRefBuilder> providers = new ArrayList();
    private Double randomSamplingPercentage;
    private Boolean useRequestIdForTraceSampling;
    private Map<String, Object> additionalProperties;

    public TracingFluent() {
    }

    public TracingFluent(Tracing instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Tracing instance) {
        Tracing tracing = instance = instance != null ? instance : new Tracing();
        if (instance != null) {
            this.withCustomTags(instance.getCustomTags());
            this.withDisableSpanReporting(instance.getDisableSpanReporting());
            this.withMatch(instance.getMatch());
            this.withProviders(instance.getProviders());
            this.withRandomSamplingPercentage(instance.getRandomSamplingPercentage());
            this.withUseRequestIdForTraceSampling(instance.getUseRequestIdForTraceSampling());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToCustomTags(String key, TracingCustomTag value) {
        if (this.customTags == null && key != null && value != null) {
            this.customTags = new LinkedHashMap<String, TracingCustomTag>();
        }
        if (key != null && value != null) {
            this.customTags.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToCustomTags(Map<String, TracingCustomTag> map) {
        if (this.customTags == null && map != null) {
            this.customTags = new LinkedHashMap<String, TracingCustomTag>();
        }
        if (map != null) {
            this.customTags.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromCustomTags(String key) {
        if (this.customTags == null) {
            return (A)((Object)this);
        }
        if (key != null && this.customTags != null) {
            this.customTags.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromCustomTags(Map<String, TracingCustomTag> map) {
        if (this.customTags == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.customTags == null) continue;
                this.customTags.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, TracingCustomTag> getCustomTags() {
        return this.customTags;
    }

    public <K, V> A withCustomTags(Map<String, TracingCustomTag> customTags) {
        this.customTags = customTags == null ? null : new LinkedHashMap<String, TracingCustomTag>(customTags);
        return (A)((Object)this);
    }

    public boolean hasCustomTags() {
        return this.customTags != null;
    }

    public Boolean getDisableSpanReporting() {
        return this.disableSpanReporting;
    }

    public A withDisableSpanReporting(Boolean disableSpanReporting) {
        this.disableSpanReporting = disableSpanReporting;
        return (A)((Object)this);
    }

    public boolean hasDisableSpanReporting() {
        return this.disableSpanReporting != null;
    }

    public TracingTracingSelector buildMatch() {
        return this.match != null ? this.match.build() : null;
    }

    public A withMatch(TracingTracingSelector match) {
        this._visitables.remove((Object)"match");
        if (match != null) {
            this.match = new TracingTracingSelectorBuilder(match);
            this._visitables.get((Object)"match").add(this.match);
        } else {
            this.match = null;
            this._visitables.get((Object)"match").remove((Object)this.match);
        }
        return (A)((Object)this);
    }

    public boolean hasMatch() {
        return this.match != null;
    }

    public MatchNested<A> withNewMatch() {
        return new MatchNested(null);
    }

    public MatchNested<A> withNewMatchLike(TracingTracingSelector item) {
        return new MatchNested(item);
    }

    public MatchNested<A> editMatch() {
        return this.withNewMatchLike(Optional.ofNullable(this.buildMatch()).orElse(null));
    }

    public MatchNested<A> editOrNewMatch() {
        return this.withNewMatchLike(Optional.ofNullable(this.buildMatch()).orElse(new TracingTracingSelectorBuilder().build()));
    }

    public MatchNested<A> editOrNewMatchLike(TracingTracingSelector item) {
        return this.withNewMatchLike(Optional.ofNullable(this.buildMatch()).orElse(item));
    }

    public A addToProviders(int index, ProviderRef item) {
        if (this.providers == null) {
            this.providers = new ArrayList();
        }
        ProviderRefBuilder builder = new ProviderRefBuilder(item);
        if (index < 0 || index >= this.providers.size()) {
            this._visitables.get((Object)"providers").add(builder);
            this.providers.add(builder);
        } else {
            this._visitables.get((Object)"providers").add(index, builder);
            this.providers.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToProviders(int index, ProviderRef item) {
        if (this.providers == null) {
            this.providers = new ArrayList();
        }
        ProviderRefBuilder builder = new ProviderRefBuilder(item);
        if (index < 0 || index >= this.providers.size()) {
            this._visitables.get((Object)"providers").add(builder);
            this.providers.add(builder);
        } else {
            this._visitables.get((Object)"providers").set(index, builder);
            this.providers.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToProviders(ProviderRef ... items) {
        if (this.providers == null) {
            this.providers = new ArrayList();
        }
        for (ProviderRef item : items) {
            ProviderRefBuilder builder = new ProviderRefBuilder(item);
            this._visitables.get((Object)"providers").add(builder);
            this.providers.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToProviders(Collection<ProviderRef> items) {
        if (this.providers == null) {
            this.providers = new ArrayList();
        }
        for (ProviderRef item : items) {
            ProviderRefBuilder builder = new ProviderRefBuilder(item);
            this._visitables.get((Object)"providers").add(builder);
            this.providers.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromProviders(ProviderRef ... items) {
        if (this.providers == null) {
            return (A)((Object)this);
        }
        for (ProviderRef item : items) {
            ProviderRefBuilder builder = new ProviderRefBuilder(item);
            this._visitables.get((Object)"providers").remove((Object)builder);
            this.providers.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromProviders(Collection<ProviderRef> items) {
        if (this.providers == null) {
            return (A)((Object)this);
        }
        for (ProviderRef item : items) {
            ProviderRefBuilder builder = new ProviderRefBuilder(item);
            this._visitables.get((Object)"providers").remove((Object)builder);
            this.providers.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromProviders(Predicate<ProviderRefBuilder> predicate) {
        if (this.providers == null) {
            return (A)((Object)this);
        }
        Iterator<ProviderRefBuilder> each = this.providers.iterator();
        List visitables = this._visitables.get((Object)"providers");
        while (each.hasNext()) {
            ProviderRefBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ProviderRef> buildProviders() {
        return this.providers != null ? TracingFluent.build(this.providers) : null;
    }

    public ProviderRef buildProvider(int index) {
        return this.providers.get(index).build();
    }

    public ProviderRef buildFirstProvider() {
        return this.providers.get(0).build();
    }

    public ProviderRef buildLastProvider() {
        return this.providers.get(this.providers.size() - 1).build();
    }

    public ProviderRef buildMatchingProvider(Predicate<ProviderRefBuilder> predicate) {
        for (ProviderRefBuilder item : this.providers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingProvider(Predicate<ProviderRefBuilder> predicate) {
        for (ProviderRefBuilder item : this.providers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withProviders(List<ProviderRef> providers) {
        if (this.providers != null) {
            this._visitables.get((Object)"providers").clear();
        }
        if (providers != null) {
            this.providers = new ArrayList();
            for (ProviderRef item : providers) {
                this.addToProviders(item);
            }
        } else {
            this.providers = null;
        }
        return (A)((Object)this);
    }

    public A withProviders(ProviderRef ... providers) {
        if (this.providers != null) {
            this.providers.clear();
            this._visitables.remove((Object)"providers");
        }
        if (providers != null) {
            for (ProviderRef item : providers) {
                this.addToProviders(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasProviders() {
        return this.providers != null && !this.providers.isEmpty();
    }

    public A addNewProvider(String name) {
        return this.addToProviders(new ProviderRef(name));
    }

    public ProvidersNested<A> addNewProvider() {
        return new ProvidersNested(-1, null);
    }

    public ProvidersNested<A> addNewProviderLike(ProviderRef item) {
        return new ProvidersNested(-1, item);
    }

    public ProvidersNested<A> setNewProviderLike(int index, ProviderRef item) {
        return new ProvidersNested(index, item);
    }

    public ProvidersNested<A> editProvider(int index) {
        if (this.providers.size() <= index) {
            throw new RuntimeException("Can't edit providers. Index exceeds size.");
        }
        return this.setNewProviderLike(index, this.buildProvider(index));
    }

    public ProvidersNested<A> editFirstProvider() {
        if (this.providers.size() == 0) {
            throw new RuntimeException("Can't edit first providers. The list is empty.");
        }
        return this.setNewProviderLike(0, this.buildProvider(0));
    }

    public ProvidersNested<A> editLastProvider() {
        int index = this.providers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last providers. The list is empty.");
        }
        return this.setNewProviderLike(index, this.buildProvider(index));
    }

    public ProvidersNested<A> editMatchingProvider(Predicate<ProviderRefBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.providers.size(); ++i) {
            if (!predicate.test(this.providers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching providers. No match found.");
        }
        return this.setNewProviderLike(index, this.buildProvider(index));
    }

    public Double getRandomSamplingPercentage() {
        return this.randomSamplingPercentage;
    }

    public A withRandomSamplingPercentage(Double randomSamplingPercentage) {
        this.randomSamplingPercentage = randomSamplingPercentage;
        return (A)((Object)this);
    }

    public boolean hasRandomSamplingPercentage() {
        return this.randomSamplingPercentage != null;
    }

    public Boolean getUseRequestIdForTraceSampling() {
        return this.useRequestIdForTraceSampling;
    }

    public A withUseRequestIdForTraceSampling(Boolean useRequestIdForTraceSampling) {
        this.useRequestIdForTraceSampling = useRequestIdForTraceSampling;
        return (A)((Object)this);
    }

    public boolean hasUseRequestIdForTraceSampling() {
        return this.useRequestIdForTraceSampling != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TracingFluent that = (TracingFluent)((Object)o);
        if (!Objects.equals(this.customTags, that.customTags)) {
            return false;
        }
        if (!Objects.equals(this.disableSpanReporting, that.disableSpanReporting)) {
            return false;
        }
        if (!Objects.equals((Object)this.match, (Object)that.match)) {
            return false;
        }
        if (!Objects.equals(this.providers, that.providers)) {
            return false;
        }
        if (!Objects.equals(this.randomSamplingPercentage, that.randomSamplingPercentage)) {
            return false;
        }
        if (!Objects.equals(this.useRequestIdForTraceSampling, that.useRequestIdForTraceSampling)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.customTags, this.disableSpanReporting, this.match, this.providers, this.randomSamplingPercentage, this.useRequestIdForTraceSampling, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.customTags != null && !this.customTags.isEmpty()) {
            sb.append("customTags:");
            sb.append(this.customTags + ",");
        }
        if (this.disableSpanReporting != null) {
            sb.append("disableSpanReporting:");
            sb.append(this.disableSpanReporting + ",");
        }
        if (this.match != null) {
            sb.append("match:");
            sb.append((Object)((Object)this.match) + ",");
        }
        if (this.providers != null && !this.providers.isEmpty()) {
            sb.append("providers:");
            sb.append(this.providers + ",");
        }
        if (this.randomSamplingPercentage != null) {
            sb.append("randomSamplingPercentage:");
            sb.append(this.randomSamplingPercentage + ",");
        }
        if (this.useRequestIdForTraceSampling != null) {
            sb.append("useRequestIdForTraceSampling:");
            sb.append(this.useRequestIdForTraceSampling + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withDisableSpanReporting() {
        return this.withDisableSpanReporting(true);
    }

    public A withUseRequestIdForTraceSampling() {
        return this.withUseRequestIdForTraceSampling(true);
    }

    public class ProvidersNested<N>
    extends ProviderRefFluent<ProvidersNested<N>>
    implements Nested<N> {
        ProviderRefBuilder builder;
        int index;

        ProvidersNested(int index, ProviderRef item) {
            this.index = index;
            this.builder = new ProviderRefBuilder(this, item);
        }

        public N and() {
            return (N)TracingFluent.this.setToProviders(this.index, this.builder.build());
        }

        public N endProvider() {
            return this.and();
        }
    }

    public class MatchNested<N>
    extends TracingTracingSelectorFluent<MatchNested<N>>
    implements Nested<N> {
        TracingTracingSelectorBuilder builder;

        MatchNested(TracingTracingSelector item) {
            this.builder = new TracingTracingSelectorBuilder(this, item);
        }

        public N and() {
            return (N)TracingFluent.this.withMatch(this.builder.build());
        }

        public N endMatch() {
            return this.and();
        }
    }
}

