package io.fabric8.istio.api.internal.protobuf.types;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ValueNumberValueBuilder extends ValueNumberValueFluentImpl<ValueNumberValueBuilder> implements VisitableBuilder<ValueNumberValue,ValueNumberValueBuilder>{
  public ValueNumberValueBuilder() {
    this(false);
  }
  public ValueNumberValueBuilder(Boolean validationEnabled) {
    this(new ValueNumberValue(), validationEnabled);
  }
  public ValueNumberValueBuilder(ValueNumberValueFluent<?> fluent) {
    this(fluent, false);
  }
  public ValueNumberValueBuilder(ValueNumberValueFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ValueNumberValue(), validationEnabled);
  }
  public ValueNumberValueBuilder(ValueNumberValueFluent<?> fluent,ValueNumberValue instance) {
    this(fluent, instance, false);
  }
  public ValueNumberValueBuilder(ValueNumberValueFluent<?> fluent,ValueNumberValue instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withNumberValue(instance.getNumberValue()); 
    this.validationEnabled = validationEnabled; 
  }
  public ValueNumberValueBuilder(ValueNumberValue instance) {
    this(instance,false);
  }
  public ValueNumberValueBuilder(ValueNumberValue instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withNumberValue(instance.getNumberValue()); 
    this.validationEnabled = validationEnabled; 
  }
  ValueNumberValueFluent<?> fluent;
  Boolean validationEnabled;
  public ValueNumberValue build() {
    ValueNumberValue buildable = new ValueNumberValue(fluent.getNumberValue());
    return buildable;
  }
  
}