package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DestinationRuleSpecBuilder extends DestinationRuleSpecFluentImpl<DestinationRuleSpecBuilder> implements VisitableBuilder<DestinationRuleSpec,DestinationRuleSpecBuilder>{
  public DestinationRuleSpecBuilder() {
    this(false);
  }
  public DestinationRuleSpecBuilder(Boolean validationEnabled) {
    this(new DestinationRuleSpec(), validationEnabled);
  }
  public DestinationRuleSpecBuilder(DestinationRuleSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public DestinationRuleSpecBuilder(DestinationRuleSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DestinationRuleSpec(), validationEnabled);
  }
  public DestinationRuleSpecBuilder(DestinationRuleSpecFluent<?> fluent,DestinationRuleSpec instance) {
    this(fluent, instance, false);
  }
  public DestinationRuleSpecBuilder(DestinationRuleSpecFluent<?> fluent,DestinationRuleSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withExportTo(instance.getExportTo()); 
    fluent.withHost(instance.getHost()); 
    fluent.withSubsets(instance.getSubsets()); 
    fluent.withTrafficPolicy(instance.getTrafficPolicy()); 
    this.validationEnabled = validationEnabled; 
  }
  public DestinationRuleSpecBuilder(DestinationRuleSpec instance) {
    this(instance,false);
  }
  public DestinationRuleSpecBuilder(DestinationRuleSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withExportTo(instance.getExportTo()); 
    this.withHost(instance.getHost()); 
    this.withSubsets(instance.getSubsets()); 
    this.withTrafficPolicy(instance.getTrafficPolicy()); 
    this.validationEnabled = validationEnabled; 
  }
  DestinationRuleSpecFluent<?> fluent;
  Boolean validationEnabled;
  public DestinationRuleSpec build() {
    DestinationRuleSpec buildable = new DestinationRuleSpec(fluent.getExportTo(),fluent.getHost(),fluent.getSubsets(),fluent.getTrafficPolicy());
    return buildable;
  }
  
}