package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EnvoyFilterClusterMatchBuilder extends EnvoyFilterClusterMatchFluentImpl<EnvoyFilterClusterMatchBuilder> implements VisitableBuilder<EnvoyFilterClusterMatch,EnvoyFilterClusterMatchBuilder>{
  public EnvoyFilterClusterMatchBuilder() {
    this(false);
  }
  public EnvoyFilterClusterMatchBuilder(Boolean validationEnabled) {
    this(new EnvoyFilterClusterMatch(), validationEnabled);
  }
  public EnvoyFilterClusterMatchBuilder(EnvoyFilterClusterMatchFluent<?> fluent) {
    this(fluent, false);
  }
  public EnvoyFilterClusterMatchBuilder(EnvoyFilterClusterMatchFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EnvoyFilterClusterMatch(), validationEnabled);
  }
  public EnvoyFilterClusterMatchBuilder(EnvoyFilterClusterMatchFluent<?> fluent,EnvoyFilterClusterMatch instance) {
    this(fluent, instance, false);
  }
  public EnvoyFilterClusterMatchBuilder(EnvoyFilterClusterMatchFluent<?> fluent,EnvoyFilterClusterMatch instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withPortNumber(instance.getPortNumber()); 
    fluent.withService(instance.getService()); 
    fluent.withSubset(instance.getSubset()); 
    this.validationEnabled = validationEnabled; 
  }
  public EnvoyFilterClusterMatchBuilder(EnvoyFilterClusterMatch instance) {
    this(instance,false);
  }
  public EnvoyFilterClusterMatchBuilder(EnvoyFilterClusterMatch instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withPortNumber(instance.getPortNumber()); 
    this.withService(instance.getService()); 
    this.withSubset(instance.getSubset()); 
    this.validationEnabled = validationEnabled; 
  }
  EnvoyFilterClusterMatchFluent<?> fluent;
  Boolean validationEnabled;
  public EnvoyFilterClusterMatch build() {
    EnvoyFilterClusterMatch buildable = new EnvoyFilterClusterMatch(fluent.getName(),fluent.getPortNumber(),fluent.getService(),fluent.getSubset());
    return buildable;
  }
  
}