package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EnvoyFilterListBuilder extends EnvoyFilterListFluentImpl<EnvoyFilterListBuilder> implements VisitableBuilder<EnvoyFilterList,EnvoyFilterListBuilder>{
  public EnvoyFilterListBuilder() {
    this(false);
  }
  public EnvoyFilterListBuilder(Boolean validationEnabled) {
    this(new EnvoyFilterList(), validationEnabled);
  }
  public EnvoyFilterListBuilder(EnvoyFilterListFluent<?> fluent) {
    this(fluent, false);
  }
  public EnvoyFilterListBuilder(EnvoyFilterListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EnvoyFilterList(), validationEnabled);
  }
  public EnvoyFilterListBuilder(EnvoyFilterListFluent<?> fluent,EnvoyFilterList instance) {
    this(fluent, instance, false);
  }
  public EnvoyFilterListBuilder(EnvoyFilterListFluent<?> fluent,EnvoyFilterList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  public EnvoyFilterListBuilder(EnvoyFilterList instance) {
    this(instance,false);
  }
  public EnvoyFilterListBuilder(EnvoyFilterList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  EnvoyFilterListFluent<?> fluent;
  Boolean validationEnabled;
  public EnvoyFilterList build() {
    EnvoyFilterList buildable = new EnvoyFilterList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}