package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ReadinessProbeFluentImpl<A extends ReadinessProbeFluent<A>> extends BaseFluent<A> implements ReadinessProbeFluent<A>{
  public ReadinessProbeFluentImpl() {
  }
  public ReadinessProbeFluentImpl(ReadinessProbe instance) {
    this.withHealthCheckMethod(instance.getHealthCheckMethod()); 
    this.withFailureThreshold(instance.getFailureThreshold()); 
    this.withInitialDelaySeconds(instance.getInitialDelaySeconds()); 
    this.withPeriodSeconds(instance.getPeriodSeconds()); 
    this.withSuccessThreshold(instance.getSuccessThreshold()); 
    this.withTimeoutSeconds(instance.getTimeoutSeconds()); 
  }
  private VisitableBuilder<? extends IsReadinessProbeHealthCheckMethod,?> healthCheckMethod;
  private Integer failureThreshold;
  private Integer initialDelaySeconds;
  private Integer periodSeconds;
  private Integer successThreshold;
  private Integer timeoutSeconds;
  
  /**
   * This method has been deprecated, please use method buildHealthCheckMethod instead.
   * @return The buildable object.
   */
  @Deprecated
  public IsReadinessProbeHealthCheckMethod getHealthCheckMethod() {
    return this.healthCheckMethod!=null?this.healthCheckMethod.build():null;
  }
  public IsReadinessProbeHealthCheckMethod buildHealthCheckMethod() {
    return this.healthCheckMethod!=null?this.healthCheckMethod.build():null;
  }
  public A withHealthCheckMethod(IsReadinessProbeHealthCheckMethod healthCheckMethod) {
    if (healthCheckMethod instanceof ReadinessProbeTcpSocket){ this.healthCheckMethod= new ReadinessProbeTcpSocketBuilder((ReadinessProbeTcpSocket)healthCheckMethod); _visitables.get("healthCheckMethod").add(this.healthCheckMethod);}
    if (healthCheckMethod instanceof ReadinessProbeExec){ this.healthCheckMethod= new ReadinessProbeExecBuilder((ReadinessProbeExec)healthCheckMethod); _visitables.get("healthCheckMethod").add(this.healthCheckMethod);}
    if (healthCheckMethod instanceof ReadinessProbeHttpGet){ this.healthCheckMethod= new ReadinessProbeHttpGetBuilder((ReadinessProbeHttpGet)healthCheckMethod); _visitables.get("healthCheckMethod").add(this.healthCheckMethod);}
    return (A) this;
  }
  public Boolean hasHealthCheckMethod() {
    return this.healthCheckMethod != null;
  }
  public A withReadinessProbeTcpSocketHealthCheckMethod(ReadinessProbeTcpSocket readinessProbeTcpSocketHealthCheckMethod) {
    _visitables.get("healthCheckMethod").remove(this.healthCheckMethod);
    if (readinessProbeTcpSocketHealthCheckMethod!=null){ this.healthCheckMethod= new ReadinessProbeTcpSocketBuilder(readinessProbeTcpSocketHealthCheckMethod); _visitables.get("healthCheckMethod").add(this.healthCheckMethod);} else { this.healthCheckMethod = null; _visitables.get("healthCheckMethod").remove(this.healthCheckMethod); } return (A) this;
  }
  public ReadinessProbeFluent.ReadinessProbeTcpSocketHealthCheckMethodNested<A> withNewReadinessProbeTcpSocketHealthCheckMethod() {
    return new ReadinessProbeFluentImpl.ReadinessProbeTcpSocketHealthCheckMethodNestedImpl();
  }
  public ReadinessProbeFluent.ReadinessProbeTcpSocketHealthCheckMethodNested<A> withNewReadinessProbeTcpSocketHealthCheckMethodLike(ReadinessProbeTcpSocket item) {
    return new ReadinessProbeFluentImpl.ReadinessProbeTcpSocketHealthCheckMethodNestedImpl(item);
  }
  public A withReadinessProbeExecHealthCheckMethod(ReadinessProbeExec readinessProbeExecHealthCheckMethod) {
    _visitables.get("healthCheckMethod").remove(this.healthCheckMethod);
    if (readinessProbeExecHealthCheckMethod!=null){ this.healthCheckMethod= new ReadinessProbeExecBuilder(readinessProbeExecHealthCheckMethod); _visitables.get("healthCheckMethod").add(this.healthCheckMethod);} else { this.healthCheckMethod = null; _visitables.get("healthCheckMethod").remove(this.healthCheckMethod); } return (A) this;
  }
  public ReadinessProbeFluent.ReadinessProbeExecHealthCheckMethodNested<A> withNewReadinessProbeExecHealthCheckMethod() {
    return new ReadinessProbeFluentImpl.ReadinessProbeExecHealthCheckMethodNestedImpl();
  }
  public ReadinessProbeFluent.ReadinessProbeExecHealthCheckMethodNested<A> withNewReadinessProbeExecHealthCheckMethodLike(ReadinessProbeExec item) {
    return new ReadinessProbeFluentImpl.ReadinessProbeExecHealthCheckMethodNestedImpl(item);
  }
  public A withReadinessProbeHttpGetHealthCheckMethod(ReadinessProbeHttpGet readinessProbeHttpGetHealthCheckMethod) {
    _visitables.get("healthCheckMethod").remove(this.healthCheckMethod);
    if (readinessProbeHttpGetHealthCheckMethod!=null){ this.healthCheckMethod= new ReadinessProbeHttpGetBuilder(readinessProbeHttpGetHealthCheckMethod); _visitables.get("healthCheckMethod").add(this.healthCheckMethod);} else { this.healthCheckMethod = null; _visitables.get("healthCheckMethod").remove(this.healthCheckMethod); } return (A) this;
  }
  public ReadinessProbeFluent.ReadinessProbeHttpGetHealthCheckMethodNested<A> withNewReadinessProbeHttpGetHealthCheckMethod() {
    return new ReadinessProbeFluentImpl.ReadinessProbeHttpGetHealthCheckMethodNestedImpl();
  }
  public ReadinessProbeFluent.ReadinessProbeHttpGetHealthCheckMethodNested<A> withNewReadinessProbeHttpGetHealthCheckMethodLike(ReadinessProbeHttpGet item) {
    return new ReadinessProbeFluentImpl.ReadinessProbeHttpGetHealthCheckMethodNestedImpl(item);
  }
  public Integer getFailureThreshold() {
    return this.failureThreshold;
  }
  public A withFailureThreshold(Integer failureThreshold) {
    this.failureThreshold=failureThreshold; return (A) this;
  }
  public Boolean hasFailureThreshold() {
    return this.failureThreshold != null;
  }
  public Integer getInitialDelaySeconds() {
    return this.initialDelaySeconds;
  }
  public A withInitialDelaySeconds(Integer initialDelaySeconds) {
    this.initialDelaySeconds=initialDelaySeconds; return (A) this;
  }
  public Boolean hasInitialDelaySeconds() {
    return this.initialDelaySeconds != null;
  }
  public Integer getPeriodSeconds() {
    return this.periodSeconds;
  }
  public A withPeriodSeconds(Integer periodSeconds) {
    this.periodSeconds=periodSeconds; return (A) this;
  }
  public Boolean hasPeriodSeconds() {
    return this.periodSeconds != null;
  }
  public Integer getSuccessThreshold() {
    return this.successThreshold;
  }
  public A withSuccessThreshold(Integer successThreshold) {
    this.successThreshold=successThreshold; return (A) this;
  }
  public Boolean hasSuccessThreshold() {
    return this.successThreshold != null;
  }
  public Integer getTimeoutSeconds() {
    return this.timeoutSeconds;
  }
  public A withTimeoutSeconds(Integer timeoutSeconds) {
    this.timeoutSeconds=timeoutSeconds; return (A) this;
  }
  public Boolean hasTimeoutSeconds() {
    return this.timeoutSeconds != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ReadinessProbeFluentImpl that = (ReadinessProbeFluentImpl) o;
    if (healthCheckMethod != null ? !healthCheckMethod.equals(that.healthCheckMethod) :that.healthCheckMethod != null) return false;
    if (failureThreshold != null ? !failureThreshold.equals(that.failureThreshold) :that.failureThreshold != null) return false;
    if (initialDelaySeconds != null ? !initialDelaySeconds.equals(that.initialDelaySeconds) :that.initialDelaySeconds != null) return false;
    if (periodSeconds != null ? !periodSeconds.equals(that.periodSeconds) :that.periodSeconds != null) return false;
    if (successThreshold != null ? !successThreshold.equals(that.successThreshold) :that.successThreshold != null) return false;
    if (timeoutSeconds != null ? !timeoutSeconds.equals(that.timeoutSeconds) :that.timeoutSeconds != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(healthCheckMethod,  failureThreshold,  initialDelaySeconds,  periodSeconds,  successThreshold,  timeoutSeconds,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (healthCheckMethod != null) { sb.append("healthCheckMethod:"); sb.append(healthCheckMethod + ","); }
    if (failureThreshold != null) { sb.append("failureThreshold:"); sb.append(failureThreshold + ","); }
    if (initialDelaySeconds != null) { sb.append("initialDelaySeconds:"); sb.append(initialDelaySeconds + ","); }
    if (periodSeconds != null) { sb.append("periodSeconds:"); sb.append(periodSeconds + ","); }
    if (successThreshold != null) { sb.append("successThreshold:"); sb.append(successThreshold + ","); }
    if (timeoutSeconds != null) { sb.append("timeoutSeconds:"); sb.append(timeoutSeconds); }
    sb.append("}");
    return sb.toString();
  }
  class ReadinessProbeTcpSocketHealthCheckMethodNestedImpl<N> extends ReadinessProbeTcpSocketFluentImpl<ReadinessProbeFluent.ReadinessProbeTcpSocketHealthCheckMethodNested<N>> implements ReadinessProbeFluent.ReadinessProbeTcpSocketHealthCheckMethodNested<N>,Nested<N>{
    ReadinessProbeTcpSocketHealthCheckMethodNestedImpl(ReadinessProbeTcpSocket item) {
      this.builder = new ReadinessProbeTcpSocketBuilder(this, item);
    }
    ReadinessProbeTcpSocketHealthCheckMethodNestedImpl() {
      this.builder = new ReadinessProbeTcpSocketBuilder(this);
    }
    ReadinessProbeTcpSocketBuilder builder;
    public N and() {
      return (N) ReadinessProbeFluentImpl.this.withHealthCheckMethod(builder.build());
    }
    public N endReadinessProbeTcpSocketHealthCheckMethod() {
      return and();
    }
    
  }
  class ReadinessProbeExecHealthCheckMethodNestedImpl<N> extends ReadinessProbeExecFluentImpl<ReadinessProbeFluent.ReadinessProbeExecHealthCheckMethodNested<N>> implements ReadinessProbeFluent.ReadinessProbeExecHealthCheckMethodNested<N>,Nested<N>{
    ReadinessProbeExecHealthCheckMethodNestedImpl(ReadinessProbeExec item) {
      this.builder = new ReadinessProbeExecBuilder(this, item);
    }
    ReadinessProbeExecHealthCheckMethodNestedImpl() {
      this.builder = new ReadinessProbeExecBuilder(this);
    }
    ReadinessProbeExecBuilder builder;
    public N and() {
      return (N) ReadinessProbeFluentImpl.this.withHealthCheckMethod(builder.build());
    }
    public N endReadinessProbeExecHealthCheckMethod() {
      return and();
    }
    
  }
  class ReadinessProbeHttpGetHealthCheckMethodNestedImpl<N> extends ReadinessProbeHttpGetFluentImpl<ReadinessProbeFluent.ReadinessProbeHttpGetHealthCheckMethodNested<N>> implements ReadinessProbeFluent.ReadinessProbeHttpGetHealthCheckMethodNested<N>,Nested<N>{
    ReadinessProbeHttpGetHealthCheckMethodNestedImpl(ReadinessProbeHttpGet item) {
      this.builder = new ReadinessProbeHttpGetBuilder(this, item);
    }
    ReadinessProbeHttpGetHealthCheckMethodNestedImpl() {
      this.builder = new ReadinessProbeHttpGetBuilder(this);
    }
    ReadinessProbeHttpGetBuilder builder;
    public N and() {
      return (N) ReadinessProbeFluentImpl.this.withHealthCheckMethod(builder.build());
    }
    public N endReadinessProbeHttpGetHealthCheckMethod() {
      return and();
    }
    
  }
  
}