package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SidecarListBuilder extends SidecarListFluentImpl<SidecarListBuilder> implements VisitableBuilder<SidecarList,SidecarListBuilder>{
  public SidecarListBuilder() {
    this(false);
  }
  public SidecarListBuilder(Boolean validationEnabled) {
    this(new SidecarList(), validationEnabled);
  }
  public SidecarListBuilder(SidecarListFluent<?> fluent) {
    this(fluent, false);
  }
  public SidecarListBuilder(SidecarListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SidecarList(), validationEnabled);
  }
  public SidecarListBuilder(SidecarListFluent<?> fluent,SidecarList instance) {
    this(fluent, instance, false);
  }
  public SidecarListBuilder(SidecarListFluent<?> fluent,SidecarList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  public SidecarListBuilder(SidecarList instance) {
    this(instance,false);
  }
  public SidecarListBuilder(SidecarList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  SidecarListFluent<?> fluent;
  Boolean validationEnabled;
  public SidecarList build() {
    SidecarList buildable = new SidecarList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}