package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TCPRouteBuilder extends TCPRouteFluentImpl<TCPRouteBuilder> implements VisitableBuilder<TCPRoute,TCPRouteBuilder>{
  public TCPRouteBuilder() {
    this(false);
  }
  public TCPRouteBuilder(Boolean validationEnabled) {
    this(new TCPRoute(), validationEnabled);
  }
  public TCPRouteBuilder(TCPRouteFluent<?> fluent) {
    this(fluent, false);
  }
  public TCPRouteBuilder(TCPRouteFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TCPRoute(), validationEnabled);
  }
  public TCPRouteBuilder(TCPRouteFluent<?> fluent,TCPRoute instance) {
    this(fluent, instance, false);
  }
  public TCPRouteBuilder(TCPRouteFluent<?> fluent,TCPRoute instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMatch(instance.getMatch()); 
    fluent.withRoute(instance.getRoute()); 
    this.validationEnabled = validationEnabled; 
  }
  public TCPRouteBuilder(TCPRoute instance) {
    this(instance,false);
  }
  public TCPRouteBuilder(TCPRoute instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withMatch(instance.getMatch()); 
    this.withRoute(instance.getRoute()); 
    this.validationEnabled = validationEnabled; 
  }
  TCPRouteFluent<?> fluent;
  Boolean validationEnabled;
  public TCPRoute build() {
    TCPRoute buildable = new TCPRoute(fluent.getMatch(),fluent.getRoute());
    return buildable;
  }
  
}