package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class WorkloadGroupBuilder extends WorkloadGroupFluentImpl<WorkloadGroupBuilder> implements VisitableBuilder<WorkloadGroup,WorkloadGroupBuilder>{
  public WorkloadGroupBuilder() {
    this(false);
  }
  public WorkloadGroupBuilder(Boolean validationEnabled) {
    this(new WorkloadGroup(), validationEnabled);
  }
  public WorkloadGroupBuilder(WorkloadGroupFluent<?> fluent) {
    this(fluent, false);
  }
  public WorkloadGroupBuilder(WorkloadGroupFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new WorkloadGroup(), validationEnabled);
  }
  public WorkloadGroupBuilder(WorkloadGroupFluent<?> fluent,WorkloadGroup instance) {
    this(fluent, instance, false);
  }
  public WorkloadGroupBuilder(WorkloadGroupFluent<?> fluent,WorkloadGroup instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  public WorkloadGroupBuilder(WorkloadGroup instance) {
    this(instance,false);
  }
  public WorkloadGroupBuilder(WorkloadGroup instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  WorkloadGroupFluent<?> fluent;
  Boolean validationEnabled;
  public WorkloadGroup build() {
    WorkloadGroup buildable = new WorkloadGroup(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}