package io.fabric8.istio.api.internal.protobuf.types;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ListValueBuilder extends ListValueFluentImpl<ListValueBuilder> implements VisitableBuilder<ListValue,ListValueBuilder>{
  public ListValueBuilder() {
    this(false);
  }
  public ListValueBuilder(Boolean validationEnabled) {
    this(new ListValue(), validationEnabled);
  }
  public ListValueBuilder(ListValueFluent<?> fluent) {
    this(fluent, false);
  }
  public ListValueBuilder(ListValueFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ListValue(), validationEnabled);
  }
  public ListValueBuilder(ListValueFluent<?> fluent,ListValue instance) {
    this(fluent, instance, false);
  }
  public ListValueBuilder(ListValueFluent<?> fluent,ListValue instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withValues(instance.getValues()); 
    this.validationEnabled = validationEnabled; 
  }
  public ListValueBuilder(ListValue instance) {
    this(instance,false);
  }
  public ListValueBuilder(ListValue instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withValues(instance.getValues()); 
    this.validationEnabled = validationEnabled; 
  }
  ListValueFluent<?> fluent;
  Boolean validationEnabled;
  public ListValue build() {
    ListValue buildable = new ListValue(fluent.getValues());
    return buildable;
  }
  
}