package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class HTTPHealthCheckConfigFluentImpl<A extends HTTPHealthCheckConfigFluent<A>> extends BaseFluent<A> implements HTTPHealthCheckConfigFluent<A>{
  public HTTPHealthCheckConfigFluentImpl() {
  }
  public HTTPHealthCheckConfigFluentImpl(HTTPHealthCheckConfig instance) {
    this.withHost(instance.getHost()); 
    this.withHttpHeaders(instance.getHttpHeaders()); 
    this.withPath(instance.getPath()); 
    this.withPort(instance.getPort()); 
    this.withScheme(instance.getScheme()); 
  }
  private String host;
  private ArrayList<HTTPHeaderBuilder> httpHeaders = new ArrayList<HTTPHeaderBuilder>();
  private String path;
  private Integer port;
  private String scheme;
  public String getHost() {
    return this.host;
  }
  public A withHost(String host) {
    this.host=host; return (A) this;
  }
  public Boolean hasHost() {
    return this.host != null;
  }
  public A addToHttpHeaders(Integer index,HTTPHeader item) {
    if (this.httpHeaders == null) {this.httpHeaders = new ArrayList<HTTPHeaderBuilder>();}
    HTTPHeaderBuilder builder = new HTTPHeaderBuilder(item);_visitables.get("httpHeaders").add(index >= 0 ? index : _visitables.get("httpHeaders").size(), builder);this.httpHeaders.add(index >= 0 ? index : httpHeaders.size(), builder); return (A)this;
  }
  public A setToHttpHeaders(Integer index,HTTPHeader item) {
    if (this.httpHeaders == null) {this.httpHeaders = new ArrayList<HTTPHeaderBuilder>();}
    HTTPHeaderBuilder builder = new HTTPHeaderBuilder(item);
    if (index < 0 || index >= _visitables.get("httpHeaders").size()) { _visitables.get("httpHeaders").add(builder); } else { _visitables.get("httpHeaders").set(index, builder);}
    if (index < 0 || index >= httpHeaders.size()) { httpHeaders.add(builder); } else { httpHeaders.set(index, builder);}
     return (A)this;
  }
  public A addToHttpHeaders(io.fabric8.istio.api.networking.v1alpha3.HTTPHeader... items) {
    if (this.httpHeaders == null) {this.httpHeaders = new ArrayList<HTTPHeaderBuilder>();}
    for (HTTPHeader item : items) {HTTPHeaderBuilder builder = new HTTPHeaderBuilder(item);_visitables.get("httpHeaders").add(builder);this.httpHeaders.add(builder);} return (A)this;
  }
  public A addAllToHttpHeaders(Collection<HTTPHeader> items) {
    if (this.httpHeaders == null) {this.httpHeaders = new ArrayList<HTTPHeaderBuilder>();}
    for (HTTPHeader item : items) {HTTPHeaderBuilder builder = new HTTPHeaderBuilder(item);_visitables.get("httpHeaders").add(builder);this.httpHeaders.add(builder);} return (A)this;
  }
  public A removeFromHttpHeaders(io.fabric8.istio.api.networking.v1alpha3.HTTPHeader... items) {
    for (HTTPHeader item : items) {HTTPHeaderBuilder builder = new HTTPHeaderBuilder(item);_visitables.get("httpHeaders").remove(builder);if (this.httpHeaders != null) {this.httpHeaders.remove(builder);}} return (A)this;
  }
  public A removeAllFromHttpHeaders(Collection<HTTPHeader> items) {
    for (HTTPHeader item : items) {HTTPHeaderBuilder builder = new HTTPHeaderBuilder(item);_visitables.get("httpHeaders").remove(builder);if (this.httpHeaders != null) {this.httpHeaders.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromHttpHeaders(Predicate<HTTPHeaderBuilder> predicate) {
    if (httpHeaders == null) return (A) this;
    final Iterator<HTTPHeaderBuilder> each = httpHeaders.iterator();
    final List visitables = _visitables.get("httpHeaders");
    while (each.hasNext()) {
      HTTPHeaderBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildHttpHeaders instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<HTTPHeader> getHttpHeaders() {
    return httpHeaders != null ? build(httpHeaders) : null;
  }
  public List<HTTPHeader> buildHttpHeaders() {
    return httpHeaders != null ? build(httpHeaders) : null;
  }
  public HTTPHeader buildHttpHeader(Integer index) {
    return this.httpHeaders.get(index).build();
  }
  public HTTPHeader buildFirstHttpHeader() {
    return this.httpHeaders.get(0).build();
  }
  public HTTPHeader buildLastHttpHeader() {
    return this.httpHeaders.get(httpHeaders.size() - 1).build();
  }
  public HTTPHeader buildMatchingHttpHeader(Predicate<HTTPHeaderBuilder> predicate) {
    for (HTTPHeaderBuilder item: httpHeaders) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingHttpHeader(Predicate<HTTPHeaderBuilder> predicate) {
    for (HTTPHeaderBuilder item: httpHeaders) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withHttpHeaders(List<HTTPHeader> httpHeaders) {
    if (this.httpHeaders != null) { _visitables.get("httpHeaders").removeAll(this.httpHeaders);}
    if (httpHeaders != null) {this.httpHeaders = new ArrayList(); for (HTTPHeader item : httpHeaders){this.addToHttpHeaders(item);}} else { this.httpHeaders = null;} return (A) this;
  }
  public A withHttpHeaders(io.fabric8.istio.api.networking.v1alpha3.HTTPHeader... httpHeaders) {
    if (this.httpHeaders != null) {this.httpHeaders.clear();}
    if (httpHeaders != null) {for (HTTPHeader item :httpHeaders){ this.addToHttpHeaders(item);}} return (A) this;
  }
  public Boolean hasHttpHeaders() {
    return httpHeaders != null && !httpHeaders.isEmpty();
  }
  public A addNewHttpHeader(String name,String value) {
    return (A)addToHttpHeaders(new HTTPHeader(name, value));
  }
  public HTTPHealthCheckConfigFluent.HttpHeadersNested<A> addNewHttpHeader() {
    return new HTTPHealthCheckConfigFluentImpl.HttpHeadersNestedImpl();
  }
  public HTTPHealthCheckConfigFluent.HttpHeadersNested<A> addNewHttpHeaderLike(HTTPHeader item) {
    return new HTTPHealthCheckConfigFluentImpl.HttpHeadersNestedImpl(-1, item);
  }
  public HTTPHealthCheckConfigFluent.HttpHeadersNested<A> setNewHttpHeaderLike(Integer index,HTTPHeader item) {
    return new HTTPHealthCheckConfigFluentImpl.HttpHeadersNestedImpl(index, item);
  }
  public HTTPHealthCheckConfigFluent.HttpHeadersNested<A> editHttpHeader(Integer index) {
    if (httpHeaders.size() <= index) throw new RuntimeException("Can't edit httpHeaders. Index exceeds size.");
    return setNewHttpHeaderLike(index, buildHttpHeader(index));
  }
  public HTTPHealthCheckConfigFluent.HttpHeadersNested<A> editFirstHttpHeader() {
    if (httpHeaders.size() == 0) throw new RuntimeException("Can't edit first httpHeaders. The list is empty.");
    return setNewHttpHeaderLike(0, buildHttpHeader(0));
  }
  public HTTPHealthCheckConfigFluent.HttpHeadersNested<A> editLastHttpHeader() {
    int index = httpHeaders.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last httpHeaders. The list is empty.");
    return setNewHttpHeaderLike(index, buildHttpHeader(index));
  }
  public HTTPHealthCheckConfigFluent.HttpHeadersNested<A> editMatchingHttpHeader(Predicate<HTTPHeaderBuilder> predicate) {
    int index = -1;
    for (int i=0;i<httpHeaders.size();i++) { 
    if (predicate.test(httpHeaders.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching httpHeaders. No match found.");
    return setNewHttpHeaderLike(index, buildHttpHeader(index));
  }
  public String getPath() {
    return this.path;
  }
  public A withPath(String path) {
    this.path=path; return (A) this;
  }
  public Boolean hasPath() {
    return this.path != null;
  }
  public Integer getPort() {
    return this.port;
  }
  public A withPort(Integer port) {
    this.port=port; return (A) this;
  }
  public Boolean hasPort() {
    return this.port != null;
  }
  public String getScheme() {
    return this.scheme;
  }
  public A withScheme(String scheme) {
    this.scheme=scheme; return (A) this;
  }
  public Boolean hasScheme() {
    return this.scheme != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HTTPHealthCheckConfigFluentImpl that = (HTTPHealthCheckConfigFluentImpl) o;
    if (host != null ? !host.equals(that.host) :that.host != null) return false;
    if (httpHeaders != null ? !httpHeaders.equals(that.httpHeaders) :that.httpHeaders != null) return false;
    if (path != null ? !path.equals(that.path) :that.path != null) return false;
    if (port != null ? !port.equals(that.port) :that.port != null) return false;
    if (scheme != null ? !scheme.equals(that.scheme) :that.scheme != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(host,  httpHeaders,  path,  port,  scheme,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (host != null) { sb.append("host:"); sb.append(host + ","); }
    if (httpHeaders != null && !httpHeaders.isEmpty()) { sb.append("httpHeaders:"); sb.append(httpHeaders + ","); }
    if (path != null) { sb.append("path:"); sb.append(path + ","); }
    if (port != null) { sb.append("port:"); sb.append(port + ","); }
    if (scheme != null) { sb.append("scheme:"); sb.append(scheme); }
    sb.append("}");
    return sb.toString();
  }
  class HttpHeadersNestedImpl<N> extends HTTPHeaderFluentImpl<HTTPHealthCheckConfigFluent.HttpHeadersNested<N>> implements HTTPHealthCheckConfigFluent.HttpHeadersNested<N>,Nested<N>{
    HttpHeadersNestedImpl(Integer index,HTTPHeader item) {
      this.index = index;
      this.builder = new HTTPHeaderBuilder(this, item);
    }
    HttpHeadersNestedImpl() {
      this.index = -1;
      this.builder = new HTTPHeaderBuilder(this);
    }
    HTTPHeaderBuilder builder;
    Integer index;
    public N and() {
      return (N) HTTPHealthCheckConfigFluentImpl.this.setToHttpHeaders(index,builder.build());
    }
    public N endHttpHeader() {
      return and();
    }
    
  }
  
}