package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HTTPRouteBuilder extends HTTPRouteFluentImpl<HTTPRouteBuilder> implements VisitableBuilder<HTTPRoute,HTTPRouteBuilder>{
  public HTTPRouteBuilder() {
    this(false);
  }
  public HTTPRouteBuilder(Boolean validationEnabled) {
    this(new HTTPRoute(), validationEnabled);
  }
  public HTTPRouteBuilder(HTTPRouteFluent<?> fluent) {
    this(fluent, false);
  }
  public HTTPRouteBuilder(HTTPRouteFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HTTPRoute(), validationEnabled);
  }
  public HTTPRouteBuilder(HTTPRouteFluent<?> fluent,HTTPRoute instance) {
    this(fluent, instance, false);
  }
  public HTTPRouteBuilder(HTTPRouteFluent<?> fluent,HTTPRoute instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCorsPolicy(instance.getCorsPolicy()); 
    fluent.withDelegate(instance.getDelegate()); 
    fluent.withFault(instance.getFault()); 
    fluent.withHeaders(instance.getHeaders()); 
    fluent.withMatch(instance.getMatch()); 
    fluent.withMirror(instance.getMirror()); 
    fluent.withMirrorPercent(instance.getMirrorPercent()); 
    fluent.withMirrorPercentage(instance.getMirrorPercentage()); 
    fluent.withName(instance.getName()); 
    fluent.withRedirect(instance.getRedirect()); 
    fluent.withRetries(instance.getRetries()); 
    fluent.withRewrite(instance.getRewrite()); 
    fluent.withRoute(instance.getRoute()); 
    fluent.withTimeout(instance.getTimeout()); 
    this.validationEnabled = validationEnabled; 
  }
  public HTTPRouteBuilder(HTTPRoute instance) {
    this(instance,false);
  }
  public HTTPRouteBuilder(HTTPRoute instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withCorsPolicy(instance.getCorsPolicy()); 
    this.withDelegate(instance.getDelegate()); 
    this.withFault(instance.getFault()); 
    this.withHeaders(instance.getHeaders()); 
    this.withMatch(instance.getMatch()); 
    this.withMirror(instance.getMirror()); 
    this.withMirrorPercent(instance.getMirrorPercent()); 
    this.withMirrorPercentage(instance.getMirrorPercentage()); 
    this.withName(instance.getName()); 
    this.withRedirect(instance.getRedirect()); 
    this.withRetries(instance.getRetries()); 
    this.withRewrite(instance.getRewrite()); 
    this.withRoute(instance.getRoute()); 
    this.withTimeout(instance.getTimeout()); 
    this.validationEnabled = validationEnabled; 
  }
  HTTPRouteFluent<?> fluent;
  Boolean validationEnabled;
  public HTTPRoute build() {
    HTTPRoute buildable = new HTTPRoute(fluent.getCorsPolicy(),fluent.getDelegate(),fluent.getFault(),fluent.getHeaders(),fluent.getMatch(),fluent.getMirror(),fluent.getMirrorPercent(),fluent.getMirrorPercentage(),fluent.getName(),fluent.getRedirect(),fluent.getRetries(),fluent.getRewrite(),fluent.getRoute(),fluent.getTimeout());
    return buildable;
  }
  
}