package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IstioIngressListenerBuilder extends IstioIngressListenerFluentImpl<IstioIngressListenerBuilder> implements VisitableBuilder<IstioIngressListener,IstioIngressListenerBuilder>{
  public IstioIngressListenerBuilder() {
    this(false);
  }
  public IstioIngressListenerBuilder(Boolean validationEnabled) {
    this(new IstioIngressListener(), validationEnabled);
  }
  public IstioIngressListenerBuilder(IstioIngressListenerFluent<?> fluent) {
    this(fluent, false);
  }
  public IstioIngressListenerBuilder(IstioIngressListenerFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IstioIngressListener(), validationEnabled);
  }
  public IstioIngressListenerBuilder(IstioIngressListenerFluent<?> fluent,IstioIngressListener instance) {
    this(fluent, instance, false);
  }
  public IstioIngressListenerBuilder(IstioIngressListenerFluent<?> fluent,IstioIngressListener instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withBind(instance.getBind()); 
    fluent.withCaptureMode(instance.getCaptureMode()); 
    fluent.withDefaultEndpoint(instance.getDefaultEndpoint()); 
    fluent.withPort(instance.getPort()); 
    this.validationEnabled = validationEnabled; 
  }
  public IstioIngressListenerBuilder(IstioIngressListener instance) {
    this(instance,false);
  }
  public IstioIngressListenerBuilder(IstioIngressListener instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withBind(instance.getBind()); 
    this.withCaptureMode(instance.getCaptureMode()); 
    this.withDefaultEndpoint(instance.getDefaultEndpoint()); 
    this.withPort(instance.getPort()); 
    this.validationEnabled = validationEnabled; 
  }
  IstioIngressListenerFluent<?> fluent;
  Boolean validationEnabled;
  public IstioIngressListener build() {
    IstioIngressListener buildable = new IstioIngressListener(fluent.getBind(),fluent.getCaptureMode(),fluent.getDefaultEndpoint(),fluent.getPort());
    return buildable;
  }
  
}