package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class L4MatchAttributesBuilder extends L4MatchAttributesFluentImpl<L4MatchAttributesBuilder> implements VisitableBuilder<L4MatchAttributes,L4MatchAttributesBuilder>{
  public L4MatchAttributesBuilder() {
    this(false);
  }
  public L4MatchAttributesBuilder(Boolean validationEnabled) {
    this(new L4MatchAttributes(), validationEnabled);
  }
  public L4MatchAttributesBuilder(L4MatchAttributesFluent<?> fluent) {
    this(fluent, false);
  }
  public L4MatchAttributesBuilder(L4MatchAttributesFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new L4MatchAttributes(), validationEnabled);
  }
  public L4MatchAttributesBuilder(L4MatchAttributesFluent<?> fluent,L4MatchAttributes instance) {
    this(fluent, instance, false);
  }
  public L4MatchAttributesBuilder(L4MatchAttributesFluent<?> fluent,L4MatchAttributes instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDestinationSubnets(instance.getDestinationSubnets()); 
    fluent.withGateways(instance.getGateways()); 
    fluent.withPort(instance.getPort()); 
    fluent.withSourceLabels(instance.getSourceLabels()); 
    fluent.withSourceNamespace(instance.getSourceNamespace()); 
    fluent.withSourceSubnet(instance.getSourceSubnet()); 
    this.validationEnabled = validationEnabled; 
  }
  public L4MatchAttributesBuilder(L4MatchAttributes instance) {
    this(instance,false);
  }
  public L4MatchAttributesBuilder(L4MatchAttributes instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withDestinationSubnets(instance.getDestinationSubnets()); 
    this.withGateways(instance.getGateways()); 
    this.withPort(instance.getPort()); 
    this.withSourceLabels(instance.getSourceLabels()); 
    this.withSourceNamespace(instance.getSourceNamespace()); 
    this.withSourceSubnet(instance.getSourceSubnet()); 
    this.validationEnabled = validationEnabled; 
  }
  L4MatchAttributesFluent<?> fluent;
  Boolean validationEnabled;
  public L4MatchAttributes build() {
    L4MatchAttributes buildable = new L4MatchAttributes(fluent.getDestinationSubnets(),fluent.getGateways(),fluent.getPort(),fluent.getSourceLabels(),fluent.getSourceNamespace(),fluent.getSourceSubnet());
    return buildable;
  }
  
}