package io.fabric8.istio.api.networking.v1alpha3;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ServerFluentImpl<A extends ServerFluent<A>> extends BaseFluent<A> implements ServerFluent<A>{
  public ServerFluentImpl() {
  }
  public ServerFluentImpl(Server instance) {
    this.withBind(instance.getBind()); 
    this.withDefaultEndpoint(instance.getDefaultEndpoint()); 
    this.withHosts(instance.getHosts()); 
    this.withName(instance.getName()); 
    this.withPort(instance.getPort()); 
    this.withTls(instance.getTls()); 
  }
  private String bind;
  private String defaultEndpoint;
  private List<String> hosts = new ArrayList<String>();
  private String name;
  private PortBuilder port;
  private ServerTLSSettingsBuilder tls;
  public String getBind() {
    return this.bind;
  }
  public A withBind(String bind) {
    this.bind=bind; return (A) this;
  }
  public Boolean hasBind() {
    return this.bind != null;
  }
  public String getDefaultEndpoint() {
    return this.defaultEndpoint;
  }
  public A withDefaultEndpoint(String defaultEndpoint) {
    this.defaultEndpoint=defaultEndpoint; return (A) this;
  }
  public Boolean hasDefaultEndpoint() {
    return this.defaultEndpoint != null;
  }
  public A addToHosts(Integer index,String item) {
    if (this.hosts == null) {this.hosts = new ArrayList<String>();}
    this.hosts.add(index, item);
    return (A)this;
  }
  public A setToHosts(Integer index,String item) {
    if (this.hosts == null) {this.hosts = new ArrayList<String>();}
    this.hosts.set(index, item); return (A)this;
  }
  public A addToHosts(java.lang.String... items) {
    if (this.hosts == null) {this.hosts = new ArrayList<String>();}
    for (String item : items) {this.hosts.add(item);} return (A)this;
  }
  public A addAllToHosts(Collection<String> items) {
    if (this.hosts == null) {this.hosts = new ArrayList<String>();}
    for (String item : items) {this.hosts.add(item);} return (A)this;
  }
  public A removeFromHosts(java.lang.String... items) {
    for (String item : items) {if (this.hosts!= null){ this.hosts.remove(item);}} return (A)this;
  }
  public A removeAllFromHosts(Collection<String> items) {
    for (String item : items) {if (this.hosts!= null){ this.hosts.remove(item);}} return (A)this;
  }
  public List<String> getHosts() {
    return this.hosts;
  }
  public String getHost(Integer index) {
    return this.hosts.get(index);
  }
  public String getFirstHost() {
    return this.hosts.get(0);
  }
  public String getLastHost() {
    return this.hosts.get(hosts.size() - 1);
  }
  public String getMatchingHost(Predicate<String> predicate) {
    for (String item: hosts) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingHost(Predicate<String> predicate) {
    for (String item: hosts) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withHosts(List<String> hosts) {
    if (hosts != null) {this.hosts = new ArrayList(); for (String item : hosts){this.addToHosts(item);}} else { this.hosts = null;} return (A) this;
  }
  public A withHosts(java.lang.String... hosts) {
    if (this.hosts != null) {this.hosts.clear();}
    if (hosts != null) {for (String item :hosts){ this.addToHosts(item);}} return (A) this;
  }
  public Boolean hasHosts() {
    return hosts != null && !hosts.isEmpty();
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public Boolean hasName() {
    return this.name != null;
  }
  
  /**
   * This method has been deprecated, please use method buildPort instead.
   * @return The buildable object.
   */
  @Deprecated
  public Port getPort() {
    return this.port!=null ?this.port.build():null;
  }
  public Port buildPort() {
    return this.port!=null ?this.port.build():null;
  }
  public A withPort(Port port) {
    _visitables.get("port").remove(this.port);
    if (port!=null){ this.port= new PortBuilder(port); _visitables.get("port").add(this.port);} else { this.port = null; _visitables.get("port").remove(this.port); } return (A) this;
  }
  public Boolean hasPort() {
    return this.port != null;
  }
  public A withNewPort(String name,Integer number,String protocol,Integer targetPort) {
    return (A)withPort(new Port(name, number, protocol, targetPort));
  }
  public ServerFluent.PortNested<A> withNewPort() {
    return new ServerFluentImpl.PortNestedImpl();
  }
  public ServerFluent.PortNested<A> withNewPortLike(Port item) {
    return new ServerFluentImpl.PortNestedImpl(item);
  }
  public ServerFluent.PortNested<A> editPort() {
    return withNewPortLike(getPort());
  }
  public ServerFluent.PortNested<A> editOrNewPort() {
    return withNewPortLike(getPort() != null ? getPort(): new PortBuilder().build());
  }
  public ServerFluent.PortNested<A> editOrNewPortLike(Port item) {
    return withNewPortLike(getPort() != null ? getPort(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildTls instead.
   * @return The buildable object.
   */
  @Deprecated
  public ServerTLSSettings getTls() {
    return this.tls!=null ?this.tls.build():null;
  }
  public ServerTLSSettings buildTls() {
    return this.tls!=null ?this.tls.build():null;
  }
  public A withTls(ServerTLSSettings tls) {
    _visitables.get("tls").remove(this.tls);
    if (tls!=null){ this.tls= new ServerTLSSettingsBuilder(tls); _visitables.get("tls").add(this.tls);} else { this.tls = null; _visitables.get("tls").remove(this.tls); } return (A) this;
  }
  public Boolean hasTls() {
    return this.tls != null;
  }
  public ServerFluent.TlsNested<A> withNewTls() {
    return new ServerFluentImpl.TlsNestedImpl();
  }
  public ServerFluent.TlsNested<A> withNewTlsLike(ServerTLSSettings item) {
    return new ServerFluentImpl.TlsNestedImpl(item);
  }
  public ServerFluent.TlsNested<A> editTls() {
    return withNewTlsLike(getTls());
  }
  public ServerFluent.TlsNested<A> editOrNewTls() {
    return withNewTlsLike(getTls() != null ? getTls(): new ServerTLSSettingsBuilder().build());
  }
  public ServerFluent.TlsNested<A> editOrNewTlsLike(ServerTLSSettings item) {
    return withNewTlsLike(getTls() != null ? getTls(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ServerFluentImpl that = (ServerFluentImpl) o;
    if (bind != null ? !bind.equals(that.bind) :that.bind != null) return false;
    if (defaultEndpoint != null ? !defaultEndpoint.equals(that.defaultEndpoint) :that.defaultEndpoint != null) return false;
    if (hosts != null ? !hosts.equals(that.hosts) :that.hosts != null) return false;
    if (name != null ? !name.equals(that.name) :that.name != null) return false;
    if (port != null ? !port.equals(that.port) :that.port != null) return false;
    if (tls != null ? !tls.equals(that.tls) :that.tls != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(bind,  defaultEndpoint,  hosts,  name,  port,  tls,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (bind != null) { sb.append("bind:"); sb.append(bind + ","); }
    if (defaultEndpoint != null) { sb.append("defaultEndpoint:"); sb.append(defaultEndpoint + ","); }
    if (hosts != null && !hosts.isEmpty()) { sb.append("hosts:"); sb.append(hosts + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (port != null) { sb.append("port:"); sb.append(port + ","); }
    if (tls != null) { sb.append("tls:"); sb.append(tls); }
    sb.append("}");
    return sb.toString();
  }
  class PortNestedImpl<N> extends PortFluentImpl<ServerFluent.PortNested<N>> implements ServerFluent.PortNested<N>,Nested<N>{
    PortNestedImpl(Port item) {
      this.builder = new PortBuilder(this, item);
    }
    PortNestedImpl() {
      this.builder = new PortBuilder(this);
    }
    PortBuilder builder;
    public N and() {
      return (N) ServerFluentImpl.this.withPort(builder.build());
    }
    public N endPort() {
      return and();
    }
    
  }
  class TlsNestedImpl<N> extends ServerTLSSettingsFluentImpl<ServerFluent.TlsNested<N>> implements ServerFluent.TlsNested<N>,Nested<N>{
    TlsNestedImpl(ServerTLSSettings item) {
      this.builder = new ServerTLSSettingsBuilder(this, item);
    }
    TlsNestedImpl() {
      this.builder = new ServerTLSSettingsBuilder(this);
    }
    ServerTLSSettingsBuilder builder;
    public N and() {
      return (N) ServerFluentImpl.this.withTls(builder.build());
    }
    public N endTls() {
      return and();
    }
    
  }
  
}