package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TrafficPolicyPortTrafficPolicyBuilder extends TrafficPolicyPortTrafficPolicyFluentImpl<TrafficPolicyPortTrafficPolicyBuilder> implements VisitableBuilder<TrafficPolicyPortTrafficPolicy,TrafficPolicyPortTrafficPolicyBuilder>{
  public TrafficPolicyPortTrafficPolicyBuilder() {
    this(false);
  }
  public TrafficPolicyPortTrafficPolicyBuilder(Boolean validationEnabled) {
    this(new TrafficPolicyPortTrafficPolicy(), validationEnabled);
  }
  public TrafficPolicyPortTrafficPolicyBuilder(TrafficPolicyPortTrafficPolicyFluent<?> fluent) {
    this(fluent, false);
  }
  public TrafficPolicyPortTrafficPolicyBuilder(TrafficPolicyPortTrafficPolicyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TrafficPolicyPortTrafficPolicy(), validationEnabled);
  }
  public TrafficPolicyPortTrafficPolicyBuilder(TrafficPolicyPortTrafficPolicyFluent<?> fluent,TrafficPolicyPortTrafficPolicy instance) {
    this(fluent, instance, false);
  }
  public TrafficPolicyPortTrafficPolicyBuilder(TrafficPolicyPortTrafficPolicyFluent<?> fluent,TrafficPolicyPortTrafficPolicy instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConnectionPool(instance.getConnectionPool()); 
    fluent.withLoadBalancer(instance.getLoadBalancer()); 
    fluent.withOutlierDetection(instance.getOutlierDetection()); 
    fluent.withPort(instance.getPort()); 
    fluent.withTls(instance.getTls()); 
    this.validationEnabled = validationEnabled; 
  }
  public TrafficPolicyPortTrafficPolicyBuilder(TrafficPolicyPortTrafficPolicy instance) {
    this(instance,false);
  }
  public TrafficPolicyPortTrafficPolicyBuilder(TrafficPolicyPortTrafficPolicy instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withConnectionPool(instance.getConnectionPool()); 
    this.withLoadBalancer(instance.getLoadBalancer()); 
    this.withOutlierDetection(instance.getOutlierDetection()); 
    this.withPort(instance.getPort()); 
    this.withTls(instance.getTls()); 
    this.validationEnabled = validationEnabled; 
  }
  TrafficPolicyPortTrafficPolicyFluent<?> fluent;
  Boolean validationEnabled;
  public TrafficPolicyPortTrafficPolicy build() {
    TrafficPolicyPortTrafficPolicy buildable = new TrafficPolicyPortTrafficPolicy(fluent.getConnectionPool(),fluent.getLoadBalancer(),fluent.getOutlierDetection(),fluent.getPort(),fluent.getTls());
    return buildable;
  }
  
}