package io.fabric8.istio.api.internal.protobuf.types;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ValueBoolValueBuilder extends ValueBoolValueFluentImpl<ValueBoolValueBuilder> implements VisitableBuilder<ValueBoolValue,ValueBoolValueBuilder>{
  public ValueBoolValueBuilder() {
    this(false);
  }
  public ValueBoolValueBuilder(Boolean validationEnabled) {
    this(new ValueBoolValue(), validationEnabled);
  }
  public ValueBoolValueBuilder(ValueBoolValueFluent<?> fluent) {
    this(fluent, false);
  }
  public ValueBoolValueBuilder(ValueBoolValueFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ValueBoolValue(), validationEnabled);
  }
  public ValueBoolValueBuilder(ValueBoolValueFluent<?> fluent,ValueBoolValue instance) {
    this(fluent, instance, false);
  }
  public ValueBoolValueBuilder(ValueBoolValueFluent<?> fluent,ValueBoolValue instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withBoolValue(instance.getBoolValue());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ValueBoolValueBuilder(ValueBoolValue instance) {
    this(instance,false);
  }
  public ValueBoolValueBuilder(ValueBoolValue instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withBoolValue(instance.getBoolValue());
    }
    this.validationEnabled = validationEnabled; 
  }
  ValueBoolValueFluent<?> fluent;
  Boolean validationEnabled;
  public ValueBoolValue build() {
    ValueBoolValue buildable = new ValueBoolValue(fluent.getBoolValue());
    return buildable;
  }
  
}