package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConnectionPoolSettingsTCPSettingsBuilder extends ConnectionPoolSettingsTCPSettingsFluentImpl<ConnectionPoolSettingsTCPSettingsBuilder> implements VisitableBuilder<ConnectionPoolSettingsTCPSettings,ConnectionPoolSettingsTCPSettingsBuilder>{
  public ConnectionPoolSettingsTCPSettingsBuilder() {
    this(false);
  }
  public ConnectionPoolSettingsTCPSettingsBuilder(Boolean validationEnabled) {
    this(new ConnectionPoolSettingsTCPSettings(), validationEnabled);
  }
  public ConnectionPoolSettingsTCPSettingsBuilder(ConnectionPoolSettingsTCPSettingsFluent<?> fluent) {
    this(fluent, false);
  }
  public ConnectionPoolSettingsTCPSettingsBuilder(ConnectionPoolSettingsTCPSettingsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConnectionPoolSettingsTCPSettings(), validationEnabled);
  }
  public ConnectionPoolSettingsTCPSettingsBuilder(ConnectionPoolSettingsTCPSettingsFluent<?> fluent,ConnectionPoolSettingsTCPSettings instance) {
    this(fluent, instance, false);
  }
  public ConnectionPoolSettingsTCPSettingsBuilder(ConnectionPoolSettingsTCPSettingsFluent<?> fluent,ConnectionPoolSettingsTCPSettings instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withConnectTimeout(instance.getConnectTimeout());
      fluent.withMaxConnections(instance.getMaxConnections());
      fluent.withTcpKeepalive(instance.getTcpKeepalive());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConnectionPoolSettingsTCPSettingsBuilder(ConnectionPoolSettingsTCPSettings instance) {
    this(instance,false);
  }
  public ConnectionPoolSettingsTCPSettingsBuilder(ConnectionPoolSettingsTCPSettings instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withConnectTimeout(instance.getConnectTimeout());
      this.withMaxConnections(instance.getMaxConnections());
      this.withTcpKeepalive(instance.getTcpKeepalive());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConnectionPoolSettingsTCPSettingsFluent<?> fluent;
  Boolean validationEnabled;
  public ConnectionPoolSettingsTCPSettings build() {
    ConnectionPoolSettingsTCPSettings buildable = new ConnectionPoolSettingsTCPSettings(fluent.getConnectTimeout(),fluent.getMaxConnections(),fluent.getTcpKeepalive());
    return buildable;
  }
  
}