package io.fabric8.istio.api.networking.v1alpha3;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class DestinationFluentImpl<A extends DestinationFluent<A>> extends BaseFluent<A> implements DestinationFluent<A>{
  public DestinationFluentImpl() {
  }
  public DestinationFluentImpl(Destination instance) {
    if (instance != null) {
      this.withHost(instance.getHost());
      this.withPort(instance.getPort());
      this.withSubset(instance.getSubset());
    }
  }
  private String host;
  private PortSelectorBuilder port;
  private String subset;
  public String getHost() {
    return this.host;
  }
  public A withHost(String host) {
    this.host=host; return (A) this;
  }
  public Boolean hasHost() {
    return this.host != null;
  }
  
  /**
   * This method has been deprecated, please use method buildPort instead.
   * @return The buildable object.
   */
  @Deprecated
  public PortSelector getPort() {
    return this.port!=null ?this.port.build():null;
  }
  public PortSelector buildPort() {
    return this.port!=null ?this.port.build():null;
  }
  public A withPort(PortSelector port) {
    _visitables.get("port").remove(this.port);
    if (port!=null){ this.port= new PortSelectorBuilder(port); _visitables.get("port").add(this.port);} else { this.port = null; _visitables.get("port").remove(this.port); } return (A) this;
  }
  public Boolean hasPort() {
    return this.port != null;
  }
  public A withNewPort(Integer number) {
    return (A)withPort(new PortSelector(number));
  }
  public DestinationFluentImpl.PortNested<A> withNewPort() {
    return new DestinationFluentImpl.PortNestedImpl();
  }
  public DestinationFluentImpl.PortNested<A> withNewPortLike(PortSelector item) {
    return new DestinationFluentImpl.PortNestedImpl(item);
  }
  public DestinationFluentImpl.PortNested<A> editPort() {
    return withNewPortLike(getPort());
  }
  public DestinationFluentImpl.PortNested<A> editOrNewPort() {
    return withNewPortLike(getPort() != null ? getPort(): new PortSelectorBuilder().build());
  }
  public DestinationFluentImpl.PortNested<A> editOrNewPortLike(PortSelector item) {
    return withNewPortLike(getPort() != null ? getPort(): item);
  }
  public String getSubset() {
    return this.subset;
  }
  public A withSubset(String subset) {
    this.subset=subset; return (A) this;
  }
  public Boolean hasSubset() {
    return this.subset != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DestinationFluentImpl that = (DestinationFluentImpl) o;
    if (!java.util.Objects.equals(host, that.host)) return false;

    if (!java.util.Objects.equals(port, that.port)) return false;

    if (!java.util.Objects.equals(subset, that.subset)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(host,  port,  subset,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (host != null) { sb.append("host:"); sb.append(host + ","); }
    if (port != null) { sb.append("port:"); sb.append(port + ","); }
    if (subset != null) { sb.append("subset:"); sb.append(subset); }
    sb.append("}");
    return sb.toString();
  }
  class PortNestedImpl<N> extends PortSelectorFluentImpl<DestinationFluentImpl.PortNested<N>> implements DestinationFluentImpl.PortNested<N>,Nested<N>{
    PortNestedImpl(PortSelector item) {
      this.builder = new PortSelectorBuilder(this, item);
    }
    PortNestedImpl() {
      this.builder = new PortSelectorBuilder(this);
    }
    PortSelectorBuilder builder;
    public N and() {
      return (N) DestinationFluentImpl.this.withPort(builder.build());
    }
    public N endPort() {
      return and();
    }
    
  }
  
}