package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EnvoyFilterProxyMatchBuilder extends EnvoyFilterProxyMatchFluentImpl<EnvoyFilterProxyMatchBuilder> implements VisitableBuilder<EnvoyFilterProxyMatch,EnvoyFilterProxyMatchBuilder>{
  public EnvoyFilterProxyMatchBuilder() {
    this(false);
  }
  public EnvoyFilterProxyMatchBuilder(Boolean validationEnabled) {
    this(new EnvoyFilterProxyMatch(), validationEnabled);
  }
  public EnvoyFilterProxyMatchBuilder(EnvoyFilterProxyMatchFluent<?> fluent) {
    this(fluent, false);
  }
  public EnvoyFilterProxyMatchBuilder(EnvoyFilterProxyMatchFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EnvoyFilterProxyMatch(), validationEnabled);
  }
  public EnvoyFilterProxyMatchBuilder(EnvoyFilterProxyMatchFluent<?> fluent,EnvoyFilterProxyMatch instance) {
    this(fluent, instance, false);
  }
  public EnvoyFilterProxyMatchBuilder(EnvoyFilterProxyMatchFluent<?> fluent,EnvoyFilterProxyMatch instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withMetadata(instance.getMetadata());
      fluent.withProxyVersion(instance.getProxyVersion());
    }
    this.validationEnabled = validationEnabled; 
  }
  public EnvoyFilterProxyMatchBuilder(EnvoyFilterProxyMatch instance) {
    this(instance,false);
  }
  public EnvoyFilterProxyMatchBuilder(EnvoyFilterProxyMatch instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withMetadata(instance.getMetadata());
      this.withProxyVersion(instance.getProxyVersion());
    }
    this.validationEnabled = validationEnabled; 
  }
  EnvoyFilterProxyMatchFluent<?> fluent;
  Boolean validationEnabled;
  public EnvoyFilterProxyMatch build() {
    EnvoyFilterProxyMatch buildable = new EnvoyFilterProxyMatch(fluent.getMetadata(),fluent.getProxyVersion());
    return buildable;
  }
  
}