package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HTTPRedirectDerivePortBuilder extends HTTPRedirectDerivePortFluentImpl<HTTPRedirectDerivePortBuilder> implements VisitableBuilder<HTTPRedirectDerivePort,HTTPRedirectDerivePortBuilder>{
  public HTTPRedirectDerivePortBuilder() {
    this(false);
  }
  public HTTPRedirectDerivePortBuilder(Boolean validationEnabled) {
    this(new HTTPRedirectDerivePort(), validationEnabled);
  }
  public HTTPRedirectDerivePortBuilder(HTTPRedirectDerivePortFluent<?> fluent) {
    this(fluent, false);
  }
  public HTTPRedirectDerivePortBuilder(HTTPRedirectDerivePortFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HTTPRedirectDerivePort(), validationEnabled);
  }
  public HTTPRedirectDerivePortBuilder(HTTPRedirectDerivePortFluent<?> fluent,HTTPRedirectDerivePort instance) {
    this(fluent, instance, false);
  }
  public HTTPRedirectDerivePortBuilder(HTTPRedirectDerivePortFluent<?> fluent,HTTPRedirectDerivePort instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withDerivePort(instance.getDerivePort());
    }
    this.validationEnabled = validationEnabled; 
  }
  public HTTPRedirectDerivePortBuilder(HTTPRedirectDerivePort instance) {
    this(instance,false);
  }
  public HTTPRedirectDerivePortBuilder(HTTPRedirectDerivePort instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withDerivePort(instance.getDerivePort());
    }
    this.validationEnabled = validationEnabled; 
  }
  HTTPRedirectDerivePortFluent<?> fluent;
  Boolean validationEnabled;
  public HTTPRedirectDerivePort build() {
    HTTPRedirectDerivePort buildable = new HTTPRedirectDerivePort(fluent.getDerivePort());
    return buildable;
  }
  
}