package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HTTPRewriteBuilder extends HTTPRewriteFluentImpl<HTTPRewriteBuilder> implements VisitableBuilder<HTTPRewrite,HTTPRewriteBuilder>{
  public HTTPRewriteBuilder() {
    this(false);
  }
  public HTTPRewriteBuilder(Boolean validationEnabled) {
    this(new HTTPRewrite(), validationEnabled);
  }
  public HTTPRewriteBuilder(HTTPRewriteFluent<?> fluent) {
    this(fluent, false);
  }
  public HTTPRewriteBuilder(HTTPRewriteFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HTTPRewrite(), validationEnabled);
  }
  public HTTPRewriteBuilder(HTTPRewriteFluent<?> fluent,HTTPRewrite instance) {
    this(fluent, instance, false);
  }
  public HTTPRewriteBuilder(HTTPRewriteFluent<?> fluent,HTTPRewrite instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAuthority(instance.getAuthority());
      fluent.withUri(instance.getUri());
    }
    this.validationEnabled = validationEnabled; 
  }
  public HTTPRewriteBuilder(HTTPRewrite instance) {
    this(instance,false);
  }
  public HTTPRewriteBuilder(HTTPRewrite instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAuthority(instance.getAuthority());
      this.withUri(instance.getUri());
    }
    this.validationEnabled = validationEnabled; 
  }
  HTTPRewriteFluent<?> fluent;
  Boolean validationEnabled;
  public HTTPRewrite build() {
    HTTPRewrite buildable = new HTTPRewrite(fluent.getAuthority(),fluent.getUri());
    return buildable;
  }
  
}