package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HeadersBuilder extends HeadersFluentImpl<HeadersBuilder> implements VisitableBuilder<Headers,HeadersBuilder>{
  public HeadersBuilder() {
    this(false);
  }
  public HeadersBuilder(Boolean validationEnabled) {
    this(new Headers(), validationEnabled);
  }
  public HeadersBuilder(HeadersFluent<?> fluent) {
    this(fluent, false);
  }
  public HeadersBuilder(HeadersFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Headers(), validationEnabled);
  }
  public HeadersBuilder(HeadersFluent<?> fluent,Headers instance) {
    this(fluent, instance, false);
  }
  public HeadersBuilder(HeadersFluent<?> fluent,Headers instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withRequest(instance.getRequest());
      fluent.withResponse(instance.getResponse());
    }
    this.validationEnabled = validationEnabled; 
  }
  public HeadersBuilder(Headers instance) {
    this(instance,false);
  }
  public HeadersBuilder(Headers instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withRequest(instance.getRequest());
      this.withResponse(instance.getResponse());
    }
    this.validationEnabled = validationEnabled; 
  }
  HeadersFluent<?> fluent;
  Boolean validationEnabled;
  public Headers build() {
    Headers buildable = new Headers(fluent.getRequest(),fluent.getResponse());
    return buildable;
  }
  
}