package io.fabric8.istio.api.networking.v1alpha3;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class IstioIngressListenerFluentImpl<A extends IstioIngressListenerFluent<A>> extends BaseFluent<A> implements IstioIngressListenerFluent<A>{
  public IstioIngressListenerFluentImpl() {
  }
  public IstioIngressListenerFluentImpl(IstioIngressListener instance) {
    if (instance != null) {
      this.withBind(instance.getBind());
      this.withCaptureMode(instance.getCaptureMode());
      this.withDefaultEndpoint(instance.getDefaultEndpoint());
      this.withPort(instance.getPort());
    }
  }
  private String bind;
  private CaptureMode captureMode;
  private String defaultEndpoint;
  private PortBuilder port;
  public String getBind() {
    return this.bind;
  }
  public A withBind(String bind) {
    this.bind=bind; return (A) this;
  }
  public Boolean hasBind() {
    return this.bind != null;
  }
  public CaptureMode getCaptureMode() {
    return this.captureMode;
  }
  public A withCaptureMode(CaptureMode captureMode) {
    this.captureMode=captureMode; return (A) this;
  }
  public Boolean hasCaptureMode() {
    return this.captureMode != null;
  }
  public String getDefaultEndpoint() {
    return this.defaultEndpoint;
  }
  public A withDefaultEndpoint(String defaultEndpoint) {
    this.defaultEndpoint=defaultEndpoint; return (A) this;
  }
  public Boolean hasDefaultEndpoint() {
    return this.defaultEndpoint != null;
  }
  
  /**
   * This method has been deprecated, please use method buildPort instead.
   * @return The buildable object.
   */
  @Deprecated
  public Port getPort() {
    return this.port!=null ?this.port.build():null;
  }
  public Port buildPort() {
    return this.port!=null ?this.port.build():null;
  }
  public A withPort(Port port) {
    _visitables.get("port").remove(this.port);
    if (port!=null){ this.port= new PortBuilder(port); _visitables.get("port").add(this.port);} else { this.port = null; _visitables.get("port").remove(this.port); } return (A) this;
  }
  public Boolean hasPort() {
    return this.port != null;
  }
  public A withNewPort(String name,Integer number,String protocol,Integer targetPort) {
    return (A)withPort(new Port(name, number, protocol, targetPort));
  }
  public IstioIngressListenerFluentImpl.PortNested<A> withNewPort() {
    return new IstioIngressListenerFluentImpl.PortNestedImpl();
  }
  public IstioIngressListenerFluentImpl.PortNested<A> withNewPortLike(Port item) {
    return new IstioIngressListenerFluentImpl.PortNestedImpl(item);
  }
  public IstioIngressListenerFluentImpl.PortNested<A> editPort() {
    return withNewPortLike(getPort());
  }
  public IstioIngressListenerFluentImpl.PortNested<A> editOrNewPort() {
    return withNewPortLike(getPort() != null ? getPort(): new PortBuilder().build());
  }
  public IstioIngressListenerFluentImpl.PortNested<A> editOrNewPortLike(Port item) {
    return withNewPortLike(getPort() != null ? getPort(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    IstioIngressListenerFluentImpl that = (IstioIngressListenerFluentImpl) o;
    if (!java.util.Objects.equals(bind, that.bind)) return false;

    if (!java.util.Objects.equals(captureMode, that.captureMode)) return false;

    if (!java.util.Objects.equals(defaultEndpoint, that.defaultEndpoint)) return false;

    if (!java.util.Objects.equals(port, that.port)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(bind,  captureMode,  defaultEndpoint,  port,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (bind != null) { sb.append("bind:"); sb.append(bind + ","); }
    if (captureMode != null) { sb.append("captureMode:"); sb.append(captureMode + ","); }
    if (defaultEndpoint != null) { sb.append("defaultEndpoint:"); sb.append(defaultEndpoint + ","); }
    if (port != null) { sb.append("port:"); sb.append(port); }
    sb.append("}");
    return sb.toString();
  }
  class PortNestedImpl<N> extends PortFluentImpl<IstioIngressListenerFluentImpl.PortNested<N>> implements IstioIngressListenerFluentImpl.PortNested<N>,Nested<N>{
    PortNestedImpl(Port item) {
      this.builder = new PortBuilder(this, item);
    }
    PortNestedImpl() {
      this.builder = new PortBuilder(this);
    }
    PortBuilder builder;
    public N and() {
      return (N) IstioIngressListenerFluentImpl.this.withPort(builder.build());
    }
    public N endPort() {
      return and();
    }
    
  }
  
}