package io.fabric8.istio.api.networking.v1alpha3;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.istio.api.meta.v1alpha1.IstioStatusFluentImpl;
import io.fabric8.istio.api.meta.v1alpha1.IstioStatusBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.istio.api.meta.v1alpha1.IstioStatus;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ServiceEntryFluentImpl<A extends ServiceEntryFluent<A>> extends BaseFluent<A> implements ServiceEntryFluent<A>{
  public ServiceEntryFluentImpl() {
  }
  public ServiceEntryFluentImpl(ServiceEntry instance) {
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
  }
  private String apiVersion;
  private String kind;
  private ObjectMetaBuilder metadata;
  private ServiceEntrySpecBuilder spec;
  private IstioStatusBuilder status;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public ServiceEntryFluentImpl.MetadataNested<A> withNewMetadata() {
    return new ServiceEntryFluentImpl.MetadataNestedImpl();
  }
  public ServiceEntryFluentImpl.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new ServiceEntryFluentImpl.MetadataNestedImpl(item);
  }
  public ServiceEntryFluentImpl.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public ServiceEntryFluentImpl.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public ServiceEntryFluentImpl.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public ServiceEntrySpec getSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public ServiceEntrySpec buildSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public A withSpec(ServiceEntrySpec spec) {
    _visitables.get("spec").remove(this.spec);
    if (spec!=null){ this.spec= new ServiceEntrySpecBuilder(spec); _visitables.get("spec").add(this.spec);} else { this.spec = null; _visitables.get("spec").remove(this.spec); } return (A) this;
  }
  public Boolean hasSpec() {
    return this.spec != null;
  }
  public ServiceEntryFluentImpl.SpecNested<A> withNewSpec() {
    return new ServiceEntryFluentImpl.SpecNestedImpl();
  }
  public ServiceEntryFluentImpl.SpecNested<A> withNewSpecLike(ServiceEntrySpec item) {
    return new ServiceEntryFluentImpl.SpecNestedImpl(item);
  }
  public ServiceEntryFluentImpl.SpecNested<A> editSpec() {
    return withNewSpecLike(getSpec());
  }
  public ServiceEntryFluentImpl.SpecNested<A> editOrNewSpec() {
    return withNewSpecLike(getSpec() != null ? getSpec(): new ServiceEntrySpecBuilder().build());
  }
  public ServiceEntryFluentImpl.SpecNested<A> editOrNewSpecLike(ServiceEntrySpec item) {
    return withNewSpecLike(getSpec() != null ? getSpec(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public IstioStatus getStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public IstioStatus buildStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public A withStatus(IstioStatus status) {
    _visitables.get("status").remove(this.status);
    if (status!=null){ this.status= new IstioStatusBuilder(status); _visitables.get("status").add(this.status);} else { this.status = null; _visitables.get("status").remove(this.status); } return (A) this;
  }
  public Boolean hasStatus() {
    return this.status != null;
  }
  public ServiceEntryFluentImpl.StatusNested<A> withNewStatus() {
    return new ServiceEntryFluentImpl.StatusNestedImpl();
  }
  public ServiceEntryFluentImpl.StatusNested<A> withNewStatusLike(IstioStatus item) {
    return new ServiceEntryFluentImpl.StatusNestedImpl(item);
  }
  public ServiceEntryFluentImpl.StatusNested<A> editStatus() {
    return withNewStatusLike(getStatus());
  }
  public ServiceEntryFluentImpl.StatusNested<A> editOrNewStatus() {
    return withNewStatusLike(getStatus() != null ? getStatus(): new IstioStatusBuilder().build());
  }
  public ServiceEntryFluentImpl.StatusNested<A> editOrNewStatusLike(IstioStatus item) {
    return withNewStatusLike(getStatus() != null ? getStatus(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ServiceEntryFluentImpl that = (ServiceEntryFluentImpl) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(metadata, that.metadata)) return false;

    if (!java.util.Objects.equals(spec, that.spec)) return false;

    if (!java.util.Objects.equals(status, that.status)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  metadata,  spec,  status,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (spec != null) { sb.append("spec:"); sb.append(spec + ","); }
    if (status != null) { sb.append("status:"); sb.append(status); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<ServiceEntryFluentImpl.MetadataNested<N>> implements ServiceEntryFluentImpl.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) ServiceEntryFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class SpecNestedImpl<N> extends ServiceEntrySpecFluentImpl<ServiceEntryFluentImpl.SpecNested<N>> implements ServiceEntryFluentImpl.SpecNested<N>,Nested<N>{
    SpecNestedImpl(ServiceEntrySpec item) {
      this.builder = new ServiceEntrySpecBuilder(this, item);
    }
    SpecNestedImpl() {
      this.builder = new ServiceEntrySpecBuilder(this);
    }
    ServiceEntrySpecBuilder builder;
    public N and() {
      return (N) ServiceEntryFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec() {
      return and();
    }
    
  }
  class StatusNestedImpl<N> extends IstioStatusFluentImpl<ServiceEntryFluentImpl.StatusNested<N>> implements ServiceEntryFluentImpl.StatusNested<N>,Nested<N>{
    StatusNestedImpl(IstioStatus item) {
      this.builder = new IstioStatusBuilder(this, item);
    }
    StatusNestedImpl() {
      this.builder = new IstioStatusBuilder(this);
    }
    IstioStatusBuilder builder;
    public N and() {
      return (N) ServiceEntryFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus() {
      return and();
    }
    
  }
  
}