package io.fabric8.istio.api.networking.v1alpha3;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class TrafficPolicyPortTrafficPolicyFluentImpl<A extends TrafficPolicyPortTrafficPolicyFluent<A>> extends BaseFluent<A> implements TrafficPolicyPortTrafficPolicyFluent<A>{
  public TrafficPolicyPortTrafficPolicyFluentImpl() {
  }
  public TrafficPolicyPortTrafficPolicyFluentImpl(TrafficPolicyPortTrafficPolicy instance) {
    if (instance != null) {
      this.withConnectionPool(instance.getConnectionPool());
      this.withLoadBalancer(instance.getLoadBalancer());
      this.withOutlierDetection(instance.getOutlierDetection());
      this.withPort(instance.getPort());
      this.withTls(instance.getTls());
    }
  }
  private ConnectionPoolSettingsBuilder connectionPool;
  private LoadBalancerSettingsBuilder loadBalancer;
  private OutlierDetectionBuilder outlierDetection;
  private PortSelectorBuilder port;
  private ClientTLSSettingsBuilder tls;
  
  /**
   * This method has been deprecated, please use method buildConnectionPool instead.
   * @return The buildable object.
   */
  @Deprecated
  public ConnectionPoolSettings getConnectionPool() {
    return this.connectionPool!=null ?this.connectionPool.build():null;
  }
  public ConnectionPoolSettings buildConnectionPool() {
    return this.connectionPool!=null ?this.connectionPool.build():null;
  }
  public A withConnectionPool(ConnectionPoolSettings connectionPool) {
    _visitables.get("connectionPool").remove(this.connectionPool);
    if (connectionPool!=null){ this.connectionPool= new ConnectionPoolSettingsBuilder(connectionPool); _visitables.get("connectionPool").add(this.connectionPool);} else { this.connectionPool = null; _visitables.get("connectionPool").remove(this.connectionPool); } return (A) this;
  }
  public Boolean hasConnectionPool() {
    return this.connectionPool != null;
  }
  public TrafficPolicyPortTrafficPolicyFluentImpl.ConnectionPoolNested<A> withNewConnectionPool() {
    return new TrafficPolicyPortTrafficPolicyFluentImpl.ConnectionPoolNestedImpl();
  }
  public TrafficPolicyPortTrafficPolicyFluentImpl.ConnectionPoolNested<A> withNewConnectionPoolLike(ConnectionPoolSettings item) {
    return new TrafficPolicyPortTrafficPolicyFluentImpl.ConnectionPoolNestedImpl(item);
  }
  public TrafficPolicyPortTrafficPolicyFluentImpl.ConnectionPoolNested<A> editConnectionPool() {
    return withNewConnectionPoolLike(getConnectionPool());
  }
  public TrafficPolicyPortTrafficPolicyFluentImpl.ConnectionPoolNested<A> editOrNewConnectionPool() {
    return withNewConnectionPoolLike(getConnectionPool() != null ? getConnectionPool(): new ConnectionPoolSettingsBuilder().build());
  }
  public TrafficPolicyPortTrafficPolicyFluentImpl.ConnectionPoolNested<A> editOrNewConnectionPoolLike(ConnectionPoolSettings item) {
    return withNewConnectionPoolLike(getConnectionPool() != null ? getConnectionPool(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildLoadBalancer instead.
   * @return The buildable object.
   */
  @Deprecated
  public LoadBalancerSettings getLoadBalancer() {
    return this.loadBalancer!=null ?this.loadBalancer.build():null;
  }
  public LoadBalancerSettings buildLoadBalancer() {
    return this.loadBalancer!=null ?this.loadBalancer.build():null;
  }
  public A withLoadBalancer(LoadBalancerSettings loadBalancer) {
    _visitables.get("loadBalancer").remove(this.loadBalancer);
    if (loadBalancer!=null){ this.loadBalancer= new LoadBalancerSettingsBuilder(loadBalancer); _visitables.get("loadBalancer").add(this.loadBalancer);} else { this.loadBalancer = null; _visitables.get("loadBalancer").remove(this.loadBalancer); } return (A) this;
  }
  public Boolean hasLoadBalancer() {
    return this.loadBalancer != null;
  }
  public TrafficPolicyPortTrafficPolicyFluentImpl.LoadBalancerNested<A> withNewLoadBalancer() {
    return new TrafficPolicyPortTrafficPolicyFluentImpl.LoadBalancerNestedImpl();
  }
  public TrafficPolicyPortTrafficPolicyFluentImpl.LoadBalancerNested<A> withNewLoadBalancerLike(LoadBalancerSettings item) {
    return new TrafficPolicyPortTrafficPolicyFluentImpl.LoadBalancerNestedImpl(item);
  }
  public TrafficPolicyPortTrafficPolicyFluentImpl.LoadBalancerNested<A> editLoadBalancer() {
    return withNewLoadBalancerLike(getLoadBalancer());
  }
  public TrafficPolicyPortTrafficPolicyFluentImpl.LoadBalancerNested<A> editOrNewLoadBalancer() {
    return withNewLoadBalancerLike(getLoadBalancer() != null ? getLoadBalancer(): new LoadBalancerSettingsBuilder().build());
  }
  public TrafficPolicyPortTrafficPolicyFluentImpl.LoadBalancerNested<A> editOrNewLoadBalancerLike(LoadBalancerSettings item) {
    return withNewLoadBalancerLike(getLoadBalancer() != null ? getLoadBalancer(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildOutlierDetection instead.
   * @return The buildable object.
   */
  @Deprecated
  public OutlierDetection getOutlierDetection() {
    return this.outlierDetection!=null ?this.outlierDetection.build():null;
  }
  public OutlierDetection buildOutlierDetection() {
    return this.outlierDetection!=null ?this.outlierDetection.build():null;
  }
  public A withOutlierDetection(OutlierDetection outlierDetection) {
    _visitables.get("outlierDetection").remove(this.outlierDetection);
    if (outlierDetection!=null){ this.outlierDetection= new OutlierDetectionBuilder(outlierDetection); _visitables.get("outlierDetection").add(this.outlierDetection);} else { this.outlierDetection = null; _visitables.get("outlierDetection").remove(this.outlierDetection); } return (A) this;
  }
  public Boolean hasOutlierDetection() {
    return this.outlierDetection != null;
  }
  public TrafficPolicyPortTrafficPolicyFluentImpl.OutlierDetectionNested<A> withNewOutlierDetection() {
    return new TrafficPolicyPortTrafficPolicyFluentImpl.OutlierDetectionNestedImpl();
  }
  public TrafficPolicyPortTrafficPolicyFluentImpl.OutlierDetectionNested<A> withNewOutlierDetectionLike(OutlierDetection item) {
    return new TrafficPolicyPortTrafficPolicyFluentImpl.OutlierDetectionNestedImpl(item);
  }
  public TrafficPolicyPortTrafficPolicyFluentImpl.OutlierDetectionNested<A> editOutlierDetection() {
    return withNewOutlierDetectionLike(getOutlierDetection());
  }
  public TrafficPolicyPortTrafficPolicyFluentImpl.OutlierDetectionNested<A> editOrNewOutlierDetection() {
    return withNewOutlierDetectionLike(getOutlierDetection() != null ? getOutlierDetection(): new OutlierDetectionBuilder().build());
  }
  public TrafficPolicyPortTrafficPolicyFluentImpl.OutlierDetectionNested<A> editOrNewOutlierDetectionLike(OutlierDetection item) {
    return withNewOutlierDetectionLike(getOutlierDetection() != null ? getOutlierDetection(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPort instead.
   * @return The buildable object.
   */
  @Deprecated
  public PortSelector getPort() {
    return this.port!=null ?this.port.build():null;
  }
  public PortSelector buildPort() {
    return this.port!=null ?this.port.build():null;
  }
  public A withPort(PortSelector port) {
    _visitables.get("port").remove(this.port);
    if (port!=null){ this.port= new PortSelectorBuilder(port); _visitables.get("port").add(this.port);} else { this.port = null; _visitables.get("port").remove(this.port); } return (A) this;
  }
  public Boolean hasPort() {
    return this.port != null;
  }
  public A withNewPort(Integer number) {
    return (A)withPort(new PortSelector(number));
  }
  public TrafficPolicyPortTrafficPolicyFluentImpl.PortNested<A> withNewPort() {
    return new TrafficPolicyPortTrafficPolicyFluentImpl.PortNestedImpl();
  }
  public TrafficPolicyPortTrafficPolicyFluentImpl.PortNested<A> withNewPortLike(PortSelector item) {
    return new TrafficPolicyPortTrafficPolicyFluentImpl.PortNestedImpl(item);
  }
  public TrafficPolicyPortTrafficPolicyFluentImpl.PortNested<A> editPort() {
    return withNewPortLike(getPort());
  }
  public TrafficPolicyPortTrafficPolicyFluentImpl.PortNested<A> editOrNewPort() {
    return withNewPortLike(getPort() != null ? getPort(): new PortSelectorBuilder().build());
  }
  public TrafficPolicyPortTrafficPolicyFluentImpl.PortNested<A> editOrNewPortLike(PortSelector item) {
    return withNewPortLike(getPort() != null ? getPort(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildTls instead.
   * @return The buildable object.
   */
  @Deprecated
  public ClientTLSSettings getTls() {
    return this.tls!=null ?this.tls.build():null;
  }
  public ClientTLSSettings buildTls() {
    return this.tls!=null ?this.tls.build():null;
  }
  public A withTls(ClientTLSSettings tls) {
    _visitables.get("tls").remove(this.tls);
    if (tls!=null){ this.tls= new ClientTLSSettingsBuilder(tls); _visitables.get("tls").add(this.tls);} else { this.tls = null; _visitables.get("tls").remove(this.tls); } return (A) this;
  }
  public Boolean hasTls() {
    return this.tls != null;
  }
  public TrafficPolicyPortTrafficPolicyFluentImpl.TlsNested<A> withNewTls() {
    return new TrafficPolicyPortTrafficPolicyFluentImpl.TlsNestedImpl();
  }
  public TrafficPolicyPortTrafficPolicyFluentImpl.TlsNested<A> withNewTlsLike(ClientTLSSettings item) {
    return new TrafficPolicyPortTrafficPolicyFluentImpl.TlsNestedImpl(item);
  }
  public TrafficPolicyPortTrafficPolicyFluentImpl.TlsNested<A> editTls() {
    return withNewTlsLike(getTls());
  }
  public TrafficPolicyPortTrafficPolicyFluentImpl.TlsNested<A> editOrNewTls() {
    return withNewTlsLike(getTls() != null ? getTls(): new ClientTLSSettingsBuilder().build());
  }
  public TrafficPolicyPortTrafficPolicyFluentImpl.TlsNested<A> editOrNewTlsLike(ClientTLSSettings item) {
    return withNewTlsLike(getTls() != null ? getTls(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TrafficPolicyPortTrafficPolicyFluentImpl that = (TrafficPolicyPortTrafficPolicyFluentImpl) o;
    if (!java.util.Objects.equals(connectionPool, that.connectionPool)) return false;

    if (!java.util.Objects.equals(loadBalancer, that.loadBalancer)) return false;

    if (!java.util.Objects.equals(outlierDetection, that.outlierDetection)) return false;

    if (!java.util.Objects.equals(port, that.port)) return false;

    if (!java.util.Objects.equals(tls, that.tls)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(connectionPool,  loadBalancer,  outlierDetection,  port,  tls,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (connectionPool != null) { sb.append("connectionPool:"); sb.append(connectionPool + ","); }
    if (loadBalancer != null) { sb.append("loadBalancer:"); sb.append(loadBalancer + ","); }
    if (outlierDetection != null) { sb.append("outlierDetection:"); sb.append(outlierDetection + ","); }
    if (port != null) { sb.append("port:"); sb.append(port + ","); }
    if (tls != null) { sb.append("tls:"); sb.append(tls); }
    sb.append("}");
    return sb.toString();
  }
  class ConnectionPoolNestedImpl<N> extends ConnectionPoolSettingsFluentImpl<TrafficPolicyPortTrafficPolicyFluentImpl.ConnectionPoolNested<N>> implements TrafficPolicyPortTrafficPolicyFluentImpl.ConnectionPoolNested<N>,Nested<N>{
    ConnectionPoolNestedImpl(ConnectionPoolSettings item) {
      this.builder = new ConnectionPoolSettingsBuilder(this, item);
    }
    ConnectionPoolNestedImpl() {
      this.builder = new ConnectionPoolSettingsBuilder(this);
    }
    ConnectionPoolSettingsBuilder builder;
    public N and() {
      return (N) TrafficPolicyPortTrafficPolicyFluentImpl.this.withConnectionPool(builder.build());
    }
    public N endConnectionPool() {
      return and();
    }
    
  }
  class LoadBalancerNestedImpl<N> extends LoadBalancerSettingsFluentImpl<TrafficPolicyPortTrafficPolicyFluentImpl.LoadBalancerNested<N>> implements TrafficPolicyPortTrafficPolicyFluentImpl.LoadBalancerNested<N>,Nested<N>{
    LoadBalancerNestedImpl(LoadBalancerSettings item) {
      this.builder = new LoadBalancerSettingsBuilder(this, item);
    }
    LoadBalancerNestedImpl() {
      this.builder = new LoadBalancerSettingsBuilder(this);
    }
    LoadBalancerSettingsBuilder builder;
    public N and() {
      return (N) TrafficPolicyPortTrafficPolicyFluentImpl.this.withLoadBalancer(builder.build());
    }
    public N endLoadBalancer() {
      return and();
    }
    
  }
  class OutlierDetectionNestedImpl<N> extends OutlierDetectionFluentImpl<TrafficPolicyPortTrafficPolicyFluentImpl.OutlierDetectionNested<N>> implements TrafficPolicyPortTrafficPolicyFluentImpl.OutlierDetectionNested<N>,Nested<N>{
    OutlierDetectionNestedImpl(OutlierDetection item) {
      this.builder = new OutlierDetectionBuilder(this, item);
    }
    OutlierDetectionNestedImpl() {
      this.builder = new OutlierDetectionBuilder(this);
    }
    OutlierDetectionBuilder builder;
    public N and() {
      return (N) TrafficPolicyPortTrafficPolicyFluentImpl.this.withOutlierDetection(builder.build());
    }
    public N endOutlierDetection() {
      return and();
    }
    
  }
  class PortNestedImpl<N> extends PortSelectorFluentImpl<TrafficPolicyPortTrafficPolicyFluentImpl.PortNested<N>> implements TrafficPolicyPortTrafficPolicyFluentImpl.PortNested<N>,Nested<N>{
    PortNestedImpl(PortSelector item) {
      this.builder = new PortSelectorBuilder(this, item);
    }
    PortNestedImpl() {
      this.builder = new PortSelectorBuilder(this);
    }
    PortSelectorBuilder builder;
    public N and() {
      return (N) TrafficPolicyPortTrafficPolicyFluentImpl.this.withPort(builder.build());
    }
    public N endPort() {
      return and();
    }
    
  }
  class TlsNestedImpl<N> extends ClientTLSSettingsFluentImpl<TrafficPolicyPortTrafficPolicyFluentImpl.TlsNested<N>> implements TrafficPolicyPortTrafficPolicyFluentImpl.TlsNested<N>,Nested<N>{
    TlsNestedImpl(ClientTLSSettings item) {
      this.builder = new ClientTLSSettingsBuilder(this, item);
    }
    TlsNestedImpl() {
      this.builder = new ClientTLSSettingsBuilder(this);
    }
    ClientTLSSettingsBuilder builder;
    public N and() {
      return (N) TrafficPolicyPortTrafficPolicyFluentImpl.this.withTls(builder.build());
    }
    public N endTls() {
      return and();
    }
    
  }
  
}