package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.istio.api.meta.v1alpha1.IstioStatusFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import io.fabric8.istio.api.meta.v1alpha1.IstioStatus;
import java.lang.Boolean;

 /**
  * Generated
  */
public interface WorkloadEntryFluent<A extends WorkloadEntryFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public ObjectMeta buildMetadata();
  public A withMetadata(ObjectMeta metadata);
  public Boolean hasMetadata();
  public WorkloadEntryFluent.MetadataNested<A> withNewMetadata();
  public WorkloadEntryFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
  public WorkloadEntryFluent.MetadataNested<A> editMetadata();
  public WorkloadEntryFluent.MetadataNested<A> editOrNewMetadata();
  public WorkloadEntryFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public WorkloadEntrySpec getSpec();
  public WorkloadEntrySpec buildSpec();
  public A withSpec(WorkloadEntrySpec spec);
  public Boolean hasSpec();
  public WorkloadEntryFluent.SpecNested<A> withNewSpec();
  public WorkloadEntryFluent.SpecNested<A> withNewSpecLike(WorkloadEntrySpec item);
  public WorkloadEntryFluent.SpecNested<A> editSpec();
  public WorkloadEntryFluent.SpecNested<A> editOrNewSpec();
  public WorkloadEntryFluent.SpecNested<A> editOrNewSpecLike(WorkloadEntrySpec item);
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public IstioStatus getStatus();
  public IstioStatus buildStatus();
  public A withStatus(IstioStatus status);
  public Boolean hasStatus();
  public WorkloadEntryFluent.StatusNested<A> withNewStatus();
  public WorkloadEntryFluent.StatusNested<A> withNewStatusLike(IstioStatus item);
  public WorkloadEntryFluent.StatusNested<A> editStatus();
  public WorkloadEntryFluent.StatusNested<A> editOrNewStatus();
  public WorkloadEntryFluent.StatusNested<A> editOrNewStatusLike(IstioStatus item);
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<WorkloadEntryFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  public interface SpecNested<N> extends Nested<N>,WorkloadEntrySpecFluent<WorkloadEntryFluent.SpecNested<N>>{
    public N and();
    public N endSpec();
    
  }
  public interface StatusNested<N> extends Nested<N>,IstioStatusFluent<WorkloadEntryFluent.StatusNested<N>>{
    public N and();
    public N endStatus();
    
  }
  
}