package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class WorkloadGroupSpecBuilder extends WorkloadGroupSpecFluentImpl<WorkloadGroupSpecBuilder> implements VisitableBuilder<WorkloadGroupSpec,WorkloadGroupSpecBuilder>{
  public WorkloadGroupSpecBuilder() {
    this(false);
  }
  public WorkloadGroupSpecBuilder(Boolean validationEnabled) {
    this(new WorkloadGroupSpec(), validationEnabled);
  }
  public WorkloadGroupSpecBuilder(WorkloadGroupSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public WorkloadGroupSpecBuilder(WorkloadGroupSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new WorkloadGroupSpec(), validationEnabled);
  }
  public WorkloadGroupSpecBuilder(WorkloadGroupSpecFluent<?> fluent,WorkloadGroupSpec instance) {
    this(fluent, instance, false);
  }
  public WorkloadGroupSpecBuilder(WorkloadGroupSpecFluent<?> fluent,WorkloadGroupSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withMetadata(instance.getMetadata());
      fluent.withProbe(instance.getProbe());
      fluent.withTemplate(instance.getTemplate());
    }
    this.validationEnabled = validationEnabled; 
  }
  public WorkloadGroupSpecBuilder(WorkloadGroupSpec instance) {
    this(instance,false);
  }
  public WorkloadGroupSpecBuilder(WorkloadGroupSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withMetadata(instance.getMetadata());
      this.withProbe(instance.getProbe());
      this.withTemplate(instance.getTemplate());
    }
    this.validationEnabled = validationEnabled; 
  }
  WorkloadGroupSpecFluent<?> fluent;
  Boolean validationEnabled;
  public WorkloadGroupSpec build() {
    WorkloadGroupSpec buildable = new WorkloadGroupSpec(fluent.getMetadata(),fluent.getProbe(),fluent.getTemplate());
    return buildable;
  }
  
}