/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.istio.api.networking.v1beta1.LoadBalancerSettings;
import io.fabric8.istio.api.networking.v1beta1.LoadBalancerSettingsFluent;
import io.fabric8.istio.api.networking.v1beta1.LoadBalancerSettingsFluentImpl;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Objects;

public class LoadBalancerSettingsBuilder
extends LoadBalancerSettingsFluentImpl<LoadBalancerSettingsBuilder>
implements VisitableBuilder<LoadBalancerSettings, LoadBalancerSettingsBuilder> {
    LoadBalancerSettingsFluent<?> fluent;
    Boolean validationEnabled;

    public LoadBalancerSettingsBuilder() {
        this(false);
    }

    public LoadBalancerSettingsBuilder(Boolean validationEnabled) {
        this(new LoadBalancerSettings(), validationEnabled);
    }

    public LoadBalancerSettingsBuilder(LoadBalancerSettingsFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public LoadBalancerSettingsBuilder(LoadBalancerSettingsFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new LoadBalancerSettings(), validationEnabled);
    }

    public LoadBalancerSettingsBuilder(LoadBalancerSettingsFluent<?> fluent, LoadBalancerSettings instance) {
        this(fluent, instance, false);
    }

    public LoadBalancerSettingsBuilder(LoadBalancerSettingsFluent<?> fluent, LoadBalancerSettings instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withLbPolicy(instance.getLbPolicy());
        fluent.withLocalityLbSetting(instance.getLocalityLbSetting());
        this.validationEnabled = validationEnabled;
    }

    public LoadBalancerSettingsBuilder(LoadBalancerSettings instance) {
        this(instance, (Boolean)false);
    }

    public LoadBalancerSettingsBuilder(LoadBalancerSettings instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withLbPolicy(instance.getLbPolicy());
        this.withLocalityLbSetting(instance.getLocalityLbSetting());
        this.validationEnabled = validationEnabled;
    }

    public LoadBalancerSettings build() {
        LoadBalancerSettings buildable = new LoadBalancerSettings(this.fluent.getLbPolicy(), this.fluent.getLocalityLbSetting());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LoadBalancerSettingsBuilder that = (LoadBalancerSettingsBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

