package io.fabric8.istio.api.meta.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IstioConditionBuilder extends IstioConditionFluentImpl<IstioConditionBuilder> implements VisitableBuilder<io.fabric8.istio.api.meta.v1alpha1.IstioCondition,io.fabric8.istio.api.meta.v1alpha1.IstioConditionBuilder>{
  public IstioConditionBuilder() {
    this(false);
  }
  public IstioConditionBuilder(Boolean validationEnabled) {
    this(new IstioCondition(), validationEnabled);
  }
  public IstioConditionBuilder(IstioConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public IstioConditionBuilder(io.fabric8.istio.api.meta.v1alpha1.IstioConditionFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new IstioCondition(), validationEnabled);
  }
  public IstioConditionBuilder(io.fabric8.istio.api.meta.v1alpha1.IstioConditionFluent<?> fluent,io.fabric8.istio.api.meta.v1alpha1.IstioCondition instance) {
    this(fluent, instance, false);
  }
  public IstioConditionBuilder(io.fabric8.istio.api.meta.v1alpha1.IstioConditionFluent<?> fluent,io.fabric8.istio.api.meta.v1alpha1.IstioCondition instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLastProbeTime(instance.getLastProbeTime()); 
    fluent.withLastTransitionTime(instance.getLastTransitionTime()); 
    fluent.withMessage(instance.getMessage()); 
    fluent.withReason(instance.getReason()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withType(instance.getType()); 
    this.validationEnabled = validationEnabled; 
  }
  public IstioConditionBuilder(io.fabric8.istio.api.meta.v1alpha1.IstioCondition instance) {
    this(instance,false);
  }
  public IstioConditionBuilder(io.fabric8.istio.api.meta.v1alpha1.IstioCondition instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withLastProbeTime(instance.getLastProbeTime()); 
    this.withLastTransitionTime(instance.getLastTransitionTime()); 
    this.withMessage(instance.getMessage()); 
    this.withReason(instance.getReason()); 
    this.withStatus(instance.getStatus()); 
    this.withType(instance.getType()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.istio.api.meta.v1alpha1.IstioConditionFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.istio.api.meta.v1alpha1.IstioCondition build() {
    IstioCondition buildable = new IstioCondition(fluent.getLastProbeTime(),fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    return buildable;
  }
  
}