package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClientTLSSettingsBuilder extends ClientTLSSettingsFluentImpl<ClientTLSSettingsBuilder> implements VisitableBuilder<io.fabric8.istio.api.networking.v1beta1.ClientTLSSettings,ClientTLSSettingsBuilder>{
  public ClientTLSSettingsBuilder() {
    this(false);
  }
  public ClientTLSSettingsBuilder(Boolean validationEnabled) {
    this(new ClientTLSSettings(), validationEnabled);
  }
  public ClientTLSSettingsBuilder(io.fabric8.istio.api.networking.v1beta1.ClientTLSSettingsFluent<?> fluent) {
    this(fluent, false);
  }
  public ClientTLSSettingsBuilder(io.fabric8.istio.api.networking.v1beta1.ClientTLSSettingsFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ClientTLSSettings(), validationEnabled);
  }
  public ClientTLSSettingsBuilder(io.fabric8.istio.api.networking.v1beta1.ClientTLSSettingsFluent<?> fluent,io.fabric8.istio.api.networking.v1beta1.ClientTLSSettings instance) {
    this(fluent, instance, false);
  }
  public ClientTLSSettingsBuilder(io.fabric8.istio.api.networking.v1beta1.ClientTLSSettingsFluent<?> fluent,io.fabric8.istio.api.networking.v1beta1.ClientTLSSettings instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCaCertificates(instance.getCaCertificates()); 
    fluent.withClientCertificate(instance.getClientCertificate()); 
    fluent.withCredentialName(instance.getCredentialName()); 
    fluent.withInsecureSkipVerify(instance.getInsecureSkipVerify()); 
    fluent.withMode(instance.getMode()); 
    fluent.withPrivateKey(instance.getPrivateKey()); 
    fluent.withSni(instance.getSni()); 
    fluent.withSubjectAltNames(instance.getSubjectAltNames()); 
    this.validationEnabled = validationEnabled; 
  }
  public ClientTLSSettingsBuilder(io.fabric8.istio.api.networking.v1beta1.ClientTLSSettings instance) {
    this(instance,false);
  }
  public ClientTLSSettingsBuilder(io.fabric8.istio.api.networking.v1beta1.ClientTLSSettings instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCaCertificates(instance.getCaCertificates()); 
    this.withClientCertificate(instance.getClientCertificate()); 
    this.withCredentialName(instance.getCredentialName()); 
    this.withInsecureSkipVerify(instance.getInsecureSkipVerify()); 
    this.withMode(instance.getMode()); 
    this.withPrivateKey(instance.getPrivateKey()); 
    this.withSni(instance.getSni()); 
    this.withSubjectAltNames(instance.getSubjectAltNames()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.istio.api.networking.v1beta1.ClientTLSSettingsFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.istio.api.networking.v1beta1.ClientTLSSettings build() {
    ClientTLSSettings buildable = new ClientTLSSettings(fluent.getCaCertificates(),fluent.getClientCertificate(),fluent.getCredentialName(),fluent.getInsecureSkipVerify(),fluent.getMode(),fluent.getPrivateKey(),fluent.getSni(),fluent.getSubjectAltNames());
    return buildable;
  }
  
}