package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class GatewaySpecFluentImpl<A extends GatewaySpecFluent<A>> extends BaseFluent<A> implements GatewaySpecFluent<A>{
  public GatewaySpecFluentImpl() {
  }
  public GatewaySpecFluentImpl(io.fabric8.istio.api.networking.v1beta1.GatewaySpec instance) {
    this.withSelector(instance.getSelector()); 
    this.withServers(instance.getServers()); 
  }
  private Map<String,java.lang.String> selector;
  private ArrayList<ServerBuilder> servers = new java.util.ArrayList<ServerBuilder>();
  public A addToSelector(java.lang.String key,java.lang.String value) {
    if(this.selector == null && key != null && value != null) { this.selector = new LinkedHashMap(); }
    if(key != null && value != null) {this.selector.put(key, value);} return (A)this;
  }
  public A addToSelector(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.selector == null && map != null) { this.selector = new java.util.LinkedHashMap(); }
    if(map != null) { this.selector.putAll(map);} return (A)this;
  }
  public A removeFromSelector(java.lang.String key) {
    if(this.selector == null) { return (A) this; }
    if(key != null && this.selector != null) {this.selector.remove(key);} return (A)this;
  }
  public A removeFromSelector(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.selector == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.selector != null){this.selector.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.String> getSelector() {
    return this.selector;
  }
  public <K,V>A withSelector(java.util.Map<java.lang.String,java.lang.String> selector) {
    if (selector == null) { this.selector =  null;} else {this.selector = new java.util.LinkedHashMap(selector);} return (A) this;
  }
  public Boolean hasSelector() {
    return this.selector != null;
  }
  public A addToServers(Integer index,io.fabric8.istio.api.networking.v1beta1.Server item) {
    if (this.servers == null) {this.servers = new java.util.ArrayList<io.fabric8.istio.api.networking.v1beta1.ServerBuilder>();}
    io.fabric8.istio.api.networking.v1beta1.ServerBuilder builder = new io.fabric8.istio.api.networking.v1beta1.ServerBuilder(item);_visitables.get("servers").add(index >= 0 ? index : _visitables.get("servers").size(), builder);this.servers.add(index >= 0 ? index : servers.size(), builder); return (A)this;
  }
  public A setToServers(java.lang.Integer index,io.fabric8.istio.api.networking.v1beta1.Server item) {
    if (this.servers == null) {this.servers = new java.util.ArrayList<io.fabric8.istio.api.networking.v1beta1.ServerBuilder>();}
    io.fabric8.istio.api.networking.v1beta1.ServerBuilder builder = new io.fabric8.istio.api.networking.v1beta1.ServerBuilder(item);
    if (index < 0 || index >= _visitables.get("servers").size()) { _visitables.get("servers").add(builder); } else { _visitables.get("servers").set(index, builder);}
    if (index < 0 || index >= servers.size()) { servers.add(builder); } else { servers.set(index, builder);}
     return (A)this;
  }
  public A addToServers(io.fabric8.istio.api.networking.v1beta1.Server... items) {
    if (this.servers == null) {this.servers = new java.util.ArrayList<io.fabric8.istio.api.networking.v1beta1.ServerBuilder>();}
    for (io.fabric8.istio.api.networking.v1beta1.Server item : items) {io.fabric8.istio.api.networking.v1beta1.ServerBuilder builder = new io.fabric8.istio.api.networking.v1beta1.ServerBuilder(item);_visitables.get("servers").add(builder);this.servers.add(builder);} return (A)this;
  }
  public A addAllToServers(Collection<io.fabric8.istio.api.networking.v1beta1.Server> items) {
    if (this.servers == null) {this.servers = new java.util.ArrayList<io.fabric8.istio.api.networking.v1beta1.ServerBuilder>();}
    for (io.fabric8.istio.api.networking.v1beta1.Server item : items) {io.fabric8.istio.api.networking.v1beta1.ServerBuilder builder = new io.fabric8.istio.api.networking.v1beta1.ServerBuilder(item);_visitables.get("servers").add(builder);this.servers.add(builder);} return (A)this;
  }
  public A removeFromServers(io.fabric8.istio.api.networking.v1beta1.Server... items) {
    for (io.fabric8.istio.api.networking.v1beta1.Server item : items) {io.fabric8.istio.api.networking.v1beta1.ServerBuilder builder = new io.fabric8.istio.api.networking.v1beta1.ServerBuilder(item);_visitables.get("servers").remove(builder);if (this.servers != null) {this.servers.remove(builder);}} return (A)this;
  }
  public A removeAllFromServers(java.util.Collection<io.fabric8.istio.api.networking.v1beta1.Server> items) {
    for (io.fabric8.istio.api.networking.v1beta1.Server item : items) {io.fabric8.istio.api.networking.v1beta1.ServerBuilder builder = new io.fabric8.istio.api.networking.v1beta1.ServerBuilder(item);_visitables.get("servers").remove(builder);if (this.servers != null) {this.servers.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromServers(Predicate<io.fabric8.istio.api.networking.v1beta1.ServerBuilder> predicate) {
    if (servers == null) return (A) this;
    final Iterator<io.fabric8.istio.api.networking.v1beta1.ServerBuilder> each = servers.iterator();
    final List visitables = _visitables.get("servers");
    while (each.hasNext()) {
      io.fabric8.istio.api.networking.v1beta1.ServerBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildServers instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<io.fabric8.istio.api.networking.v1beta1.Server> getServers() {
    return servers != null ? build(servers) : null;
  }
  public java.util.List<io.fabric8.istio.api.networking.v1beta1.Server> buildServers() {
    return servers != null ? build(servers) : null;
  }
  public io.fabric8.istio.api.networking.v1beta1.Server buildServer(java.lang.Integer index) {
    return this.servers.get(index).build();
  }
  public io.fabric8.istio.api.networking.v1beta1.Server buildFirstServer() {
    return this.servers.get(0).build();
  }
  public io.fabric8.istio.api.networking.v1beta1.Server buildLastServer() {
    return this.servers.get(servers.size() - 1).build();
  }
  public io.fabric8.istio.api.networking.v1beta1.Server buildMatchingServer(java.util.function.Predicate<io.fabric8.istio.api.networking.v1beta1.ServerBuilder> predicate) {
    for (io.fabric8.istio.api.networking.v1beta1.ServerBuilder item: servers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingServer(java.util.function.Predicate<io.fabric8.istio.api.networking.v1beta1.ServerBuilder> predicate) {
    for (io.fabric8.istio.api.networking.v1beta1.ServerBuilder item: servers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withServers(java.util.List<io.fabric8.istio.api.networking.v1beta1.Server> servers) {
    if (this.servers != null) { _visitables.get("servers").removeAll(this.servers);}
    if (servers != null) {this.servers = new java.util.ArrayList(); for (io.fabric8.istio.api.networking.v1beta1.Server item : servers){this.addToServers(item);}} else { this.servers = null;} return (A) this;
  }
  public A withServers(io.fabric8.istio.api.networking.v1beta1.Server... servers) {
    if (this.servers != null) {this.servers.clear();}
    if (servers != null) {for (io.fabric8.istio.api.networking.v1beta1.Server item :servers){ this.addToServers(item);}} return (A) this;
  }
  public java.lang.Boolean hasServers() {
    return servers != null && !servers.isEmpty();
  }
  public GatewaySpecFluent.ServersNested<A> addNewServer() {
    return new GatewaySpecFluentImpl.ServersNestedImpl();
  }
  public io.fabric8.istio.api.networking.v1beta1.GatewaySpecFluent.ServersNested<A> addNewServerLike(io.fabric8.istio.api.networking.v1beta1.Server item) {
    return new GatewaySpecFluentImpl.ServersNestedImpl(-1, item);
  }
  public io.fabric8.istio.api.networking.v1beta1.GatewaySpecFluent.ServersNested<A> setNewServerLike(java.lang.Integer index,io.fabric8.istio.api.networking.v1beta1.Server item) {
    return new io.fabric8.istio.api.networking.v1beta1.GatewaySpecFluentImpl.ServersNestedImpl(index, item);
  }
  public io.fabric8.istio.api.networking.v1beta1.GatewaySpecFluent.ServersNested<A> editServer(java.lang.Integer index) {
    if (servers.size() <= index) throw new RuntimeException("Can't edit servers. Index exceeds size.");
    return setNewServerLike(index, buildServer(index));
  }
  public io.fabric8.istio.api.networking.v1beta1.GatewaySpecFluent.ServersNested<A> editFirstServer() {
    if (servers.size() == 0) throw new RuntimeException("Can't edit first servers. The list is empty.");
    return setNewServerLike(0, buildServer(0));
  }
  public io.fabric8.istio.api.networking.v1beta1.GatewaySpecFluent.ServersNested<A> editLastServer() {
    int index = servers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last servers. The list is empty.");
    return setNewServerLike(index, buildServer(index));
  }
  public io.fabric8.istio.api.networking.v1beta1.GatewaySpecFluent.ServersNested<A> editMatchingServer(java.util.function.Predicate<io.fabric8.istio.api.networking.v1beta1.ServerBuilder> predicate) {
    int index = -1;
    for (int i=0;i<servers.size();i++) { 
    if (predicate.test(servers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching servers. No match found.");
    return setNewServerLike(index, buildServer(index));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GatewaySpecFluentImpl that = (GatewaySpecFluentImpl) o;
    if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
    if (servers != null ? !servers.equals(that.servers) :that.servers != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(selector,  servers,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (selector != null && !selector.isEmpty()) { sb.append("selector:"); sb.append(selector + ","); }
    if (servers != null && !servers.isEmpty()) { sb.append("servers:"); sb.append(servers); }
    sb.append("}");
    return sb.toString();
  }
  class ServersNestedImpl<N> extends ServerFluentImpl<GatewaySpecFluent.ServersNested<N>> implements io.fabric8.istio.api.networking.v1beta1.GatewaySpecFluent.ServersNested<N>,Nested<N>{
    ServersNestedImpl(java.lang.Integer index,Server item) {
      this.index = index;
      this.builder = new ServerBuilder(this, item);
    }
    ServersNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.istio.api.networking.v1beta1.ServerBuilder(this);
    }
    io.fabric8.istio.api.networking.v1beta1.ServerBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) GatewaySpecFluentImpl.this.setToServers(index,builder.build());
    }
    public N endServer() {
      return and();
    }
    
  }
  
}