package io.fabric8.istio.api.networking.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class HTTPMatchRequestFluentImpl<A extends HTTPMatchRequestFluent<A>> extends BaseFluent<A> implements HTTPMatchRequestFluent<A>{
  public HTTPMatchRequestFluentImpl() {
  }
  public HTTPMatchRequestFluentImpl(io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequest instance) {
    this.withAuthority(instance.getAuthority()); 
    this.withGateways(instance.getGateways()); 
    this.withHeaders(instance.getHeaders()); 
    this.withIgnoreUriCase(instance.getIgnoreUriCase()); 
    this.withMethod(instance.getMethod()); 
    this.withName(instance.getName()); 
    this.withPort(instance.getPort()); 
    this.withQueryParams(instance.getQueryParams()); 
    this.withScheme(instance.getScheme()); 
    this.withSourceLabels(instance.getSourceLabels()); 
    this.withSourceNamespace(instance.getSourceNamespace()); 
    this.withUri(instance.getUri()); 
    this.withWithoutHeaders(instance.getWithoutHeaders()); 
  }
  private StringMatchBuilder authority;
  private List<String> gateways = new ArrayList<java.lang.String>();
  private Map<java.lang.String,io.fabric8.istio.api.networking.v1beta1.StringMatch> headers;
  private Boolean ignoreUriCase;
  private StringMatchBuilder method;
  private java.lang.String name;
  private Integer port;
  private java.util.Map<java.lang.String,io.fabric8.istio.api.networking.v1beta1.StringMatch> queryParams;
  private io.fabric8.istio.api.networking.v1beta1.StringMatchBuilder scheme;
  private java.util.Map<java.lang.String,java.lang.String> sourceLabels;
  private java.lang.String sourceNamespace;
  private io.fabric8.istio.api.networking.v1beta1.StringMatchBuilder uri;
  private java.util.Map<java.lang.String,io.fabric8.istio.api.networking.v1beta1.StringMatch> withoutHeaders;
  
  /**
   * This method has been deprecated, please use method buildAuthority instead.
   * @return The buildable object.
   */
  @Deprecated
  public io.fabric8.istio.api.networking.v1beta1.StringMatch getAuthority() {
    return this.authority!=null ?this.authority.build():null;
  }
  public io.fabric8.istio.api.networking.v1beta1.StringMatch buildAuthority() {
    return this.authority!=null ?this.authority.build():null;
  }
  public A withAuthority(io.fabric8.istio.api.networking.v1beta1.StringMatch authority) {
    _visitables.get("authority").remove(this.authority);
    if (authority!=null){ this.authority= new io.fabric8.istio.api.networking.v1beta1.StringMatchBuilder(authority); _visitables.get("authority").add(this.authority);} return (A) this;
  }
  public java.lang.Boolean hasAuthority() {
    return this.authority != null;
  }
  public HTTPMatchRequestFluent.AuthorityNested<A> withNewAuthority() {
    return new HTTPMatchRequestFluentImpl.AuthorityNestedImpl();
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequestFluent.AuthorityNested<A> withNewAuthorityLike(io.fabric8.istio.api.networking.v1beta1.StringMatch item) {
    return new HTTPMatchRequestFluentImpl.AuthorityNestedImpl(item);
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequestFluent.AuthorityNested<A> editAuthority() {
    return withNewAuthorityLike(getAuthority());
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequestFluent.AuthorityNested<A> editOrNewAuthority() {
    return withNewAuthorityLike(getAuthority() != null ? getAuthority(): new io.fabric8.istio.api.networking.v1beta1.StringMatchBuilder().build());
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequestFluent.AuthorityNested<A> editOrNewAuthorityLike(io.fabric8.istio.api.networking.v1beta1.StringMatch item) {
    return withNewAuthorityLike(getAuthority() != null ? getAuthority(): item);
  }
  public A addToGateways(java.lang.Integer index,java.lang.String item) {
    if (this.gateways == null) {this.gateways = new java.util.ArrayList<java.lang.String>();}
    this.gateways.add(index, item);
    return (A)this;
  }
  public A setToGateways(java.lang.Integer index,java.lang.String item) {
    if (this.gateways == null) {this.gateways = new java.util.ArrayList<java.lang.String>();}
    this.gateways.set(index, item); return (A)this;
  }
  public A addToGateways(java.lang.String... items) {
    if (this.gateways == null) {this.gateways = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.gateways.add(item);} return (A)this;
  }
  public A addAllToGateways(Collection<java.lang.String> items) {
    if (this.gateways == null) {this.gateways = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.gateways.add(item);} return (A)this;
  }
  public A removeFromGateways(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.gateways!= null){ this.gateways.remove(item);}} return (A)this;
  }
  public A removeAllFromGateways(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.gateways!= null){ this.gateways.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getGateways() {
    return this.gateways;
  }
  public java.lang.String getGateway(java.lang.Integer index) {
    return this.gateways.get(index);
  }
  public java.lang.String getFirstGateway() {
    return this.gateways.get(0);
  }
  public java.lang.String getLastGateway() {
    return this.gateways.get(gateways.size() - 1);
  }
  public java.lang.String getMatchingGateway(Predicate<java.lang.String> predicate) {
    for (java.lang.String item: gateways) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingGateway(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: gateways) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withGateways(java.util.List<java.lang.String> gateways) {
    if (gateways != null) {this.gateways = new java.util.ArrayList(); for (java.lang.String item : gateways){this.addToGateways(item);}} else { this.gateways = null;} return (A) this;
  }
  public A withGateways(java.lang.String... gateways) {
    if (this.gateways != null) {this.gateways.clear();}
    if (gateways != null) {for (java.lang.String item :gateways){ this.addToGateways(item);}} return (A) this;
  }
  public java.lang.Boolean hasGateways() {
    return gateways != null && !gateways.isEmpty();
  }
  public A addToHeaders(java.lang.String key,io.fabric8.istio.api.networking.v1beta1.StringMatch value) {
    if(this.headers == null && key != null && value != null) { this.headers = new LinkedHashMap(); }
    if(key != null && value != null) {this.headers.put(key, value);} return (A)this;
  }
  public A addToHeaders(java.util.Map<java.lang.String,io.fabric8.istio.api.networking.v1beta1.StringMatch> map) {
    if(this.headers == null && map != null) { this.headers = new java.util.LinkedHashMap(); }
    if(map != null) { this.headers.putAll(map);} return (A)this;
  }
  public A removeFromHeaders(java.lang.String key) {
    if(this.headers == null) { return (A) this; }
    if(key != null && this.headers != null) {this.headers.remove(key);} return (A)this;
  }
  public A removeFromHeaders(java.util.Map<java.lang.String,io.fabric8.istio.api.networking.v1beta1.StringMatch> map) {
    if(this.headers == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.headers != null){this.headers.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,io.fabric8.istio.api.networking.v1beta1.StringMatch> getHeaders() {
    return this.headers;
  }
  public <K,V>A withHeaders(java.util.Map<java.lang.String,io.fabric8.istio.api.networking.v1beta1.StringMatch> headers) {
    if (headers == null) { this.headers =  null;} else {this.headers = new java.util.LinkedHashMap(headers);} return (A) this;
  }
  public java.lang.Boolean hasHeaders() {
    return this.headers != null;
  }
  public java.lang.Boolean getIgnoreUriCase() {
    return this.ignoreUriCase;
  }
  public A withIgnoreUriCase(java.lang.Boolean ignoreUriCase) {
    this.ignoreUriCase=ignoreUriCase; return (A) this;
  }
  public java.lang.Boolean hasIgnoreUriCase() {
    return this.ignoreUriCase != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMethod instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.istio.api.networking.v1beta1.StringMatch getMethod() {
    return this.method!=null ?this.method.build():null;
  }
  public io.fabric8.istio.api.networking.v1beta1.StringMatch buildMethod() {
    return this.method!=null ?this.method.build():null;
  }
  public A withMethod(io.fabric8.istio.api.networking.v1beta1.StringMatch method) {
    _visitables.get("method").remove(this.method);
    if (method!=null){ this.method= new io.fabric8.istio.api.networking.v1beta1.StringMatchBuilder(method); _visitables.get("method").add(this.method);} return (A) this;
  }
  public java.lang.Boolean hasMethod() {
    return this.method != null;
  }
  public HTTPMatchRequestFluent.MethodNested<A> withNewMethod() {
    return new HTTPMatchRequestFluentImpl.MethodNestedImpl();
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequestFluent.MethodNested<A> withNewMethodLike(io.fabric8.istio.api.networking.v1beta1.StringMatch item) {
    return new io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequestFluentImpl.MethodNestedImpl(item);
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequestFluent.MethodNested<A> editMethod() {
    return withNewMethodLike(getMethod());
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequestFluent.MethodNested<A> editOrNewMethod() {
    return withNewMethodLike(getMethod() != null ? getMethod(): new io.fabric8.istio.api.networking.v1beta1.StringMatchBuilder().build());
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequestFluent.MethodNested<A> editOrNewMethodLike(io.fabric8.istio.api.networking.v1beta1.StringMatch item) {
    return withNewMethodLike(getMethod() != null ? getMethod(): item);
  }
  public java.lang.String getName() {
    return this.name;
  }
  public A withName(java.lang.String name) {
    this.name=name; return (A) this;
  }
  public java.lang.Boolean hasName() {
    return this.name != null;
  }
  public java.lang.Integer getPort() {
    return this.port;
  }
  public A withPort(java.lang.Integer port) {
    this.port=port; return (A) this;
  }
  public java.lang.Boolean hasPort() {
    return this.port != null;
  }
  public A addToQueryParams(java.lang.String key,io.fabric8.istio.api.networking.v1beta1.StringMatch value) {
    if(this.queryParams == null && key != null && value != null) { this.queryParams = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.queryParams.put(key, value);} return (A)this;
  }
  public A addToQueryParams(java.util.Map<java.lang.String,io.fabric8.istio.api.networking.v1beta1.StringMatch> map) {
    if(this.queryParams == null && map != null) { this.queryParams = new java.util.LinkedHashMap(); }
    if(map != null) { this.queryParams.putAll(map);} return (A)this;
  }
  public A removeFromQueryParams(java.lang.String key) {
    if(this.queryParams == null) { return (A) this; }
    if(key != null && this.queryParams != null) {this.queryParams.remove(key);} return (A)this;
  }
  public A removeFromQueryParams(java.util.Map<java.lang.String,io.fabric8.istio.api.networking.v1beta1.StringMatch> map) {
    if(this.queryParams == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.queryParams != null){this.queryParams.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,io.fabric8.istio.api.networking.v1beta1.StringMatch> getQueryParams() {
    return this.queryParams;
  }
  public <K,V>A withQueryParams(java.util.Map<java.lang.String,io.fabric8.istio.api.networking.v1beta1.StringMatch> queryParams) {
    if (queryParams == null) { this.queryParams =  null;} else {this.queryParams = new java.util.LinkedHashMap(queryParams);} return (A) this;
  }
  public java.lang.Boolean hasQueryParams() {
    return this.queryParams != null;
  }
  
  /**
   * This method has been deprecated, please use method buildScheme instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.istio.api.networking.v1beta1.StringMatch getScheme() {
    return this.scheme!=null ?this.scheme.build():null;
  }
  public io.fabric8.istio.api.networking.v1beta1.StringMatch buildScheme() {
    return this.scheme!=null ?this.scheme.build():null;
  }
  public A withScheme(io.fabric8.istio.api.networking.v1beta1.StringMatch scheme) {
    _visitables.get("scheme").remove(this.scheme);
    if (scheme!=null){ this.scheme= new io.fabric8.istio.api.networking.v1beta1.StringMatchBuilder(scheme); _visitables.get("scheme").add(this.scheme);} return (A) this;
  }
  public java.lang.Boolean hasScheme() {
    return this.scheme != null;
  }
  public HTTPMatchRequestFluent.SchemeNested<A> withNewScheme() {
    return new HTTPMatchRequestFluentImpl.SchemeNestedImpl();
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequestFluent.SchemeNested<A> withNewSchemeLike(io.fabric8.istio.api.networking.v1beta1.StringMatch item) {
    return new io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequestFluentImpl.SchemeNestedImpl(item);
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequestFluent.SchemeNested<A> editScheme() {
    return withNewSchemeLike(getScheme());
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequestFluent.SchemeNested<A> editOrNewScheme() {
    return withNewSchemeLike(getScheme() != null ? getScheme(): new io.fabric8.istio.api.networking.v1beta1.StringMatchBuilder().build());
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequestFluent.SchemeNested<A> editOrNewSchemeLike(io.fabric8.istio.api.networking.v1beta1.StringMatch item) {
    return withNewSchemeLike(getScheme() != null ? getScheme(): item);
  }
  public A addToSourceLabels(java.lang.String key,java.lang.String value) {
    if(this.sourceLabels == null && key != null && value != null) { this.sourceLabels = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.sourceLabels.put(key, value);} return (A)this;
  }
  public A addToSourceLabels(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.sourceLabels == null && map != null) { this.sourceLabels = new java.util.LinkedHashMap(); }
    if(map != null) { this.sourceLabels.putAll(map);} return (A)this;
  }
  public A removeFromSourceLabels(java.lang.String key) {
    if(this.sourceLabels == null) { return (A) this; }
    if(key != null && this.sourceLabels != null) {this.sourceLabels.remove(key);} return (A)this;
  }
  public A removeFromSourceLabels(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.sourceLabels == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.sourceLabels != null){this.sourceLabels.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.String> getSourceLabels() {
    return this.sourceLabels;
  }
  public <K,V>A withSourceLabels(java.util.Map<java.lang.String,java.lang.String> sourceLabels) {
    if (sourceLabels == null) { this.sourceLabels =  null;} else {this.sourceLabels = new java.util.LinkedHashMap(sourceLabels);} return (A) this;
  }
  public java.lang.Boolean hasSourceLabels() {
    return this.sourceLabels != null;
  }
  public java.lang.String getSourceNamespace() {
    return this.sourceNamespace;
  }
  public A withSourceNamespace(java.lang.String sourceNamespace) {
    this.sourceNamespace=sourceNamespace; return (A) this;
  }
  public java.lang.Boolean hasSourceNamespace() {
    return this.sourceNamespace != null;
  }
  
  /**
   * This method has been deprecated, please use method buildUri instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.istio.api.networking.v1beta1.StringMatch getUri() {
    return this.uri!=null ?this.uri.build():null;
  }
  public io.fabric8.istio.api.networking.v1beta1.StringMatch buildUri() {
    return this.uri!=null ?this.uri.build():null;
  }
  public A withUri(io.fabric8.istio.api.networking.v1beta1.StringMatch uri) {
    _visitables.get("uri").remove(this.uri);
    if (uri!=null){ this.uri= new io.fabric8.istio.api.networking.v1beta1.StringMatchBuilder(uri); _visitables.get("uri").add(this.uri);} return (A) this;
  }
  public java.lang.Boolean hasUri() {
    return this.uri != null;
  }
  public HTTPMatchRequestFluent.UriNested<A> withNewUri() {
    return new HTTPMatchRequestFluentImpl.UriNestedImpl();
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequestFluent.UriNested<A> withNewUriLike(io.fabric8.istio.api.networking.v1beta1.StringMatch item) {
    return new io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequestFluentImpl.UriNestedImpl(item);
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequestFluent.UriNested<A> editUri() {
    return withNewUriLike(getUri());
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequestFluent.UriNested<A> editOrNewUri() {
    return withNewUriLike(getUri() != null ? getUri(): new io.fabric8.istio.api.networking.v1beta1.StringMatchBuilder().build());
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequestFluent.UriNested<A> editOrNewUriLike(io.fabric8.istio.api.networking.v1beta1.StringMatch item) {
    return withNewUriLike(getUri() != null ? getUri(): item);
  }
  public A addToWithoutHeaders(java.lang.String key,io.fabric8.istio.api.networking.v1beta1.StringMatch value) {
    if(this.withoutHeaders == null && key != null && value != null) { this.withoutHeaders = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.withoutHeaders.put(key, value);} return (A)this;
  }
  public A addToWithoutHeaders(java.util.Map<java.lang.String,io.fabric8.istio.api.networking.v1beta1.StringMatch> map) {
    if(this.withoutHeaders == null && map != null) { this.withoutHeaders = new java.util.LinkedHashMap(); }
    if(map != null) { this.withoutHeaders.putAll(map);} return (A)this;
  }
  public A removeFromWithoutHeaders(java.lang.String key) {
    if(this.withoutHeaders == null) { return (A) this; }
    if(key != null && this.withoutHeaders != null) {this.withoutHeaders.remove(key);} return (A)this;
  }
  public A removeFromWithoutHeaders(java.util.Map<java.lang.String,io.fabric8.istio.api.networking.v1beta1.StringMatch> map) {
    if(this.withoutHeaders == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.withoutHeaders != null){this.withoutHeaders.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,io.fabric8.istio.api.networking.v1beta1.StringMatch> getWithoutHeaders() {
    return this.withoutHeaders;
  }
  public <K,V>A withWithoutHeaders(java.util.Map<java.lang.String,io.fabric8.istio.api.networking.v1beta1.StringMatch> withoutHeaders) {
    if (withoutHeaders == null) { this.withoutHeaders =  null;} else {this.withoutHeaders = new java.util.LinkedHashMap(withoutHeaders);} return (A) this;
  }
  public java.lang.Boolean hasWithoutHeaders() {
    return this.withoutHeaders != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HTTPMatchRequestFluentImpl that = (HTTPMatchRequestFluentImpl) o;
    if (authority != null ? !authority.equals(that.authority) :that.authority != null) return false;
    if (gateways != null ? !gateways.equals(that.gateways) :that.gateways != null) return false;
    if (headers != null ? !headers.equals(that.headers) :that.headers != null) return false;
    if (ignoreUriCase != null ? !ignoreUriCase.equals(that.ignoreUriCase) :that.ignoreUriCase != null) return false;
    if (method != null ? !method.equals(that.method) :that.method != null) return false;
    if (name != null ? !name.equals(that.name) :that.name != null) return false;
    if (port != null ? !port.equals(that.port) :that.port != null) return false;
    if (queryParams != null ? !queryParams.equals(that.queryParams) :that.queryParams != null) return false;
    if (scheme != null ? !scheme.equals(that.scheme) :that.scheme != null) return false;
    if (sourceLabels != null ? !sourceLabels.equals(that.sourceLabels) :that.sourceLabels != null) return false;
    if (sourceNamespace != null ? !sourceNamespace.equals(that.sourceNamespace) :that.sourceNamespace != null) return false;
    if (uri != null ? !uri.equals(that.uri) :that.uri != null) return false;
    if (withoutHeaders != null ? !withoutHeaders.equals(that.withoutHeaders) :that.withoutHeaders != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(authority,  gateways,  headers,  ignoreUriCase,  method,  name,  port,  queryParams,  scheme,  sourceLabels,  sourceNamespace,  uri,  withoutHeaders,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (authority != null) { sb.append("authority:"); sb.append(authority + ","); }
    if (gateways != null && !gateways.isEmpty()) { sb.append("gateways:"); sb.append(gateways + ","); }
    if (headers != null && !headers.isEmpty()) { sb.append("headers:"); sb.append(headers + ","); }
    if (ignoreUriCase != null) { sb.append("ignoreUriCase:"); sb.append(ignoreUriCase + ","); }
    if (method != null) { sb.append("method:"); sb.append(method + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (port != null) { sb.append("port:"); sb.append(port + ","); }
    if (queryParams != null && !queryParams.isEmpty()) { sb.append("queryParams:"); sb.append(queryParams + ","); }
    if (scheme != null) { sb.append("scheme:"); sb.append(scheme + ","); }
    if (sourceLabels != null && !sourceLabels.isEmpty()) { sb.append("sourceLabels:"); sb.append(sourceLabels + ","); }
    if (sourceNamespace != null) { sb.append("sourceNamespace:"); sb.append(sourceNamespace + ","); }
    if (uri != null) { sb.append("uri:"); sb.append(uri + ","); }
    if (withoutHeaders != null && !withoutHeaders.isEmpty()) { sb.append("withoutHeaders:"); sb.append(withoutHeaders); }
    sb.append("}");
    return sb.toString();
  }
  public A withIgnoreUriCase() {
    return withIgnoreUriCase(true);
  }
  class AuthorityNestedImpl<N> extends StringMatchFluentImpl<HTTPMatchRequestFluent.AuthorityNested<N>> implements io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequestFluent.AuthorityNested<N>,Nested<N>{
    AuthorityNestedImpl(io.fabric8.istio.api.networking.v1beta1.StringMatch item) {
      this.builder = new StringMatchBuilder(this, item);
    }
    AuthorityNestedImpl() {
      this.builder = new io.fabric8.istio.api.networking.v1beta1.StringMatchBuilder(this);
    }
    io.fabric8.istio.api.networking.v1beta1.StringMatchBuilder builder;
    public N and() {
      return (N) HTTPMatchRequestFluentImpl.this.withAuthority(builder.build());
    }
    public N endAuthority() {
      return and();
    }
    
  }
  class MethodNestedImpl<N> extends StringMatchFluentImpl<HTTPMatchRequestFluent.MethodNested<N>> implements io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequestFluent.MethodNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    MethodNestedImpl(io.fabric8.istio.api.networking.v1beta1.StringMatch item) {
      this.builder = new StringMatchBuilder(this, item);
    }
    MethodNestedImpl() {
      this.builder = new io.fabric8.istio.api.networking.v1beta1.StringMatchBuilder(this);
    }
    io.fabric8.istio.api.networking.v1beta1.StringMatchBuilder builder;
    public N and() {
      return (N) HTTPMatchRequestFluentImpl.this.withMethod(builder.build());
    }
    public N endMethod() {
      return and();
    }
    
  }
  class SchemeNestedImpl<N> extends StringMatchFluentImpl<HTTPMatchRequestFluent.SchemeNested<N>> implements io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequestFluent.SchemeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    SchemeNestedImpl(io.fabric8.istio.api.networking.v1beta1.StringMatch item) {
      this.builder = new StringMatchBuilder(this, item);
    }
    SchemeNestedImpl() {
      this.builder = new io.fabric8.istio.api.networking.v1beta1.StringMatchBuilder(this);
    }
    io.fabric8.istio.api.networking.v1beta1.StringMatchBuilder builder;
    public N and() {
      return (N) HTTPMatchRequestFluentImpl.this.withScheme(builder.build());
    }
    public N endScheme() {
      return and();
    }
    
  }
  class UriNestedImpl<N> extends StringMatchFluentImpl<HTTPMatchRequestFluent.UriNested<N>> implements io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequestFluent.UriNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    UriNestedImpl(io.fabric8.istio.api.networking.v1beta1.StringMatch item) {
      this.builder = new StringMatchBuilder(this, item);
    }
    UriNestedImpl() {
      this.builder = new io.fabric8.istio.api.networking.v1beta1.StringMatchBuilder(this);
    }
    io.fabric8.istio.api.networking.v1beta1.StringMatchBuilder builder;
    public N and() {
      return (N) HTTPMatchRequestFluentImpl.this.withUri(builder.build());
    }
    public N endUri() {
      return and();
    }
    
  }
  
}