package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Double;
import java.util.Collection;
import java.lang.Object;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import java.util.Iterator;
import java.lang.Integer;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class HTTPRouteFluentImpl<A extends HTTPRouteFluent<A>> extends BaseFluent<A> implements HTTPRouteFluent<A>{
  public HTTPRouteFluentImpl() {
  }
  public HTTPRouteFluentImpl(io.fabric8.istio.api.networking.v1beta1.HTTPRoute instance) {
    this.withCorsPolicy(instance.getCorsPolicy()); 
    this.withDelegate(instance.getDelegate()); 
    this.withFault(instance.getFault()); 
    this.withHeaders(instance.getHeaders()); 
    this.withMatch(instance.getMatch()); 
    this.withMirror(instance.getMirror()); 
    this.withMirrorPercent(instance.getMirrorPercent()); 
    this.withMirrorPercentage(instance.getMirrorPercentage()); 
    this.withName(instance.getName()); 
    this.withRedirect(instance.getRedirect()); 
    this.withRetries(instance.getRetries()); 
    this.withRewrite(instance.getRewrite()); 
    this.withRoute(instance.getRoute()); 
    this.withTimeout(instance.getTimeout()); 
  }
  private CorsPolicyBuilder corsPolicy;
  private DelegateBuilder delegate;
  private HTTPFaultInjectionBuilder fault;
  private HeadersBuilder headers;
  private ArrayList<HTTPMatchRequestBuilder> match = new java.util.ArrayList<HTTPMatchRequestBuilder>();
  private DestinationBuilder mirror;
  private Integer mirrorPercent;
  private PercentBuilder mirrorPercentage;
  private String name;
  private HTTPRedirectBuilder redirect;
  private HTTPRetryBuilder retries;
  private HTTPRewriteBuilder rewrite;
  private java.util.ArrayList<HTTPRouteDestinationBuilder> route = new java.util.ArrayList<HTTPRouteDestinationBuilder>();
  private java.lang.String timeout;
  
  /**
   * This method has been deprecated, please use method buildCorsPolicy instead.
   * @return The buildable object.
   */
  @Deprecated
  public io.fabric8.istio.api.networking.v1beta1.CorsPolicy getCorsPolicy() {
    return this.corsPolicy!=null ?this.corsPolicy.build():null;
  }
  public io.fabric8.istio.api.networking.v1beta1.CorsPolicy buildCorsPolicy() {
    return this.corsPolicy!=null ?this.corsPolicy.build():null;
  }
  public A withCorsPolicy(io.fabric8.istio.api.networking.v1beta1.CorsPolicy corsPolicy) {
    _visitables.get("corsPolicy").remove(this.corsPolicy);
    if (corsPolicy!=null){ this.corsPolicy= new CorsPolicyBuilder(corsPolicy); _visitables.get("corsPolicy").add(this.corsPolicy);} return (A) this;
  }
  public Boolean hasCorsPolicy() {
    return this.corsPolicy != null;
  }
  public HTTPRouteFluent.CorsPolicyNested<A> withNewCorsPolicy() {
    return new HTTPRouteFluentImpl.CorsPolicyNestedImpl();
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.CorsPolicyNested<A> withNewCorsPolicyLike(io.fabric8.istio.api.networking.v1beta1.CorsPolicy item) {
    return new HTTPRouteFluentImpl.CorsPolicyNestedImpl(item);
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.CorsPolicyNested<A> editCorsPolicy() {
    return withNewCorsPolicyLike(getCorsPolicy());
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.CorsPolicyNested<A> editOrNewCorsPolicy() {
    return withNewCorsPolicyLike(getCorsPolicy() != null ? getCorsPolicy(): new io.fabric8.istio.api.networking.v1beta1.CorsPolicyBuilder().build());
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.CorsPolicyNested<A> editOrNewCorsPolicyLike(io.fabric8.istio.api.networking.v1beta1.CorsPolicy item) {
    return withNewCorsPolicyLike(getCorsPolicy() != null ? getCorsPolicy(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildDelegate instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.istio.api.networking.v1beta1.Delegate getDelegate() {
    return this.delegate!=null ?this.delegate.build():null;
  }
  public io.fabric8.istio.api.networking.v1beta1.Delegate buildDelegate() {
    return this.delegate!=null ?this.delegate.build():null;
  }
  public A withDelegate(io.fabric8.istio.api.networking.v1beta1.Delegate delegate) {
    _visitables.get("delegate").remove(this.delegate);
    if (delegate!=null){ this.delegate= new DelegateBuilder(delegate); _visitables.get("delegate").add(this.delegate);} return (A) this;
  }
  public java.lang.Boolean hasDelegate() {
    return this.delegate != null;
  }
  public A withNewDelegate(java.lang.String name,java.lang.String namespace) {
    return (A)withDelegate(new Delegate(name, namespace));
  }
  public HTTPRouteFluent.DelegateNested<A> withNewDelegate() {
    return new HTTPRouteFluentImpl.DelegateNestedImpl();
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.DelegateNested<A> withNewDelegateLike(io.fabric8.istio.api.networking.v1beta1.Delegate item) {
    return new io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluentImpl.DelegateNestedImpl(item);
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.DelegateNested<A> editDelegate() {
    return withNewDelegateLike(getDelegate());
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.DelegateNested<A> editOrNewDelegate() {
    return withNewDelegateLike(getDelegate() != null ? getDelegate(): new io.fabric8.istio.api.networking.v1beta1.DelegateBuilder().build());
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.DelegateNested<A> editOrNewDelegateLike(io.fabric8.istio.api.networking.v1beta1.Delegate item) {
    return withNewDelegateLike(getDelegate() != null ? getDelegate(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildFault instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public HTTPFaultInjection getFault() {
    return this.fault!=null ?this.fault.build():null;
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPFaultInjection buildFault() {
    return this.fault!=null ?this.fault.build():null;
  }
  public A withFault(io.fabric8.istio.api.networking.v1beta1.HTTPFaultInjection fault) {
    _visitables.get("fault").remove(this.fault);
    if (fault!=null){ this.fault= new io.fabric8.istio.api.networking.v1beta1.HTTPFaultInjectionBuilder(fault); _visitables.get("fault").add(this.fault);} return (A) this;
  }
  public java.lang.Boolean hasFault() {
    return this.fault != null;
  }
  public HTTPRouteFluent.FaultNested<A> withNewFault() {
    return new HTTPRouteFluentImpl.FaultNestedImpl();
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.FaultNested<A> withNewFaultLike(io.fabric8.istio.api.networking.v1beta1.HTTPFaultInjection item) {
    return new io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluentImpl.FaultNestedImpl(item);
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.FaultNested<A> editFault() {
    return withNewFaultLike(getFault());
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.FaultNested<A> editOrNewFault() {
    return withNewFaultLike(getFault() != null ? getFault(): new io.fabric8.istio.api.networking.v1beta1.HTTPFaultInjectionBuilder().build());
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.FaultNested<A> editOrNewFaultLike(io.fabric8.istio.api.networking.v1beta1.HTTPFaultInjection item) {
    return withNewFaultLike(getFault() != null ? getFault(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildHeaders instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public Headers getHeaders() {
    return this.headers!=null ?this.headers.build():null;
  }
  public io.fabric8.istio.api.networking.v1beta1.Headers buildHeaders() {
    return this.headers!=null ?this.headers.build():null;
  }
  public A withHeaders(io.fabric8.istio.api.networking.v1beta1.Headers headers) {
    _visitables.get("headers").remove(this.headers);
    if (headers!=null){ this.headers= new io.fabric8.istio.api.networking.v1beta1.HeadersBuilder(headers); _visitables.get("headers").add(this.headers);} return (A) this;
  }
  public java.lang.Boolean hasHeaders() {
    return this.headers != null;
  }
  public HTTPRouteFluent.HeadersNested<A> withNewHeaders() {
    return new HTTPRouteFluentImpl.HeadersNestedImpl();
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.HeadersNested<A> withNewHeadersLike(io.fabric8.istio.api.networking.v1beta1.Headers item) {
    return new io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluentImpl.HeadersNestedImpl(item);
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.HeadersNested<A> editHeaders() {
    return withNewHeadersLike(getHeaders());
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.HeadersNested<A> editOrNewHeaders() {
    return withNewHeadersLike(getHeaders() != null ? getHeaders(): new io.fabric8.istio.api.networking.v1beta1.HeadersBuilder().build());
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.HeadersNested<A> editOrNewHeadersLike(io.fabric8.istio.api.networking.v1beta1.Headers item) {
    return withNewHeadersLike(getHeaders() != null ? getHeaders(): item);
  }
  public A addToMatch(java.lang.Integer index,io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequest item) {
    if (this.match == null) {this.match = new java.util.ArrayList<io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequestBuilder>();}
    io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequestBuilder builder = new io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequestBuilder(item);_visitables.get("match").add(index >= 0 ? index : _visitables.get("match").size(), builder);this.match.add(index >= 0 ? index : match.size(), builder); return (A)this;
  }
  public A setToMatch(java.lang.Integer index,io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequest item) {
    if (this.match == null) {this.match = new java.util.ArrayList<io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequestBuilder>();}
    io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequestBuilder builder = new io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequestBuilder(item);
    if (index < 0 || index >= _visitables.get("match").size()) { _visitables.get("match").add(builder); } else { _visitables.get("match").set(index, builder);}
    if (index < 0 || index >= match.size()) { match.add(builder); } else { match.set(index, builder);}
     return (A)this;
  }
  public A addToMatch(io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequest... items) {
    if (this.match == null) {this.match = new java.util.ArrayList<io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequestBuilder>();}
    for (io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequest item : items) {io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequestBuilder builder = new io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequestBuilder(item);_visitables.get("match").add(builder);this.match.add(builder);} return (A)this;
  }
  public A addAllToMatch(Collection<io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequest> items) {
    if (this.match == null) {this.match = new java.util.ArrayList<io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequestBuilder>();}
    for (io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequest item : items) {io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequestBuilder builder = new io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequestBuilder(item);_visitables.get("match").add(builder);this.match.add(builder);} return (A)this;
  }
  public A removeFromMatch(io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequest... items) {
    for (io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequest item : items) {io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequestBuilder builder = new io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequestBuilder(item);_visitables.get("match").remove(builder);if (this.match != null) {this.match.remove(builder);}} return (A)this;
  }
  public A removeAllFromMatch(java.util.Collection<io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequest> items) {
    for (io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequest item : items) {io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequestBuilder builder = new io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequestBuilder(item);_visitables.get("match").remove(builder);if (this.match != null) {this.match.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromMatch(Predicate<io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequestBuilder> predicate) {
    if (match == null) return (A) this;
    final Iterator<io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequestBuilder> each = match.iterator();
    final List visitables = _visitables.get("match");
    while (each.hasNext()) {
      io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequestBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildMatch instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public List<io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequest> getMatch() {
    return match != null ? build(match) : null;
  }
  public java.util.List<io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequest> buildMatch() {
    return match != null ? build(match) : null;
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequest buildMatch(java.lang.Integer index) {
    return this.match.get(index).build();
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequest buildFirstMatch() {
    return this.match.get(0).build();
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequest buildLastMatch() {
    return this.match.get(match.size() - 1).build();
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequest buildMatchingMatch(java.util.function.Predicate<io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequestBuilder> predicate) {
    for (io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequestBuilder item: match) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingMatch(java.util.function.Predicate<io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequestBuilder> predicate) {
    for (io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequestBuilder item: match) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withMatch(java.util.List<io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequest> match) {
    if (this.match != null) { _visitables.get("match").removeAll(this.match);}
    if (match != null) {this.match = new java.util.ArrayList(); for (io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequest item : match){this.addToMatch(item);}} else { this.match = null;} return (A) this;
  }
  public A withMatch(io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequest... match) {
    if (this.match != null) {this.match.clear();}
    if (match != null) {for (io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequest item :match){ this.addToMatch(item);}} return (A) this;
  }
  public java.lang.Boolean hasMatch() {
    return match != null && !match.isEmpty();
  }
  public HTTPRouteFluent.MatchNested<A> addNewMatch() {
    return new HTTPRouteFluentImpl.MatchNestedImpl();
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.MatchNested<A> addNewMatchLike(io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequest item) {
    return new io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluentImpl.MatchNestedImpl(-1, item);
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.MatchNested<A> setNewMatchLike(java.lang.Integer index,io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequest item) {
    return new io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluentImpl.MatchNestedImpl(index, item);
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.MatchNested<A> editMatch(java.lang.Integer index) {
    if (match.size() <= index) throw new RuntimeException("Can't edit match. Index exceeds size.");
    return setNewMatchLike(index, buildMatch(index));
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.MatchNested<A> editFirstMatch() {
    if (match.size() == 0) throw new RuntimeException("Can't edit first match. The list is empty.");
    return setNewMatchLike(0, buildMatch(0));
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.MatchNested<A> editLastMatch() {
    int index = match.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last match. The list is empty.");
    return setNewMatchLike(index, buildMatch(index));
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.MatchNested<A> editMatchingMatch(java.util.function.Predicate<io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequestBuilder> predicate) {
    int index = -1;
    for (int i=0;i<match.size();i++) { 
    if (predicate.test(match.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching match. No match found.");
    return setNewMatchLike(index, buildMatch(index));
  }
  
  /**
   * This method has been deprecated, please use method buildMirror instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public Destination getMirror() {
    return this.mirror!=null ?this.mirror.build():null;
  }
  public io.fabric8.istio.api.networking.v1beta1.Destination buildMirror() {
    return this.mirror!=null ?this.mirror.build():null;
  }
  public A withMirror(io.fabric8.istio.api.networking.v1beta1.Destination mirror) {
    _visitables.get("mirror").remove(this.mirror);
    if (mirror!=null){ this.mirror= new io.fabric8.istio.api.networking.v1beta1.DestinationBuilder(mirror); _visitables.get("mirror").add(this.mirror);} return (A) this;
  }
  public java.lang.Boolean hasMirror() {
    return this.mirror != null;
  }
  public HTTPRouteFluent.MirrorNested<A> withNewMirror() {
    return new HTTPRouteFluentImpl.MirrorNestedImpl();
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.MirrorNested<A> withNewMirrorLike(io.fabric8.istio.api.networking.v1beta1.Destination item) {
    return new io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluentImpl.MirrorNestedImpl(item);
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.MirrorNested<A> editMirror() {
    return withNewMirrorLike(getMirror());
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.MirrorNested<A> editOrNewMirror() {
    return withNewMirrorLike(getMirror() != null ? getMirror(): new io.fabric8.istio.api.networking.v1beta1.DestinationBuilder().build());
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.MirrorNested<A> editOrNewMirrorLike(io.fabric8.istio.api.networking.v1beta1.Destination item) {
    return withNewMirrorLike(getMirror() != null ? getMirror(): item);
  }
  public java.lang.Integer getMirrorPercent() {
    return this.mirrorPercent;
  }
  public A withMirrorPercent(java.lang.Integer mirrorPercent) {
    this.mirrorPercent=mirrorPercent; return (A) this;
  }
  public java.lang.Boolean hasMirrorPercent() {
    return this.mirrorPercent != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMirrorPercentage instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public Percent getMirrorPercentage() {
    return this.mirrorPercentage!=null ?this.mirrorPercentage.build():null;
  }
  public io.fabric8.istio.api.networking.v1beta1.Percent buildMirrorPercentage() {
    return this.mirrorPercentage!=null ?this.mirrorPercentage.build():null;
  }
  public A withMirrorPercentage(io.fabric8.istio.api.networking.v1beta1.Percent mirrorPercentage) {
    _visitables.get("mirrorPercentage").remove(this.mirrorPercentage);
    if (mirrorPercentage!=null){ this.mirrorPercentage= new io.fabric8.istio.api.networking.v1beta1.PercentBuilder(mirrorPercentage); _visitables.get("mirrorPercentage").add(this.mirrorPercentage);} return (A) this;
  }
  public java.lang.Boolean hasMirrorPercentage() {
    return this.mirrorPercentage != null;
  }
  public A withNewMirrorPercentage(Double value) {
    return (A)withMirrorPercentage(new Percent(value));
  }
  public HTTPRouteFluent.MirrorPercentageNested<A> withNewMirrorPercentage() {
    return new HTTPRouteFluentImpl.MirrorPercentageNestedImpl();
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.MirrorPercentageNested<A> withNewMirrorPercentageLike(io.fabric8.istio.api.networking.v1beta1.Percent item) {
    return new io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluentImpl.MirrorPercentageNestedImpl(item);
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.MirrorPercentageNested<A> editMirrorPercentage() {
    return withNewMirrorPercentageLike(getMirrorPercentage());
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.MirrorPercentageNested<A> editOrNewMirrorPercentage() {
    return withNewMirrorPercentageLike(getMirrorPercentage() != null ? getMirrorPercentage(): new io.fabric8.istio.api.networking.v1beta1.PercentBuilder().build());
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.MirrorPercentageNested<A> editOrNewMirrorPercentageLike(io.fabric8.istio.api.networking.v1beta1.Percent item) {
    return withNewMirrorPercentageLike(getMirrorPercentage() != null ? getMirrorPercentage(): item);
  }
  public java.lang.String getName() {
    return this.name;
  }
  public A withName(java.lang.String name) {
    this.name=name; return (A) this;
  }
  public java.lang.Boolean hasName() {
    return this.name != null;
  }
  
  /**
   * This method has been deprecated, please use method buildRedirect instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.istio.api.networking.v1beta1.HTTPRedirect getRedirect() {
    return this.redirect!=null ?this.redirect.build():null;
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRedirect buildRedirect() {
    return this.redirect!=null ?this.redirect.build():null;
  }
  public A withRedirect(io.fabric8.istio.api.networking.v1beta1.HTTPRedirect redirect) {
    _visitables.get("redirect").remove(this.redirect);
    if (redirect!=null){ this.redirect= new HTTPRedirectBuilder(redirect); _visitables.get("redirect").add(this.redirect);} return (A) this;
  }
  public java.lang.Boolean hasRedirect() {
    return this.redirect != null;
  }
  public HTTPRouteFluent.RedirectNested<A> withNewRedirect() {
    return new HTTPRouteFluentImpl.RedirectNestedImpl();
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.RedirectNested<A> withNewRedirectLike(io.fabric8.istio.api.networking.v1beta1.HTTPRedirect item) {
    return new io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluentImpl.RedirectNestedImpl(item);
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.RedirectNested<A> editRedirect() {
    return withNewRedirectLike(getRedirect());
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.RedirectNested<A> editOrNewRedirect() {
    return withNewRedirectLike(getRedirect() != null ? getRedirect(): new io.fabric8.istio.api.networking.v1beta1.HTTPRedirectBuilder().build());
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.RedirectNested<A> editOrNewRedirectLike(io.fabric8.istio.api.networking.v1beta1.HTTPRedirect item) {
    return withNewRedirectLike(getRedirect() != null ? getRedirect(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildRetries instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.istio.api.networking.v1beta1.HTTPRetry getRetries() {
    return this.retries!=null ?this.retries.build():null;
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRetry buildRetries() {
    return this.retries!=null ?this.retries.build():null;
  }
  public A withRetries(io.fabric8.istio.api.networking.v1beta1.HTTPRetry retries) {
    _visitables.get("retries").remove(this.retries);
    if (retries!=null){ this.retries= new HTTPRetryBuilder(retries); _visitables.get("retries").add(this.retries);} return (A) this;
  }
  public java.lang.Boolean hasRetries() {
    return this.retries != null;
  }
  public A withNewRetries(java.lang.Integer attempts,java.lang.String perTryTimeout,java.lang.String retryOn,java.lang.Boolean retryRemoteLocalities) {
    return (A)withRetries(new HTTPRetry(attempts, perTryTimeout, retryOn, retryRemoteLocalities));
  }
  public HTTPRouteFluent.RetriesNested<A> withNewRetries() {
    return new HTTPRouteFluentImpl.RetriesNestedImpl();
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.RetriesNested<A> withNewRetriesLike(io.fabric8.istio.api.networking.v1beta1.HTTPRetry item) {
    return new io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluentImpl.RetriesNestedImpl(item);
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.RetriesNested<A> editRetries() {
    return withNewRetriesLike(getRetries());
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.RetriesNested<A> editOrNewRetries() {
    return withNewRetriesLike(getRetries() != null ? getRetries(): new io.fabric8.istio.api.networking.v1beta1.HTTPRetryBuilder().build());
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.RetriesNested<A> editOrNewRetriesLike(io.fabric8.istio.api.networking.v1beta1.HTTPRetry item) {
    return withNewRetriesLike(getRetries() != null ? getRetries(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildRewrite instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public HTTPRewrite getRewrite() {
    return this.rewrite!=null ?this.rewrite.build():null;
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRewrite buildRewrite() {
    return this.rewrite!=null ?this.rewrite.build():null;
  }
  public A withRewrite(io.fabric8.istio.api.networking.v1beta1.HTTPRewrite rewrite) {
    _visitables.get("rewrite").remove(this.rewrite);
    if (rewrite!=null){ this.rewrite= new io.fabric8.istio.api.networking.v1beta1.HTTPRewriteBuilder(rewrite); _visitables.get("rewrite").add(this.rewrite);} return (A) this;
  }
  public java.lang.Boolean hasRewrite() {
    return this.rewrite != null;
  }
  public A withNewRewrite(java.lang.String authority,java.lang.String uri) {
    return (A)withRewrite(new HTTPRewrite(authority, uri));
  }
  public HTTPRouteFluent.RewriteNested<A> withNewRewrite() {
    return new HTTPRouteFluentImpl.RewriteNestedImpl();
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.RewriteNested<A> withNewRewriteLike(io.fabric8.istio.api.networking.v1beta1.HTTPRewrite item) {
    return new io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluentImpl.RewriteNestedImpl(item);
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.RewriteNested<A> editRewrite() {
    return withNewRewriteLike(getRewrite());
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.RewriteNested<A> editOrNewRewrite() {
    return withNewRewriteLike(getRewrite() != null ? getRewrite(): new io.fabric8.istio.api.networking.v1beta1.HTTPRewriteBuilder().build());
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.RewriteNested<A> editOrNewRewriteLike(io.fabric8.istio.api.networking.v1beta1.HTTPRewrite item) {
    return withNewRewriteLike(getRewrite() != null ? getRewrite(): item);
  }
  public A addToRoute(java.lang.Integer index,io.fabric8.istio.api.networking.v1beta1.HTTPRouteDestination item) {
    if (this.route == null) {this.route = new java.util.ArrayList<io.fabric8.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder>();}
    io.fabric8.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder builder = new io.fabric8.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder(item);_visitables.get("route").add(index >= 0 ? index : _visitables.get("route").size(), builder);this.route.add(index >= 0 ? index : route.size(), builder); return (A)this;
  }
  public A setToRoute(java.lang.Integer index,io.fabric8.istio.api.networking.v1beta1.HTTPRouteDestination item) {
    if (this.route == null) {this.route = new java.util.ArrayList<io.fabric8.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder>();}
    io.fabric8.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder builder = new io.fabric8.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder(item);
    if (index < 0 || index >= _visitables.get("route").size()) { _visitables.get("route").add(builder); } else { _visitables.get("route").set(index, builder);}
    if (index < 0 || index >= route.size()) { route.add(builder); } else { route.set(index, builder);}
     return (A)this;
  }
  public A addToRoute(io.fabric8.istio.api.networking.v1beta1.HTTPRouteDestination... items) {
    if (this.route == null) {this.route = new java.util.ArrayList<io.fabric8.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder>();}
    for (io.fabric8.istio.api.networking.v1beta1.HTTPRouteDestination item : items) {io.fabric8.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder builder = new io.fabric8.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder(item);_visitables.get("route").add(builder);this.route.add(builder);} return (A)this;
  }
  public A addAllToRoute(java.util.Collection<io.fabric8.istio.api.networking.v1beta1.HTTPRouteDestination> items) {
    if (this.route == null) {this.route = new java.util.ArrayList<io.fabric8.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder>();}
    for (io.fabric8.istio.api.networking.v1beta1.HTTPRouteDestination item : items) {io.fabric8.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder builder = new io.fabric8.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder(item);_visitables.get("route").add(builder);this.route.add(builder);} return (A)this;
  }
  public A removeFromRoute(io.fabric8.istio.api.networking.v1beta1.HTTPRouteDestination... items) {
    for (io.fabric8.istio.api.networking.v1beta1.HTTPRouteDestination item : items) {io.fabric8.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder builder = new io.fabric8.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder(item);_visitables.get("route").remove(builder);if (this.route != null) {this.route.remove(builder);}} return (A)this;
  }
  public A removeAllFromRoute(java.util.Collection<io.fabric8.istio.api.networking.v1beta1.HTTPRouteDestination> items) {
    for (io.fabric8.istio.api.networking.v1beta1.HTTPRouteDestination item : items) {io.fabric8.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder builder = new io.fabric8.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder(item);_visitables.get("route").remove(builder);if (this.route != null) {this.route.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromRoute(java.util.function.Predicate<io.fabric8.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder> predicate) {
    if (route == null) return (A) this;
    final Iterator<io.fabric8.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder> each = route.iterator();
    final List visitables = _visitables.get("route");
    while (each.hasNext()) {
      io.fabric8.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildRoute instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.istio.api.networking.v1beta1.HTTPRouteDestination> getRoute() {
    return route != null ? build(route) : null;
  }
  public java.util.List<io.fabric8.istio.api.networking.v1beta1.HTTPRouteDestination> buildRoute() {
    return route != null ? build(route) : null;
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRouteDestination buildRoute(java.lang.Integer index) {
    return this.route.get(index).build();
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRouteDestination buildFirstRoute() {
    return this.route.get(0).build();
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRouteDestination buildLastRoute() {
    return this.route.get(route.size() - 1).build();
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRouteDestination buildMatchingRoute(java.util.function.Predicate<io.fabric8.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder> predicate) {
    for (io.fabric8.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder item: route) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingRoute(java.util.function.Predicate<io.fabric8.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder> predicate) {
    for (io.fabric8.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder item: route) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRoute(java.util.List<io.fabric8.istio.api.networking.v1beta1.HTTPRouteDestination> route) {
    if (this.route != null) { _visitables.get("route").removeAll(this.route);}
    if (route != null) {this.route = new java.util.ArrayList(); for (io.fabric8.istio.api.networking.v1beta1.HTTPRouteDestination item : route){this.addToRoute(item);}} else { this.route = null;} return (A) this;
  }
  public A withRoute(io.fabric8.istio.api.networking.v1beta1.HTTPRouteDestination... route) {
    if (this.route != null) {this.route.clear();}
    if (route != null) {for (io.fabric8.istio.api.networking.v1beta1.HTTPRouteDestination item :route){ this.addToRoute(item);}} return (A) this;
  }
  public java.lang.Boolean hasRoute() {
    return route != null && !route.isEmpty();
  }
  public HTTPRouteFluent.RouteNested<A> addNewRoute() {
    return new HTTPRouteFluentImpl.RouteNestedImpl();
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.RouteNested<A> addNewRouteLike(io.fabric8.istio.api.networking.v1beta1.HTTPRouteDestination item) {
    return new io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluentImpl.RouteNestedImpl(-1, item);
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.RouteNested<A> setNewRouteLike(java.lang.Integer index,io.fabric8.istio.api.networking.v1beta1.HTTPRouteDestination item) {
    return new io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluentImpl.RouteNestedImpl(index, item);
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.RouteNested<A> editRoute(java.lang.Integer index) {
    if (route.size() <= index) throw new RuntimeException("Can't edit route. Index exceeds size.");
    return setNewRouteLike(index, buildRoute(index));
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.RouteNested<A> editFirstRoute() {
    if (route.size() == 0) throw new RuntimeException("Can't edit first route. The list is empty.");
    return setNewRouteLike(0, buildRoute(0));
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.RouteNested<A> editLastRoute() {
    int index = route.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last route. The list is empty.");
    return setNewRouteLike(index, buildRoute(index));
  }
  public io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.RouteNested<A> editMatchingRoute(java.util.function.Predicate<io.fabric8.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder> predicate) {
    int index = -1;
    for (int i=0;i<route.size();i++) { 
    if (predicate.test(route.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching route. No match found.");
    return setNewRouteLike(index, buildRoute(index));
  }
  public java.lang.String getTimeout() {
    return this.timeout;
  }
  public A withTimeout(java.lang.String timeout) {
    this.timeout=timeout; return (A) this;
  }
  public java.lang.Boolean hasTimeout() {
    return this.timeout != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HTTPRouteFluentImpl that = (HTTPRouteFluentImpl) o;
    if (corsPolicy != null ? !corsPolicy.equals(that.corsPolicy) :that.corsPolicy != null) return false;
    if (delegate != null ? !delegate.equals(that.delegate) :that.delegate != null) return false;
    if (fault != null ? !fault.equals(that.fault) :that.fault != null) return false;
    if (headers != null ? !headers.equals(that.headers) :that.headers != null) return false;
    if (match != null ? !match.equals(that.match) :that.match != null) return false;
    if (mirror != null ? !mirror.equals(that.mirror) :that.mirror != null) return false;
    if (mirrorPercent != null ? !mirrorPercent.equals(that.mirrorPercent) :that.mirrorPercent != null) return false;
    if (mirrorPercentage != null ? !mirrorPercentage.equals(that.mirrorPercentage) :that.mirrorPercentage != null) return false;
    if (name != null ? !name.equals(that.name) :that.name != null) return false;
    if (redirect != null ? !redirect.equals(that.redirect) :that.redirect != null) return false;
    if (retries != null ? !retries.equals(that.retries) :that.retries != null) return false;
    if (rewrite != null ? !rewrite.equals(that.rewrite) :that.rewrite != null) return false;
    if (route != null ? !route.equals(that.route) :that.route != null) return false;
    if (timeout != null ? !timeout.equals(that.timeout) :that.timeout != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(corsPolicy,  delegate,  fault,  headers,  match,  mirror,  mirrorPercent,  mirrorPercentage,  name,  redirect,  retries,  rewrite,  route,  timeout,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (corsPolicy != null) { sb.append("corsPolicy:"); sb.append(corsPolicy + ","); }
    if (delegate != null) { sb.append("delegate:"); sb.append(delegate + ","); }
    if (fault != null) { sb.append("fault:"); sb.append(fault + ","); }
    if (headers != null) { sb.append("headers:"); sb.append(headers + ","); }
    if (match != null && !match.isEmpty()) { sb.append("match:"); sb.append(match + ","); }
    if (mirror != null) { sb.append("mirror:"); sb.append(mirror + ","); }
    if (mirrorPercent != null) { sb.append("mirrorPercent:"); sb.append(mirrorPercent + ","); }
    if (mirrorPercentage != null) { sb.append("mirrorPercentage:"); sb.append(mirrorPercentage + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (redirect != null) { sb.append("redirect:"); sb.append(redirect + ","); }
    if (retries != null) { sb.append("retries:"); sb.append(retries + ","); }
    if (rewrite != null) { sb.append("rewrite:"); sb.append(rewrite + ","); }
    if (route != null && !route.isEmpty()) { sb.append("route:"); sb.append(route + ","); }
    if (timeout != null) { sb.append("timeout:"); sb.append(timeout); }
    sb.append("}");
    return sb.toString();
  }
  class CorsPolicyNestedImpl<N> extends CorsPolicyFluentImpl<HTTPRouteFluent.CorsPolicyNested<N>> implements io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.CorsPolicyNested<N>,Nested<N>{
    CorsPolicyNestedImpl(io.fabric8.istio.api.networking.v1beta1.CorsPolicy item) {
      this.builder = new CorsPolicyBuilder(this, item);
    }
    CorsPolicyNestedImpl() {
      this.builder = new io.fabric8.istio.api.networking.v1beta1.CorsPolicyBuilder(this);
    }
    io.fabric8.istio.api.networking.v1beta1.CorsPolicyBuilder builder;
    public N and() {
      return (N) HTTPRouteFluentImpl.this.withCorsPolicy(builder.build());
    }
    public N endCorsPolicy() {
      return and();
    }
    
  }
  class DelegateNestedImpl<N> extends DelegateFluentImpl<HTTPRouteFluent.DelegateNested<N>> implements io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.DelegateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    DelegateNestedImpl(io.fabric8.istio.api.networking.v1beta1.Delegate item) {
      this.builder = new DelegateBuilder(this, item);
    }
    DelegateNestedImpl() {
      this.builder = new io.fabric8.istio.api.networking.v1beta1.DelegateBuilder(this);
    }
    io.fabric8.istio.api.networking.v1beta1.DelegateBuilder builder;
    public N and() {
      return (N) HTTPRouteFluentImpl.this.withDelegate(builder.build());
    }
    public N endDelegate() {
      return and();
    }
    
  }
  class FaultNestedImpl<N> extends HTTPFaultInjectionFluentImpl<HTTPRouteFluent.FaultNested<N>> implements io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.FaultNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    FaultNestedImpl(io.fabric8.istio.api.networking.v1beta1.HTTPFaultInjection item) {
      this.builder = new HTTPFaultInjectionBuilder(this, item);
    }
    FaultNestedImpl() {
      this.builder = new io.fabric8.istio.api.networking.v1beta1.HTTPFaultInjectionBuilder(this);
    }
    io.fabric8.istio.api.networking.v1beta1.HTTPFaultInjectionBuilder builder;
    public N and() {
      return (N) HTTPRouteFluentImpl.this.withFault(builder.build());
    }
    public N endFault() {
      return and();
    }
    
  }
  class HeadersNestedImpl<N> extends HeadersFluentImpl<HTTPRouteFluent.HeadersNested<N>> implements io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.HeadersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    HeadersNestedImpl(io.fabric8.istio.api.networking.v1beta1.Headers item) {
      this.builder = new HeadersBuilder(this, item);
    }
    HeadersNestedImpl() {
      this.builder = new io.fabric8.istio.api.networking.v1beta1.HeadersBuilder(this);
    }
    io.fabric8.istio.api.networking.v1beta1.HeadersBuilder builder;
    public N and() {
      return (N) HTTPRouteFluentImpl.this.withHeaders(builder.build());
    }
    public N endHeaders() {
      return and();
    }
    
  }
  class MatchNestedImpl<N> extends HTTPMatchRequestFluentImpl<HTTPRouteFluent.MatchNested<N>> implements io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.MatchNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    MatchNestedImpl(java.lang.Integer index,io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequest item) {
      this.index = index;
      this.builder = new HTTPMatchRequestBuilder(this, item);
    }
    MatchNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequestBuilder(this);
    }
    io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequestBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) HTTPRouteFluentImpl.this.setToMatch(index,builder.build());
    }
    public N endMatch() {
      return and();
    }
    
  }
  class MirrorNestedImpl<N> extends DestinationFluentImpl<HTTPRouteFluent.MirrorNested<N>> implements io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.MirrorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    MirrorNestedImpl(io.fabric8.istio.api.networking.v1beta1.Destination item) {
      this.builder = new DestinationBuilder(this, item);
    }
    MirrorNestedImpl() {
      this.builder = new io.fabric8.istio.api.networking.v1beta1.DestinationBuilder(this);
    }
    io.fabric8.istio.api.networking.v1beta1.DestinationBuilder builder;
    public N and() {
      return (N) HTTPRouteFluentImpl.this.withMirror(builder.build());
    }
    public N endMirror() {
      return and();
    }
    
  }
  class MirrorPercentageNestedImpl<N> extends PercentFluentImpl<HTTPRouteFluent.MirrorPercentageNested<N>> implements io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.MirrorPercentageNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    MirrorPercentageNestedImpl(Percent item) {
      this.builder = new PercentBuilder(this, item);
    }
    MirrorPercentageNestedImpl() {
      this.builder = new io.fabric8.istio.api.networking.v1beta1.PercentBuilder(this);
    }
    io.fabric8.istio.api.networking.v1beta1.PercentBuilder builder;
    public N and() {
      return (N) HTTPRouteFluentImpl.this.withMirrorPercentage(builder.build());
    }
    public N endMirrorPercentage() {
      return and();
    }
    
  }
  class RedirectNestedImpl<N> extends HTTPRedirectFluentImpl<HTTPRouteFluent.RedirectNested<N>> implements io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.RedirectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    RedirectNestedImpl(io.fabric8.istio.api.networking.v1beta1.HTTPRedirect item) {
      this.builder = new HTTPRedirectBuilder(this, item);
    }
    RedirectNestedImpl() {
      this.builder = new io.fabric8.istio.api.networking.v1beta1.HTTPRedirectBuilder(this);
    }
    io.fabric8.istio.api.networking.v1beta1.HTTPRedirectBuilder builder;
    public N and() {
      return (N) HTTPRouteFluentImpl.this.withRedirect(builder.build());
    }
    public N endRedirect() {
      return and();
    }
    
  }
  class RetriesNestedImpl<N> extends HTTPRetryFluentImpl<HTTPRouteFluent.RetriesNested<N>> implements io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.RetriesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    RetriesNestedImpl(io.fabric8.istio.api.networking.v1beta1.HTTPRetry item) {
      this.builder = new HTTPRetryBuilder(this, item);
    }
    RetriesNestedImpl() {
      this.builder = new io.fabric8.istio.api.networking.v1beta1.HTTPRetryBuilder(this);
    }
    io.fabric8.istio.api.networking.v1beta1.HTTPRetryBuilder builder;
    public N and() {
      return (N) HTTPRouteFluentImpl.this.withRetries(builder.build());
    }
    public N endRetries() {
      return and();
    }
    
  }
  class RewriteNestedImpl<N> extends HTTPRewriteFluentImpl<HTTPRouteFluent.RewriteNested<N>> implements io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.RewriteNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    RewriteNestedImpl(HTTPRewrite item) {
      this.builder = new HTTPRewriteBuilder(this, item);
    }
    RewriteNestedImpl() {
      this.builder = new io.fabric8.istio.api.networking.v1beta1.HTTPRewriteBuilder(this);
    }
    io.fabric8.istio.api.networking.v1beta1.HTTPRewriteBuilder builder;
    public N and() {
      return (N) HTTPRouteFluentImpl.this.withRewrite(builder.build());
    }
    public N endRewrite() {
      return and();
    }
    
  }
  class RouteNestedImpl<N> extends HTTPRouteDestinationFluentImpl<HTTPRouteFluent.RouteNested<N>> implements io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent.RouteNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    RouteNestedImpl(java.lang.Integer index,io.fabric8.istio.api.networking.v1beta1.HTTPRouteDestination item) {
      this.index = index;
      this.builder = new HTTPRouteDestinationBuilder(this, item);
    }
    RouteNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder(this);
    }
    io.fabric8.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) HTTPRouteFluentImpl.this.setToRoute(index,builder.build());
    }
    public N endRoute() {
      return and();
    }
    
  }
  
}