package io.fabric8.istio.api.networking.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class IstioEgressListenerFluentImpl<A extends IstioEgressListenerFluent<A>> extends BaseFluent<A> implements IstioEgressListenerFluent<A>{
  public IstioEgressListenerFluentImpl() {
  }
  public IstioEgressListenerFluentImpl(io.fabric8.istio.api.networking.v1beta1.IstioEgressListener instance) {
    this.withBind(instance.getBind()); 
    this.withCaptureMode(instance.getCaptureMode()); 
    this.withHosts(instance.getHosts()); 
    this.withPort(instance.getPort()); 
  }
  private String bind;
  private CaptureMode captureMode;
  private List<java.lang.String> hosts = new ArrayList<java.lang.String>();
  private PortBuilder port;
  public java.lang.String getBind() {
    return this.bind;
  }
  public A withBind(java.lang.String bind) {
    this.bind=bind; return (A) this;
  }
  public Boolean hasBind() {
    return this.bind != null;
  }
  public io.fabric8.istio.api.networking.v1beta1.CaptureMode getCaptureMode() {
    return this.captureMode;
  }
  public A withCaptureMode(io.fabric8.istio.api.networking.v1beta1.CaptureMode captureMode) {
    this.captureMode=captureMode; return (A) this;
  }
  public java.lang.Boolean hasCaptureMode() {
    return this.captureMode != null;
  }
  public A addToHosts(Integer index,java.lang.String item) {
    if (this.hosts == null) {this.hosts = new java.util.ArrayList<java.lang.String>();}
    this.hosts.add(index, item);
    return (A)this;
  }
  public A setToHosts(java.lang.Integer index,java.lang.String item) {
    if (this.hosts == null) {this.hosts = new java.util.ArrayList<java.lang.String>();}
    this.hosts.set(index, item); return (A)this;
  }
  public A addToHosts(java.lang.String... items) {
    if (this.hosts == null) {this.hosts = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.hosts.add(item);} return (A)this;
  }
  public A addAllToHosts(Collection<java.lang.String> items) {
    if (this.hosts == null) {this.hosts = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.hosts.add(item);} return (A)this;
  }
  public A removeFromHosts(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.hosts!= null){ this.hosts.remove(item);}} return (A)this;
  }
  public A removeAllFromHosts(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.hosts!= null){ this.hosts.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getHosts() {
    return this.hosts;
  }
  public java.lang.String getHost(java.lang.Integer index) {
    return this.hosts.get(index);
  }
  public java.lang.String getFirstHost() {
    return this.hosts.get(0);
  }
  public java.lang.String getLastHost() {
    return this.hosts.get(hosts.size() - 1);
  }
  public java.lang.String getMatchingHost(Predicate<java.lang.String> predicate) {
    for (java.lang.String item: hosts) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingHost(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: hosts) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withHosts(java.util.List<java.lang.String> hosts) {
    if (hosts != null) {this.hosts = new java.util.ArrayList(); for (java.lang.String item : hosts){this.addToHosts(item);}} else { this.hosts = null;} return (A) this;
  }
  public A withHosts(java.lang.String... hosts) {
    if (this.hosts != null) {this.hosts.clear();}
    if (hosts != null) {for (java.lang.String item :hosts){ this.addToHosts(item);}} return (A) this;
  }
  public java.lang.Boolean hasHosts() {
    return hosts != null && !hosts.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildPort instead.
   * @return The buildable object.
   */
  @Deprecated
  public io.fabric8.istio.api.networking.v1beta1.Port getPort() {
    return this.port!=null ?this.port.build():null;
  }
  public io.fabric8.istio.api.networking.v1beta1.Port buildPort() {
    return this.port!=null ?this.port.build():null;
  }
  public A withPort(io.fabric8.istio.api.networking.v1beta1.Port port) {
    _visitables.get("port").remove(this.port);
    if (port!=null){ this.port= new PortBuilder(port); _visitables.get("port").add(this.port);} return (A) this;
  }
  public java.lang.Boolean hasPort() {
    return this.port != null;
  }
  public A withNewPort(java.lang.String name,java.lang.Integer number,java.lang.String protocol,java.lang.Integer targetPort) {
    return (A)withPort(new Port(name, number, protocol, targetPort));
  }
  public IstioEgressListenerFluent.PortNested<A> withNewPort() {
    return new IstioEgressListenerFluentImpl.PortNestedImpl();
  }
  public io.fabric8.istio.api.networking.v1beta1.IstioEgressListenerFluent.PortNested<A> withNewPortLike(io.fabric8.istio.api.networking.v1beta1.Port item) {
    return new IstioEgressListenerFluentImpl.PortNestedImpl(item);
  }
  public io.fabric8.istio.api.networking.v1beta1.IstioEgressListenerFluent.PortNested<A> editPort() {
    return withNewPortLike(getPort());
  }
  public io.fabric8.istio.api.networking.v1beta1.IstioEgressListenerFluent.PortNested<A> editOrNewPort() {
    return withNewPortLike(getPort() != null ? getPort(): new io.fabric8.istio.api.networking.v1beta1.PortBuilder().build());
  }
  public io.fabric8.istio.api.networking.v1beta1.IstioEgressListenerFluent.PortNested<A> editOrNewPortLike(io.fabric8.istio.api.networking.v1beta1.Port item) {
    return withNewPortLike(getPort() != null ? getPort(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    IstioEgressListenerFluentImpl that = (IstioEgressListenerFluentImpl) o;
    if (bind != null ? !bind.equals(that.bind) :that.bind != null) return false;
    if (captureMode != null ? !captureMode.equals(that.captureMode) :that.captureMode != null) return false;
    if (hosts != null ? !hosts.equals(that.hosts) :that.hosts != null) return false;
    if (port != null ? !port.equals(that.port) :that.port != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(bind,  captureMode,  hosts,  port,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (bind != null) { sb.append("bind:"); sb.append(bind + ","); }
    if (captureMode != null) { sb.append("captureMode:"); sb.append(captureMode + ","); }
    if (hosts != null && !hosts.isEmpty()) { sb.append("hosts:"); sb.append(hosts + ","); }
    if (port != null) { sb.append("port:"); sb.append(port); }
    sb.append("}");
    return sb.toString();
  }
  class PortNestedImpl<N> extends PortFluentImpl<IstioEgressListenerFluent.PortNested<N>> implements io.fabric8.istio.api.networking.v1beta1.IstioEgressListenerFluent.PortNested<N>,Nested<N>{
    PortNestedImpl(Port item) {
      this.builder = new PortBuilder(this, item);
    }
    PortNestedImpl() {
      this.builder = new io.fabric8.istio.api.networking.v1beta1.PortBuilder(this);
    }
    io.fabric8.istio.api.networking.v1beta1.PortBuilder builder;
    public N and() {
      return (N) IstioEgressListenerFluentImpl.this.withPort(builder.build());
    }
    public N endPort() {
      return and();
    }
    
  }
  
}