package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class LoadBalancerSettingsBuilder extends LoadBalancerSettingsFluentImpl<LoadBalancerSettingsBuilder> implements VisitableBuilder<io.fabric8.istio.api.networking.v1beta1.LoadBalancerSettings,io.fabric8.istio.api.networking.v1beta1.LoadBalancerSettingsBuilder>{
  public LoadBalancerSettingsBuilder() {
    this(false);
  }
  public LoadBalancerSettingsBuilder(Boolean validationEnabled) {
    this(new LoadBalancerSettings(), validationEnabled);
  }
  public LoadBalancerSettingsBuilder(LoadBalancerSettingsFluent<?> fluent) {
    this(fluent, false);
  }
  public LoadBalancerSettingsBuilder(io.fabric8.istio.api.networking.v1beta1.LoadBalancerSettingsFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new LoadBalancerSettings(), validationEnabled);
  }
  public LoadBalancerSettingsBuilder(io.fabric8.istio.api.networking.v1beta1.LoadBalancerSettingsFluent<?> fluent,io.fabric8.istio.api.networking.v1beta1.LoadBalancerSettings instance) {
    this(fluent, instance, false);
  }
  public LoadBalancerSettingsBuilder(io.fabric8.istio.api.networking.v1beta1.LoadBalancerSettingsFluent<?> fluent,io.fabric8.istio.api.networking.v1beta1.LoadBalancerSettings instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLbPolicy(instance.getLbPolicy()); 
    fluent.withLocalityLbSetting(instance.getLocalityLbSetting()); 
    this.validationEnabled = validationEnabled; 
  }
  public LoadBalancerSettingsBuilder(io.fabric8.istio.api.networking.v1beta1.LoadBalancerSettings instance) {
    this(instance,false);
  }
  public LoadBalancerSettingsBuilder(io.fabric8.istio.api.networking.v1beta1.LoadBalancerSettings instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withLbPolicy(instance.getLbPolicy()); 
    this.withLocalityLbSetting(instance.getLocalityLbSetting()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.istio.api.networking.v1beta1.LoadBalancerSettingsFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.istio.api.networking.v1beta1.LoadBalancerSettings build() {
    LoadBalancerSettings buildable = new LoadBalancerSettings(fluent.getLbPolicy(),fluent.getLocalityLbSetting());
    return buildable;
  }
  
}