package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PortBuilder extends PortFluentImpl<PortBuilder> implements VisitableBuilder<Port,io.fabric8.istio.api.networking.v1beta1.PortBuilder>{
  public PortBuilder() {
    this(false);
  }
  public PortBuilder(Boolean validationEnabled) {
    this(new Port(), validationEnabled);
  }
  public PortBuilder(PortFluent<?> fluent) {
    this(fluent, false);
  }
  public PortBuilder(io.fabric8.istio.api.networking.v1beta1.PortFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Port(), validationEnabled);
  }
  public PortBuilder(io.fabric8.istio.api.networking.v1beta1.PortFluent<?> fluent,io.fabric8.istio.api.networking.v1beta1.Port instance) {
    this(fluent, instance, false);
  }
  public PortBuilder(io.fabric8.istio.api.networking.v1beta1.PortFluent<?> fluent,io.fabric8.istio.api.networking.v1beta1.Port instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withNumber(instance.getNumber()); 
    fluent.withProtocol(instance.getProtocol()); 
    fluent.withTargetPort(instance.getTargetPort()); 
    this.validationEnabled = validationEnabled; 
  }
  public PortBuilder(io.fabric8.istio.api.networking.v1beta1.Port instance) {
    this(instance,false);
  }
  public PortBuilder(io.fabric8.istio.api.networking.v1beta1.Port instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withNumber(instance.getNumber()); 
    this.withProtocol(instance.getProtocol()); 
    this.withTargetPort(instance.getTargetPort()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.istio.api.networking.v1beta1.PortFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.istio.api.networking.v1beta1.Port build() {
    Port buildable = new Port(fluent.getName(),fluent.getNumber(),fluent.getProtocol(),fluent.getTargetPort());
    return buildable;
  }
  
}