package io.fabric8.istio.api.networking.v1beta1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ServerTLSSettingsFluentImpl<A extends ServerTLSSettingsFluent<A>> extends BaseFluent<A> implements ServerTLSSettingsFluent<A>{
  public ServerTLSSettingsFluentImpl() {
  }
  public ServerTLSSettingsFluentImpl(io.fabric8.istio.api.networking.v1beta1.ServerTLSSettings instance) {
    this.withCaCertificates(instance.getCaCertificates()); 
    this.withCipherSuites(instance.getCipherSuites()); 
    this.withCredentialName(instance.getCredentialName()); 
    this.withHttpsRedirect(instance.getHttpsRedirect()); 
    this.withMaxProtocolVersion(instance.getMaxProtocolVersion()); 
    this.withMinProtocolVersion(instance.getMinProtocolVersion()); 
    this.withMode(instance.getMode()); 
    this.withPrivateKey(instance.getPrivateKey()); 
    this.withServerCertificate(instance.getServerCertificate()); 
    this.withSubjectAltNames(instance.getSubjectAltNames()); 
    this.withVerifyCertificateHash(instance.getVerifyCertificateHash()); 
    this.withVerifyCertificateSpki(instance.getVerifyCertificateSpki()); 
  }
  private String caCertificates;
  private List<java.lang.String> cipherSuites = new ArrayList<java.lang.String>();
  private java.lang.String credentialName;
  private Boolean httpsRedirect;
  private ServerTLSSettingsTLSProtocol maxProtocolVersion;
  private io.fabric8.istio.api.networking.v1beta1.ServerTLSSettingsTLSProtocol minProtocolVersion;
  private ServerTLSSettingsTLSmode mode;
  private java.lang.String privateKey;
  private java.lang.String serverCertificate;
  private java.util.List<java.lang.String> subjectAltNames = new java.util.ArrayList<java.lang.String>();
  private java.util.List<java.lang.String> verifyCertificateHash = new java.util.ArrayList<java.lang.String>();
  private java.util.List<java.lang.String> verifyCertificateSpki = new java.util.ArrayList<java.lang.String>();
  public java.lang.String getCaCertificates() {
    return this.caCertificates;
  }
  public A withCaCertificates(java.lang.String caCertificates) {
    this.caCertificates=caCertificates; return (A) this;
  }
  public java.lang.Boolean hasCaCertificates() {
    return this.caCertificates != null;
  }
  public A addToCipherSuites(Integer index,java.lang.String item) {
    if (this.cipherSuites == null) {this.cipherSuites = new java.util.ArrayList<java.lang.String>();}
    this.cipherSuites.add(index, item);
    return (A)this;
  }
  public A setToCipherSuites(java.lang.Integer index,java.lang.String item) {
    if (this.cipherSuites == null) {this.cipherSuites = new java.util.ArrayList<java.lang.String>();}
    this.cipherSuites.set(index, item); return (A)this;
  }
  public A addToCipherSuites(java.lang.String... items) {
    if (this.cipherSuites == null) {this.cipherSuites = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.cipherSuites.add(item);} return (A)this;
  }
  public A addAllToCipherSuites(Collection<java.lang.String> items) {
    if (this.cipherSuites == null) {this.cipherSuites = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.cipherSuites.add(item);} return (A)this;
  }
  public A removeFromCipherSuites(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.cipherSuites!= null){ this.cipherSuites.remove(item);}} return (A)this;
  }
  public A removeAllFromCipherSuites(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.cipherSuites!= null){ this.cipherSuites.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getCipherSuites() {
    return this.cipherSuites;
  }
  public java.lang.String getCipherSuite(java.lang.Integer index) {
    return this.cipherSuites.get(index);
  }
  public java.lang.String getFirstCipherSuite() {
    return this.cipherSuites.get(0);
  }
  public java.lang.String getLastCipherSuite() {
    return this.cipherSuites.get(cipherSuites.size() - 1);
  }
  public java.lang.String getMatchingCipherSuite(Predicate<java.lang.String> predicate) {
    for (java.lang.String item: cipherSuites) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingCipherSuite(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: cipherSuites) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withCipherSuites(java.util.List<java.lang.String> cipherSuites) {
    if (cipherSuites != null) {this.cipherSuites = new java.util.ArrayList(); for (java.lang.String item : cipherSuites){this.addToCipherSuites(item);}} else { this.cipherSuites = null;} return (A) this;
  }
  public A withCipherSuites(java.lang.String... cipherSuites) {
    if (this.cipherSuites != null) {this.cipherSuites.clear();}
    if (cipherSuites != null) {for (java.lang.String item :cipherSuites){ this.addToCipherSuites(item);}} return (A) this;
  }
  public java.lang.Boolean hasCipherSuites() {
    return cipherSuites != null && !cipherSuites.isEmpty();
  }
  public java.lang.String getCredentialName() {
    return this.credentialName;
  }
  public A withCredentialName(java.lang.String credentialName) {
    this.credentialName=credentialName; return (A) this;
  }
  public java.lang.Boolean hasCredentialName() {
    return this.credentialName != null;
  }
  public java.lang.Boolean getHttpsRedirect() {
    return this.httpsRedirect;
  }
  public A withHttpsRedirect(java.lang.Boolean httpsRedirect) {
    this.httpsRedirect=httpsRedirect; return (A) this;
  }
  public java.lang.Boolean hasHttpsRedirect() {
    return this.httpsRedirect != null;
  }
  public io.fabric8.istio.api.networking.v1beta1.ServerTLSSettingsTLSProtocol getMaxProtocolVersion() {
    return this.maxProtocolVersion;
  }
  public A withMaxProtocolVersion(io.fabric8.istio.api.networking.v1beta1.ServerTLSSettingsTLSProtocol maxProtocolVersion) {
    this.maxProtocolVersion=maxProtocolVersion; return (A) this;
  }
  public java.lang.Boolean hasMaxProtocolVersion() {
    return this.maxProtocolVersion != null;
  }
  public io.fabric8.istio.api.networking.v1beta1.ServerTLSSettingsTLSProtocol getMinProtocolVersion() {
    return this.minProtocolVersion;
  }
  public A withMinProtocolVersion(io.fabric8.istio.api.networking.v1beta1.ServerTLSSettingsTLSProtocol minProtocolVersion) {
    this.minProtocolVersion=minProtocolVersion; return (A) this;
  }
  public java.lang.Boolean hasMinProtocolVersion() {
    return this.minProtocolVersion != null;
  }
  public io.fabric8.istio.api.networking.v1beta1.ServerTLSSettingsTLSmode getMode() {
    return this.mode;
  }
  public A withMode(io.fabric8.istio.api.networking.v1beta1.ServerTLSSettingsTLSmode mode) {
    this.mode=mode; return (A) this;
  }
  public java.lang.Boolean hasMode() {
    return this.mode != null;
  }
  public java.lang.String getPrivateKey() {
    return this.privateKey;
  }
  public A withPrivateKey(java.lang.String privateKey) {
    this.privateKey=privateKey; return (A) this;
  }
  public java.lang.Boolean hasPrivateKey() {
    return this.privateKey != null;
  }
  public java.lang.String getServerCertificate() {
    return this.serverCertificate;
  }
  public A withServerCertificate(java.lang.String serverCertificate) {
    this.serverCertificate=serverCertificate; return (A) this;
  }
  public java.lang.Boolean hasServerCertificate() {
    return this.serverCertificate != null;
  }
  public A addToSubjectAltNames(java.lang.Integer index,java.lang.String item) {
    if (this.subjectAltNames == null) {this.subjectAltNames = new java.util.ArrayList<java.lang.String>();}
    this.subjectAltNames.add(index, item);
    return (A)this;
  }
  public A setToSubjectAltNames(java.lang.Integer index,java.lang.String item) {
    if (this.subjectAltNames == null) {this.subjectAltNames = new java.util.ArrayList<java.lang.String>();}
    this.subjectAltNames.set(index, item); return (A)this;
  }
  public A addToSubjectAltNames(java.lang.String... items) {
    if (this.subjectAltNames == null) {this.subjectAltNames = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.subjectAltNames.add(item);} return (A)this;
  }
  public A addAllToSubjectAltNames(java.util.Collection<java.lang.String> items) {
    if (this.subjectAltNames == null) {this.subjectAltNames = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.subjectAltNames.add(item);} return (A)this;
  }
  public A removeFromSubjectAltNames(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.subjectAltNames!= null){ this.subjectAltNames.remove(item);}} return (A)this;
  }
  public A removeAllFromSubjectAltNames(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.subjectAltNames!= null){ this.subjectAltNames.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getSubjectAltNames() {
    return this.subjectAltNames;
  }
  public java.lang.String getSubjectAltName(java.lang.Integer index) {
    return this.subjectAltNames.get(index);
  }
  public java.lang.String getFirstSubjectAltName() {
    return this.subjectAltNames.get(0);
  }
  public java.lang.String getLastSubjectAltName() {
    return this.subjectAltNames.get(subjectAltNames.size() - 1);
  }
  public java.lang.String getMatchingSubjectAltName(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: subjectAltNames) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingSubjectAltName(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: subjectAltNames) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSubjectAltNames(java.util.List<java.lang.String> subjectAltNames) {
    if (subjectAltNames != null) {this.subjectAltNames = new java.util.ArrayList(); for (java.lang.String item : subjectAltNames){this.addToSubjectAltNames(item);}} else { this.subjectAltNames = null;} return (A) this;
  }
  public A withSubjectAltNames(java.lang.String... subjectAltNames) {
    if (this.subjectAltNames != null) {this.subjectAltNames.clear();}
    if (subjectAltNames != null) {for (java.lang.String item :subjectAltNames){ this.addToSubjectAltNames(item);}} return (A) this;
  }
  public java.lang.Boolean hasSubjectAltNames() {
    return subjectAltNames != null && !subjectAltNames.isEmpty();
  }
  public A addToVerifyCertificateHash(java.lang.Integer index,java.lang.String item) {
    if (this.verifyCertificateHash == null) {this.verifyCertificateHash = new java.util.ArrayList<java.lang.String>();}
    this.verifyCertificateHash.add(index, item);
    return (A)this;
  }
  public A setToVerifyCertificateHash(java.lang.Integer index,java.lang.String item) {
    if (this.verifyCertificateHash == null) {this.verifyCertificateHash = new java.util.ArrayList<java.lang.String>();}
    this.verifyCertificateHash.set(index, item); return (A)this;
  }
  public A addToVerifyCertificateHash(java.lang.String... items) {
    if (this.verifyCertificateHash == null) {this.verifyCertificateHash = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.verifyCertificateHash.add(item);} return (A)this;
  }
  public A addAllToVerifyCertificateHash(java.util.Collection<java.lang.String> items) {
    if (this.verifyCertificateHash == null) {this.verifyCertificateHash = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.verifyCertificateHash.add(item);} return (A)this;
  }
  public A removeFromVerifyCertificateHash(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.verifyCertificateHash!= null){ this.verifyCertificateHash.remove(item);}} return (A)this;
  }
  public A removeAllFromVerifyCertificateHash(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.verifyCertificateHash!= null){ this.verifyCertificateHash.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getVerifyCertificateHash() {
    return this.verifyCertificateHash;
  }
  public java.lang.String getVerifyCertificateHash(java.lang.Integer index) {
    return this.verifyCertificateHash.get(index);
  }
  public java.lang.String getFirstVerifyCertificateHash() {
    return this.verifyCertificateHash.get(0);
  }
  public java.lang.String getLastVerifyCertificateHash() {
    return this.verifyCertificateHash.get(verifyCertificateHash.size() - 1);
  }
  public java.lang.String getMatchingVerifyCertificateHash(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: verifyCertificateHash) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingVerifyCertificateHash(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: verifyCertificateHash) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withVerifyCertificateHash(java.util.List<java.lang.String> verifyCertificateHash) {
    if (verifyCertificateHash != null) {this.verifyCertificateHash = new java.util.ArrayList(); for (java.lang.String item : verifyCertificateHash){this.addToVerifyCertificateHash(item);}} else { this.verifyCertificateHash = null;} return (A) this;
  }
  public A withVerifyCertificateHash(java.lang.String... verifyCertificateHash) {
    if (this.verifyCertificateHash != null) {this.verifyCertificateHash.clear();}
    if (verifyCertificateHash != null) {for (java.lang.String item :verifyCertificateHash){ this.addToVerifyCertificateHash(item);}} return (A) this;
  }
  public java.lang.Boolean hasVerifyCertificateHash() {
    return verifyCertificateHash != null && !verifyCertificateHash.isEmpty();
  }
  public A addToVerifyCertificateSpki(java.lang.Integer index,java.lang.String item) {
    if (this.verifyCertificateSpki == null) {this.verifyCertificateSpki = new java.util.ArrayList<java.lang.String>();}
    this.verifyCertificateSpki.add(index, item);
    return (A)this;
  }
  public A setToVerifyCertificateSpki(java.lang.Integer index,java.lang.String item) {
    if (this.verifyCertificateSpki == null) {this.verifyCertificateSpki = new java.util.ArrayList<java.lang.String>();}
    this.verifyCertificateSpki.set(index, item); return (A)this;
  }
  public A addToVerifyCertificateSpki(java.lang.String... items) {
    if (this.verifyCertificateSpki == null) {this.verifyCertificateSpki = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.verifyCertificateSpki.add(item);} return (A)this;
  }
  public A addAllToVerifyCertificateSpki(java.util.Collection<java.lang.String> items) {
    if (this.verifyCertificateSpki == null) {this.verifyCertificateSpki = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.verifyCertificateSpki.add(item);} return (A)this;
  }
  public A removeFromVerifyCertificateSpki(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.verifyCertificateSpki!= null){ this.verifyCertificateSpki.remove(item);}} return (A)this;
  }
  public A removeAllFromVerifyCertificateSpki(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.verifyCertificateSpki!= null){ this.verifyCertificateSpki.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getVerifyCertificateSpki() {
    return this.verifyCertificateSpki;
  }
  public java.lang.String getVerifyCertificateSpki(java.lang.Integer index) {
    return this.verifyCertificateSpki.get(index);
  }
  public java.lang.String getFirstVerifyCertificateSpki() {
    return this.verifyCertificateSpki.get(0);
  }
  public java.lang.String getLastVerifyCertificateSpki() {
    return this.verifyCertificateSpki.get(verifyCertificateSpki.size() - 1);
  }
  public java.lang.String getMatchingVerifyCertificateSpki(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: verifyCertificateSpki) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingVerifyCertificateSpki(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: verifyCertificateSpki) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withVerifyCertificateSpki(java.util.List<java.lang.String> verifyCertificateSpki) {
    if (verifyCertificateSpki != null) {this.verifyCertificateSpki = new java.util.ArrayList(); for (java.lang.String item : verifyCertificateSpki){this.addToVerifyCertificateSpki(item);}} else { this.verifyCertificateSpki = null;} return (A) this;
  }
  public A withVerifyCertificateSpki(java.lang.String... verifyCertificateSpki) {
    if (this.verifyCertificateSpki != null) {this.verifyCertificateSpki.clear();}
    if (verifyCertificateSpki != null) {for (java.lang.String item :verifyCertificateSpki){ this.addToVerifyCertificateSpki(item);}} return (A) this;
  }
  public java.lang.Boolean hasVerifyCertificateSpki() {
    return verifyCertificateSpki != null && !verifyCertificateSpki.isEmpty();
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ServerTLSSettingsFluentImpl that = (ServerTLSSettingsFluentImpl) o;
    if (caCertificates != null ? !caCertificates.equals(that.caCertificates) :that.caCertificates != null) return false;
    if (cipherSuites != null ? !cipherSuites.equals(that.cipherSuites) :that.cipherSuites != null) return false;
    if (credentialName != null ? !credentialName.equals(that.credentialName) :that.credentialName != null) return false;
    if (httpsRedirect != null ? !httpsRedirect.equals(that.httpsRedirect) :that.httpsRedirect != null) return false;
    if (maxProtocolVersion != null ? !maxProtocolVersion.equals(that.maxProtocolVersion) :that.maxProtocolVersion != null) return false;
    if (minProtocolVersion != null ? !minProtocolVersion.equals(that.minProtocolVersion) :that.minProtocolVersion != null) return false;
    if (mode != null ? !mode.equals(that.mode) :that.mode != null) return false;
    if (privateKey != null ? !privateKey.equals(that.privateKey) :that.privateKey != null) return false;
    if (serverCertificate != null ? !serverCertificate.equals(that.serverCertificate) :that.serverCertificate != null) return false;
    if (subjectAltNames != null ? !subjectAltNames.equals(that.subjectAltNames) :that.subjectAltNames != null) return false;
    if (verifyCertificateHash != null ? !verifyCertificateHash.equals(that.verifyCertificateHash) :that.verifyCertificateHash != null) return false;
    if (verifyCertificateSpki != null ? !verifyCertificateSpki.equals(that.verifyCertificateSpki) :that.verifyCertificateSpki != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(caCertificates,  cipherSuites,  credentialName,  httpsRedirect,  maxProtocolVersion,  minProtocolVersion,  mode,  privateKey,  serverCertificate,  subjectAltNames,  verifyCertificateHash,  verifyCertificateSpki,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (caCertificates != null) { sb.append("caCertificates:"); sb.append(caCertificates + ","); }
    if (cipherSuites != null && !cipherSuites.isEmpty()) { sb.append("cipherSuites:"); sb.append(cipherSuites + ","); }
    if (credentialName != null) { sb.append("credentialName:"); sb.append(credentialName + ","); }
    if (httpsRedirect != null) { sb.append("httpsRedirect:"); sb.append(httpsRedirect + ","); }
    if (maxProtocolVersion != null) { sb.append("maxProtocolVersion:"); sb.append(maxProtocolVersion + ","); }
    if (minProtocolVersion != null) { sb.append("minProtocolVersion:"); sb.append(minProtocolVersion + ","); }
    if (mode != null) { sb.append("mode:"); sb.append(mode + ","); }
    if (privateKey != null) { sb.append("privateKey:"); sb.append(privateKey + ","); }
    if (serverCertificate != null) { sb.append("serverCertificate:"); sb.append(serverCertificate + ","); }
    if (subjectAltNames != null && !subjectAltNames.isEmpty()) { sb.append("subjectAltNames:"); sb.append(subjectAltNames + ","); }
    if (verifyCertificateHash != null && !verifyCertificateHash.isEmpty()) { sb.append("verifyCertificateHash:"); sb.append(verifyCertificateHash + ","); }
    if (verifyCertificateSpki != null && !verifyCertificateSpki.isEmpty()) { sb.append("verifyCertificateSpki:"); sb.append(verifyCertificateSpki); }
    sb.append("}");
    return sb.toString();
  }
  public A withHttpsRedirect() {
    return withHttpsRedirect(true);
  }
  
}