package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class SidecarSpecFluentImpl<A extends SidecarSpecFluent<A>> extends BaseFluent<A> implements SidecarSpecFluent<A>{
  public SidecarSpecFluentImpl() {
  }
  public SidecarSpecFluentImpl(io.fabric8.istio.api.networking.v1beta1.SidecarSpec instance) {
    this.withEgress(instance.getEgress()); 
    this.withIngress(instance.getIngress()); 
    this.withOutboundTrafficPolicy(instance.getOutboundTrafficPolicy()); 
    this.withWorkloadSelector(instance.getWorkloadSelector()); 
  }
  private ArrayList<IstioEgressListenerBuilder> egress = new java.util.ArrayList<IstioEgressListenerBuilder>();
  private java.util.ArrayList<IstioIngressListenerBuilder> ingress = new java.util.ArrayList<IstioIngressListenerBuilder>();
  private OutboundTrafficPolicyBuilder outboundTrafficPolicy;
  private WorkloadSelectorBuilder workloadSelector;
  public A addToEgress(Integer index,io.fabric8.istio.api.networking.v1beta1.IstioEgressListener item) {
    if (this.egress == null) {this.egress = new java.util.ArrayList<io.fabric8.istio.api.networking.v1beta1.IstioEgressListenerBuilder>();}
    io.fabric8.istio.api.networking.v1beta1.IstioEgressListenerBuilder builder = new io.fabric8.istio.api.networking.v1beta1.IstioEgressListenerBuilder(item);_visitables.get("egress").add(index >= 0 ? index : _visitables.get("egress").size(), builder);this.egress.add(index >= 0 ? index : egress.size(), builder); return (A)this;
  }
  public A setToEgress(java.lang.Integer index,io.fabric8.istio.api.networking.v1beta1.IstioEgressListener item) {
    if (this.egress == null) {this.egress = new java.util.ArrayList<io.fabric8.istio.api.networking.v1beta1.IstioEgressListenerBuilder>();}
    io.fabric8.istio.api.networking.v1beta1.IstioEgressListenerBuilder builder = new io.fabric8.istio.api.networking.v1beta1.IstioEgressListenerBuilder(item);
    if (index < 0 || index >= _visitables.get("egress").size()) { _visitables.get("egress").add(builder); } else { _visitables.get("egress").set(index, builder);}
    if (index < 0 || index >= egress.size()) { egress.add(builder); } else { egress.set(index, builder);}
     return (A)this;
  }
  public A addToEgress(io.fabric8.istio.api.networking.v1beta1.IstioEgressListener... items) {
    if (this.egress == null) {this.egress = new java.util.ArrayList<io.fabric8.istio.api.networking.v1beta1.IstioEgressListenerBuilder>();}
    for (io.fabric8.istio.api.networking.v1beta1.IstioEgressListener item : items) {io.fabric8.istio.api.networking.v1beta1.IstioEgressListenerBuilder builder = new io.fabric8.istio.api.networking.v1beta1.IstioEgressListenerBuilder(item);_visitables.get("egress").add(builder);this.egress.add(builder);} return (A)this;
  }
  public A addAllToEgress(Collection<io.fabric8.istio.api.networking.v1beta1.IstioEgressListener> items) {
    if (this.egress == null) {this.egress = new java.util.ArrayList<io.fabric8.istio.api.networking.v1beta1.IstioEgressListenerBuilder>();}
    for (io.fabric8.istio.api.networking.v1beta1.IstioEgressListener item : items) {io.fabric8.istio.api.networking.v1beta1.IstioEgressListenerBuilder builder = new io.fabric8.istio.api.networking.v1beta1.IstioEgressListenerBuilder(item);_visitables.get("egress").add(builder);this.egress.add(builder);} return (A)this;
  }
  public A removeFromEgress(io.fabric8.istio.api.networking.v1beta1.IstioEgressListener... items) {
    for (io.fabric8.istio.api.networking.v1beta1.IstioEgressListener item : items) {io.fabric8.istio.api.networking.v1beta1.IstioEgressListenerBuilder builder = new io.fabric8.istio.api.networking.v1beta1.IstioEgressListenerBuilder(item);_visitables.get("egress").remove(builder);if (this.egress != null) {this.egress.remove(builder);}} return (A)this;
  }
  public A removeAllFromEgress(java.util.Collection<io.fabric8.istio.api.networking.v1beta1.IstioEgressListener> items) {
    for (io.fabric8.istio.api.networking.v1beta1.IstioEgressListener item : items) {io.fabric8.istio.api.networking.v1beta1.IstioEgressListenerBuilder builder = new io.fabric8.istio.api.networking.v1beta1.IstioEgressListenerBuilder(item);_visitables.get("egress").remove(builder);if (this.egress != null) {this.egress.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromEgress(Predicate<io.fabric8.istio.api.networking.v1beta1.IstioEgressListenerBuilder> predicate) {
    if (egress == null) return (A) this;
    final Iterator<io.fabric8.istio.api.networking.v1beta1.IstioEgressListenerBuilder> each = egress.iterator();
    final List visitables = _visitables.get("egress");
    while (each.hasNext()) {
      io.fabric8.istio.api.networking.v1beta1.IstioEgressListenerBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildEgress instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<io.fabric8.istio.api.networking.v1beta1.IstioEgressListener> getEgress() {
    return egress != null ? build(egress) : null;
  }
  public java.util.List<io.fabric8.istio.api.networking.v1beta1.IstioEgressListener> buildEgress() {
    return egress != null ? build(egress) : null;
  }
  public io.fabric8.istio.api.networking.v1beta1.IstioEgressListener buildEgress(java.lang.Integer index) {
    return this.egress.get(index).build();
  }
  public io.fabric8.istio.api.networking.v1beta1.IstioEgressListener buildFirstEgress() {
    return this.egress.get(0).build();
  }
  public io.fabric8.istio.api.networking.v1beta1.IstioEgressListener buildLastEgress() {
    return this.egress.get(egress.size() - 1).build();
  }
  public io.fabric8.istio.api.networking.v1beta1.IstioEgressListener buildMatchingEgress(java.util.function.Predicate<io.fabric8.istio.api.networking.v1beta1.IstioEgressListenerBuilder> predicate) {
    for (io.fabric8.istio.api.networking.v1beta1.IstioEgressListenerBuilder item: egress) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingEgress(java.util.function.Predicate<io.fabric8.istio.api.networking.v1beta1.IstioEgressListenerBuilder> predicate) {
    for (io.fabric8.istio.api.networking.v1beta1.IstioEgressListenerBuilder item: egress) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withEgress(java.util.List<io.fabric8.istio.api.networking.v1beta1.IstioEgressListener> egress) {
    if (this.egress != null) { _visitables.get("egress").removeAll(this.egress);}
    if (egress != null) {this.egress = new java.util.ArrayList(); for (io.fabric8.istio.api.networking.v1beta1.IstioEgressListener item : egress){this.addToEgress(item);}} else { this.egress = null;} return (A) this;
  }
  public A withEgress(io.fabric8.istio.api.networking.v1beta1.IstioEgressListener... egress) {
    if (this.egress != null) {this.egress.clear();}
    if (egress != null) {for (io.fabric8.istio.api.networking.v1beta1.IstioEgressListener item :egress){ this.addToEgress(item);}} return (A) this;
  }
  public java.lang.Boolean hasEgress() {
    return egress != null && !egress.isEmpty();
  }
  public SidecarSpecFluent.EgressNested<A> addNewEgress() {
    return new SidecarSpecFluentImpl.EgressNestedImpl();
  }
  public io.fabric8.istio.api.networking.v1beta1.SidecarSpecFluent.EgressNested<A> addNewEgressLike(io.fabric8.istio.api.networking.v1beta1.IstioEgressListener item) {
    return new SidecarSpecFluentImpl.EgressNestedImpl(-1, item);
  }
  public io.fabric8.istio.api.networking.v1beta1.SidecarSpecFluent.EgressNested<A> setNewEgressLike(java.lang.Integer index,io.fabric8.istio.api.networking.v1beta1.IstioEgressListener item) {
    return new io.fabric8.istio.api.networking.v1beta1.SidecarSpecFluentImpl.EgressNestedImpl(index, item);
  }
  public io.fabric8.istio.api.networking.v1beta1.SidecarSpecFluent.EgressNested<A> editEgress(java.lang.Integer index) {
    if (egress.size() <= index) throw new RuntimeException("Can't edit egress. Index exceeds size.");
    return setNewEgressLike(index, buildEgress(index));
  }
  public io.fabric8.istio.api.networking.v1beta1.SidecarSpecFluent.EgressNested<A> editFirstEgress() {
    if (egress.size() == 0) throw new RuntimeException("Can't edit first egress. The list is empty.");
    return setNewEgressLike(0, buildEgress(0));
  }
  public io.fabric8.istio.api.networking.v1beta1.SidecarSpecFluent.EgressNested<A> editLastEgress() {
    int index = egress.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last egress. The list is empty.");
    return setNewEgressLike(index, buildEgress(index));
  }
  public io.fabric8.istio.api.networking.v1beta1.SidecarSpecFluent.EgressNested<A> editMatchingEgress(java.util.function.Predicate<io.fabric8.istio.api.networking.v1beta1.IstioEgressListenerBuilder> predicate) {
    int index = -1;
    for (int i=0;i<egress.size();i++) { 
    if (predicate.test(egress.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching egress. No match found.");
    return setNewEgressLike(index, buildEgress(index));
  }
  public A addToIngress(java.lang.Integer index,io.fabric8.istio.api.networking.v1beta1.IstioIngressListener item) {
    if (this.ingress == null) {this.ingress = new java.util.ArrayList<io.fabric8.istio.api.networking.v1beta1.IstioIngressListenerBuilder>();}
    io.fabric8.istio.api.networking.v1beta1.IstioIngressListenerBuilder builder = new io.fabric8.istio.api.networking.v1beta1.IstioIngressListenerBuilder(item);_visitables.get("ingress").add(index >= 0 ? index : _visitables.get("ingress").size(), builder);this.ingress.add(index >= 0 ? index : ingress.size(), builder); return (A)this;
  }
  public A setToIngress(java.lang.Integer index,io.fabric8.istio.api.networking.v1beta1.IstioIngressListener item) {
    if (this.ingress == null) {this.ingress = new java.util.ArrayList<io.fabric8.istio.api.networking.v1beta1.IstioIngressListenerBuilder>();}
    io.fabric8.istio.api.networking.v1beta1.IstioIngressListenerBuilder builder = new io.fabric8.istio.api.networking.v1beta1.IstioIngressListenerBuilder(item);
    if (index < 0 || index >= _visitables.get("ingress").size()) { _visitables.get("ingress").add(builder); } else { _visitables.get("ingress").set(index, builder);}
    if (index < 0 || index >= ingress.size()) { ingress.add(builder); } else { ingress.set(index, builder);}
     return (A)this;
  }
  public A addToIngress(io.fabric8.istio.api.networking.v1beta1.IstioIngressListener... items) {
    if (this.ingress == null) {this.ingress = new java.util.ArrayList<io.fabric8.istio.api.networking.v1beta1.IstioIngressListenerBuilder>();}
    for (io.fabric8.istio.api.networking.v1beta1.IstioIngressListener item : items) {io.fabric8.istio.api.networking.v1beta1.IstioIngressListenerBuilder builder = new io.fabric8.istio.api.networking.v1beta1.IstioIngressListenerBuilder(item);_visitables.get("ingress").add(builder);this.ingress.add(builder);} return (A)this;
  }
  public A addAllToIngress(java.util.Collection<io.fabric8.istio.api.networking.v1beta1.IstioIngressListener> items) {
    if (this.ingress == null) {this.ingress = new java.util.ArrayList<io.fabric8.istio.api.networking.v1beta1.IstioIngressListenerBuilder>();}
    for (io.fabric8.istio.api.networking.v1beta1.IstioIngressListener item : items) {io.fabric8.istio.api.networking.v1beta1.IstioIngressListenerBuilder builder = new io.fabric8.istio.api.networking.v1beta1.IstioIngressListenerBuilder(item);_visitables.get("ingress").add(builder);this.ingress.add(builder);} return (A)this;
  }
  public A removeFromIngress(io.fabric8.istio.api.networking.v1beta1.IstioIngressListener... items) {
    for (io.fabric8.istio.api.networking.v1beta1.IstioIngressListener item : items) {io.fabric8.istio.api.networking.v1beta1.IstioIngressListenerBuilder builder = new io.fabric8.istio.api.networking.v1beta1.IstioIngressListenerBuilder(item);_visitables.get("ingress").remove(builder);if (this.ingress != null) {this.ingress.remove(builder);}} return (A)this;
  }
  public A removeAllFromIngress(java.util.Collection<io.fabric8.istio.api.networking.v1beta1.IstioIngressListener> items) {
    for (io.fabric8.istio.api.networking.v1beta1.IstioIngressListener item : items) {io.fabric8.istio.api.networking.v1beta1.IstioIngressListenerBuilder builder = new io.fabric8.istio.api.networking.v1beta1.IstioIngressListenerBuilder(item);_visitables.get("ingress").remove(builder);if (this.ingress != null) {this.ingress.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromIngress(java.util.function.Predicate<io.fabric8.istio.api.networking.v1beta1.IstioIngressListenerBuilder> predicate) {
    if (ingress == null) return (A) this;
    final Iterator<io.fabric8.istio.api.networking.v1beta1.IstioIngressListenerBuilder> each = ingress.iterator();
    final List visitables = _visitables.get("ingress");
    while (each.hasNext()) {
      io.fabric8.istio.api.networking.v1beta1.IstioIngressListenerBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildIngress instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.istio.api.networking.v1beta1.IstioIngressListener> getIngress() {
    return ingress != null ? build(ingress) : null;
  }
  public java.util.List<io.fabric8.istio.api.networking.v1beta1.IstioIngressListener> buildIngress() {
    return ingress != null ? build(ingress) : null;
  }
  public io.fabric8.istio.api.networking.v1beta1.IstioIngressListener buildIngress(java.lang.Integer index) {
    return this.ingress.get(index).build();
  }
  public io.fabric8.istio.api.networking.v1beta1.IstioIngressListener buildFirstIngress() {
    return this.ingress.get(0).build();
  }
  public io.fabric8.istio.api.networking.v1beta1.IstioIngressListener buildLastIngress() {
    return this.ingress.get(ingress.size() - 1).build();
  }
  public io.fabric8.istio.api.networking.v1beta1.IstioIngressListener buildMatchingIngress(java.util.function.Predicate<io.fabric8.istio.api.networking.v1beta1.IstioIngressListenerBuilder> predicate) {
    for (io.fabric8.istio.api.networking.v1beta1.IstioIngressListenerBuilder item: ingress) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingIngress(java.util.function.Predicate<io.fabric8.istio.api.networking.v1beta1.IstioIngressListenerBuilder> predicate) {
    for (io.fabric8.istio.api.networking.v1beta1.IstioIngressListenerBuilder item: ingress) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withIngress(java.util.List<io.fabric8.istio.api.networking.v1beta1.IstioIngressListener> ingress) {
    if (this.ingress != null) { _visitables.get("ingress").removeAll(this.ingress);}
    if (ingress != null) {this.ingress = new java.util.ArrayList(); for (io.fabric8.istio.api.networking.v1beta1.IstioIngressListener item : ingress){this.addToIngress(item);}} else { this.ingress = null;} return (A) this;
  }
  public A withIngress(io.fabric8.istio.api.networking.v1beta1.IstioIngressListener... ingress) {
    if (this.ingress != null) {this.ingress.clear();}
    if (ingress != null) {for (io.fabric8.istio.api.networking.v1beta1.IstioIngressListener item :ingress){ this.addToIngress(item);}} return (A) this;
  }
  public java.lang.Boolean hasIngress() {
    return ingress != null && !ingress.isEmpty();
  }
  public SidecarSpecFluent.IngressNested<A> addNewIngress() {
    return new SidecarSpecFluentImpl.IngressNestedImpl();
  }
  public io.fabric8.istio.api.networking.v1beta1.SidecarSpecFluent.IngressNested<A> addNewIngressLike(io.fabric8.istio.api.networking.v1beta1.IstioIngressListener item) {
    return new io.fabric8.istio.api.networking.v1beta1.SidecarSpecFluentImpl.IngressNestedImpl(-1, item);
  }
  public io.fabric8.istio.api.networking.v1beta1.SidecarSpecFluent.IngressNested<A> setNewIngressLike(java.lang.Integer index,io.fabric8.istio.api.networking.v1beta1.IstioIngressListener item) {
    return new io.fabric8.istio.api.networking.v1beta1.SidecarSpecFluentImpl.IngressNestedImpl(index, item);
  }
  public io.fabric8.istio.api.networking.v1beta1.SidecarSpecFluent.IngressNested<A> editIngress(java.lang.Integer index) {
    if (ingress.size() <= index) throw new RuntimeException("Can't edit ingress. Index exceeds size.");
    return setNewIngressLike(index, buildIngress(index));
  }
  public io.fabric8.istio.api.networking.v1beta1.SidecarSpecFluent.IngressNested<A> editFirstIngress() {
    if (ingress.size() == 0) throw new RuntimeException("Can't edit first ingress. The list is empty.");
    return setNewIngressLike(0, buildIngress(0));
  }
  public io.fabric8.istio.api.networking.v1beta1.SidecarSpecFluent.IngressNested<A> editLastIngress() {
    int index = ingress.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last ingress. The list is empty.");
    return setNewIngressLike(index, buildIngress(index));
  }
  public io.fabric8.istio.api.networking.v1beta1.SidecarSpecFluent.IngressNested<A> editMatchingIngress(java.util.function.Predicate<io.fabric8.istio.api.networking.v1beta1.IstioIngressListenerBuilder> predicate) {
    int index = -1;
    for (int i=0;i<ingress.size();i++) { 
    if (predicate.test(ingress.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching ingress. No match found.");
    return setNewIngressLike(index, buildIngress(index));
  }
  
  /**
   * This method has been deprecated, please use method buildOutboundTrafficPolicy instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public OutboundTrafficPolicy getOutboundTrafficPolicy() {
    return this.outboundTrafficPolicy!=null ?this.outboundTrafficPolicy.build():null;
  }
  public io.fabric8.istio.api.networking.v1beta1.OutboundTrafficPolicy buildOutboundTrafficPolicy() {
    return this.outboundTrafficPolicy!=null ?this.outboundTrafficPolicy.build():null;
  }
  public A withOutboundTrafficPolicy(io.fabric8.istio.api.networking.v1beta1.OutboundTrafficPolicy outboundTrafficPolicy) {
    _visitables.get("outboundTrafficPolicy").remove(this.outboundTrafficPolicy);
    if (outboundTrafficPolicy!=null){ this.outboundTrafficPolicy= new io.fabric8.istio.api.networking.v1beta1.OutboundTrafficPolicyBuilder(outboundTrafficPolicy); _visitables.get("outboundTrafficPolicy").add(this.outboundTrafficPolicy);} return (A) this;
  }
  public java.lang.Boolean hasOutboundTrafficPolicy() {
    return this.outboundTrafficPolicy != null;
  }
  public SidecarSpecFluent.OutboundTrafficPolicyNested<A> withNewOutboundTrafficPolicy() {
    return new SidecarSpecFluentImpl.OutboundTrafficPolicyNestedImpl();
  }
  public io.fabric8.istio.api.networking.v1beta1.SidecarSpecFluent.OutboundTrafficPolicyNested<A> withNewOutboundTrafficPolicyLike(io.fabric8.istio.api.networking.v1beta1.OutboundTrafficPolicy item) {
    return new io.fabric8.istio.api.networking.v1beta1.SidecarSpecFluentImpl.OutboundTrafficPolicyNestedImpl(item);
  }
  public io.fabric8.istio.api.networking.v1beta1.SidecarSpecFluent.OutboundTrafficPolicyNested<A> editOutboundTrafficPolicy() {
    return withNewOutboundTrafficPolicyLike(getOutboundTrafficPolicy());
  }
  public io.fabric8.istio.api.networking.v1beta1.SidecarSpecFluent.OutboundTrafficPolicyNested<A> editOrNewOutboundTrafficPolicy() {
    return withNewOutboundTrafficPolicyLike(getOutboundTrafficPolicy() != null ? getOutboundTrafficPolicy(): new io.fabric8.istio.api.networking.v1beta1.OutboundTrafficPolicyBuilder().build());
  }
  public io.fabric8.istio.api.networking.v1beta1.SidecarSpecFluent.OutboundTrafficPolicyNested<A> editOrNewOutboundTrafficPolicyLike(io.fabric8.istio.api.networking.v1beta1.OutboundTrafficPolicy item) {
    return withNewOutboundTrafficPolicyLike(getOutboundTrafficPolicy() != null ? getOutboundTrafficPolicy(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildWorkloadSelector instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.istio.api.networking.v1beta1.WorkloadSelector getWorkloadSelector() {
    return this.workloadSelector!=null ?this.workloadSelector.build():null;
  }
  public io.fabric8.istio.api.networking.v1beta1.WorkloadSelector buildWorkloadSelector() {
    return this.workloadSelector!=null ?this.workloadSelector.build():null;
  }
  public A withWorkloadSelector(io.fabric8.istio.api.networking.v1beta1.WorkloadSelector workloadSelector) {
    _visitables.get("workloadSelector").remove(this.workloadSelector);
    if (workloadSelector!=null){ this.workloadSelector= new WorkloadSelectorBuilder(workloadSelector); _visitables.get("workloadSelector").add(this.workloadSelector);} return (A) this;
  }
  public java.lang.Boolean hasWorkloadSelector() {
    return this.workloadSelector != null;
  }
  public SidecarSpecFluent.WorkloadSelectorNested<A> withNewWorkloadSelector() {
    return new SidecarSpecFluentImpl.WorkloadSelectorNestedImpl();
  }
  public io.fabric8.istio.api.networking.v1beta1.SidecarSpecFluent.WorkloadSelectorNested<A> withNewWorkloadSelectorLike(io.fabric8.istio.api.networking.v1beta1.WorkloadSelector item) {
    return new io.fabric8.istio.api.networking.v1beta1.SidecarSpecFluentImpl.WorkloadSelectorNestedImpl(item);
  }
  public io.fabric8.istio.api.networking.v1beta1.SidecarSpecFluent.WorkloadSelectorNested<A> editWorkloadSelector() {
    return withNewWorkloadSelectorLike(getWorkloadSelector());
  }
  public io.fabric8.istio.api.networking.v1beta1.SidecarSpecFluent.WorkloadSelectorNested<A> editOrNewWorkloadSelector() {
    return withNewWorkloadSelectorLike(getWorkloadSelector() != null ? getWorkloadSelector(): new io.fabric8.istio.api.networking.v1beta1.WorkloadSelectorBuilder().build());
  }
  public io.fabric8.istio.api.networking.v1beta1.SidecarSpecFluent.WorkloadSelectorNested<A> editOrNewWorkloadSelectorLike(io.fabric8.istio.api.networking.v1beta1.WorkloadSelector item) {
    return withNewWorkloadSelectorLike(getWorkloadSelector() != null ? getWorkloadSelector(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SidecarSpecFluentImpl that = (SidecarSpecFluentImpl) o;
    if (egress != null ? !egress.equals(that.egress) :that.egress != null) return false;
    if (ingress != null ? !ingress.equals(that.ingress) :that.ingress != null) return false;
    if (outboundTrafficPolicy != null ? !outboundTrafficPolicy.equals(that.outboundTrafficPolicy) :that.outboundTrafficPolicy != null) return false;
    if (workloadSelector != null ? !workloadSelector.equals(that.workloadSelector) :that.workloadSelector != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(egress,  ingress,  outboundTrafficPolicy,  workloadSelector,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (egress != null && !egress.isEmpty()) { sb.append("egress:"); sb.append(egress + ","); }
    if (ingress != null && !ingress.isEmpty()) { sb.append("ingress:"); sb.append(ingress + ","); }
    if (outboundTrafficPolicy != null) { sb.append("outboundTrafficPolicy:"); sb.append(outboundTrafficPolicy + ","); }
    if (workloadSelector != null) { sb.append("workloadSelector:"); sb.append(workloadSelector); }
    sb.append("}");
    return sb.toString();
  }
  class EgressNestedImpl<N> extends IstioEgressListenerFluentImpl<SidecarSpecFluent.EgressNested<N>> implements io.fabric8.istio.api.networking.v1beta1.SidecarSpecFluent.EgressNested<N>,Nested<N>{
    EgressNestedImpl(java.lang.Integer index,IstioEgressListener item) {
      this.index = index;
      this.builder = new IstioEgressListenerBuilder(this, item);
    }
    EgressNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.istio.api.networking.v1beta1.IstioEgressListenerBuilder(this);
    }
    io.fabric8.istio.api.networking.v1beta1.IstioEgressListenerBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) SidecarSpecFluentImpl.this.setToEgress(index,builder.build());
    }
    public N endEgress() {
      return and();
    }
    
  }
  class IngressNestedImpl<N> extends IstioIngressListenerFluentImpl<SidecarSpecFluent.IngressNested<N>> implements io.fabric8.istio.api.networking.v1beta1.SidecarSpecFluent.IngressNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    IngressNestedImpl(java.lang.Integer index,IstioIngressListener item) {
      this.index = index;
      this.builder = new IstioIngressListenerBuilder(this, item);
    }
    IngressNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.istio.api.networking.v1beta1.IstioIngressListenerBuilder(this);
    }
    io.fabric8.istio.api.networking.v1beta1.IstioIngressListenerBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) SidecarSpecFluentImpl.this.setToIngress(index,builder.build());
    }
    public N endIngress() {
      return and();
    }
    
  }
  class OutboundTrafficPolicyNestedImpl<N> extends OutboundTrafficPolicyFluentImpl<SidecarSpecFluent.OutboundTrafficPolicyNested<N>> implements io.fabric8.istio.api.networking.v1beta1.SidecarSpecFluent.OutboundTrafficPolicyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    OutboundTrafficPolicyNestedImpl(OutboundTrafficPolicy item) {
      this.builder = new OutboundTrafficPolicyBuilder(this, item);
    }
    OutboundTrafficPolicyNestedImpl() {
      this.builder = new io.fabric8.istio.api.networking.v1beta1.OutboundTrafficPolicyBuilder(this);
    }
    io.fabric8.istio.api.networking.v1beta1.OutboundTrafficPolicyBuilder builder;
    public N and() {
      return (N) SidecarSpecFluentImpl.this.withOutboundTrafficPolicy(builder.build());
    }
    public N endOutboundTrafficPolicy() {
      return and();
    }
    
  }
  class WorkloadSelectorNestedImpl<N> extends WorkloadSelectorFluentImpl<SidecarSpecFluent.WorkloadSelectorNested<N>> implements io.fabric8.istio.api.networking.v1beta1.SidecarSpecFluent.WorkloadSelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    WorkloadSelectorNestedImpl(io.fabric8.istio.api.networking.v1beta1.WorkloadSelector item) {
      this.builder = new WorkloadSelectorBuilder(this, item);
    }
    WorkloadSelectorNestedImpl() {
      this.builder = new io.fabric8.istio.api.networking.v1beta1.WorkloadSelectorBuilder(this);
    }
    io.fabric8.istio.api.networking.v1beta1.WorkloadSelectorBuilder builder;
    public N and() {
      return (N) SidecarSpecFluentImpl.this.withWorkloadSelector(builder.build());
    }
    public N endWorkloadSelector() {
      return and();
    }
    
  }
  
}