package io.fabric8.istio.api.security.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class JWTHeaderBuilder extends JWTHeaderFluentImpl<JWTHeaderBuilder> implements VisitableBuilder<io.fabric8.istio.api.security.v1beta1.JWTHeader,JWTHeaderBuilder>{
  public JWTHeaderBuilder() {
    this(false);
  }
  public JWTHeaderBuilder(Boolean validationEnabled) {
    this(new JWTHeader(), validationEnabled);
  }
  public JWTHeaderBuilder(io.fabric8.istio.api.security.v1beta1.JWTHeaderFluent<?> fluent) {
    this(fluent, false);
  }
  public JWTHeaderBuilder(io.fabric8.istio.api.security.v1beta1.JWTHeaderFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new JWTHeader(), validationEnabled);
  }
  public JWTHeaderBuilder(io.fabric8.istio.api.security.v1beta1.JWTHeaderFluent<?> fluent,io.fabric8.istio.api.security.v1beta1.JWTHeader instance) {
    this(fluent, instance, false);
  }
  public JWTHeaderBuilder(io.fabric8.istio.api.security.v1beta1.JWTHeaderFluent<?> fluent,io.fabric8.istio.api.security.v1beta1.JWTHeader instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withPrefix(instance.getPrefix()); 
    this.validationEnabled = validationEnabled; 
  }
  public JWTHeaderBuilder(io.fabric8.istio.api.security.v1beta1.JWTHeader instance) {
    this(instance,false);
  }
  public JWTHeaderBuilder(io.fabric8.istio.api.security.v1beta1.JWTHeader instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withPrefix(instance.getPrefix()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.istio.api.security.v1beta1.JWTHeaderFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.istio.api.security.v1beta1.JWTHeader build() {
    JWTHeader buildable = new JWTHeader(fluent.getName(),fluent.getPrefix());
    return buildable;
  }
  
}